/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.cache;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.Weigher;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.apache.jackrabbit.oak.commons.annotations.Internal;
import org.apache.jackrabbit.oak.spi.GuavaDeprecation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="2022-12-01")
@Internal(since="1.1.1")
public class CacheLIRS<K, V>
implements LoadingCache<K, V> {
    static final Logger LOG = LoggerFactory.getLogger(CacheLIRS.class);
    static final ThreadLocal<Integer> CURRENTLY_LOADING = new ThreadLocal();
    private static final AtomicInteger NEXT_CACHE_ID = new AtomicInteger();
    private static final boolean PUT_HOT = Boolean.parseBoolean(System.getProperty("oak.cacheLIRS.putHot", "true"));
    private static final List<String> ALLOWED_USERS = Collections.unmodifiableList(Arrays.asList("org.apache.jackrabbit.oak.plugins.blob.", "org.apache.jackrabbit.oak.plugins.document.", "org.apache.jackrabbit.oak.segment.", "org.apache.jackrabbit.oak.plugins.segment."));
    final int cacheId = NEXT_CACHE_ID.getAndIncrement();
    private long maxMemory;
    private int averageMemory;
    private final Segment<K, V>[] segments;
    private final int segmentCount;
    private final int segmentShift;
    private final int segmentMask;
    private final int stackMoveDistance;
    private final Weigher<K, V> weigher;
    private final CacheLoader<K, V> loader;
    private final EvictionCallback<K, V> evicted;
    final ConcurrentHashMap<K, AtomicBoolean> loadingInProgress = new ConcurrentHashMap();

    public CacheLIRS(int maxEntries) {
        this(null, maxEntries, 1, 16, maxEntries / 100, null, null, null);
    }

    CacheLIRS(Weigher<K, V> weigher, long maxMemory, int averageMemory, int segmentCount, int stackMoveDistance, CacheLoader<K, V> loader, EvictionCallback<K, V> evicted, String module) {
        GuavaDeprecation.handleCall((String)"OAK-8702", (String)CacheLIRS.class.getName(), ALLOWED_USERS);
        LOG.debug("Init #{}, module={}, maxMemory={}, segmentCount={}, stackMoveDistance={}", this.cacheId, module, maxMemory, segmentCount, segmentCount);
        this.weigher = weigher;
        this.setMaxMemory(maxMemory);
        this.setAverageMemory(averageMemory);
        if (Integer.bitCount(segmentCount) != 1) {
            throw new IllegalArgumentException("The segment count must be a power of 2, is " + segmentCount);
        }
        this.segmentCount = segmentCount;
        this.segmentMask = segmentCount - 1;
        this.stackMoveDistance = stackMoveDistance;
        this.segments = new Segment[segmentCount];
        this.evicted = evicted;
        this.invalidateAll();
        this.segmentShift = Integer.numberOfTrailingZeros(this.segments[0].entries.length);
        this.loader = loader;
    }

    @Override
    public void invalidateAll() {
        long max = Math.max(1L, this.maxMemory / (long)this.segmentCount);
        for (int i = 0; i < this.segmentCount; ++i) {
            Segment<K, V> old = this.segments[i];
            Segment s = new Segment(this, max, this.averageMemory, this.stackMoveDistance);
            if (old != null) {
                s.hitCount = old.hitCount;
                s.missCount = old.missCount;
                s.loadSuccessCount = old.loadSuccessCount;
                s.loadExceptionCount = old.loadExceptionCount;
                s.totalLoadTime = old.totalLoadTime;
                s.evictionCount = old.evictionCount;
            }
            this.setSegment(i, s);
        }
    }

    private void setSegment(int index, Segment<K, V> s) {
        Segment<K, V> old = this.segments[index];
        this.segments[index] = s;
        if (this.evicted != null && old != null && old != s) {
            old.evictedAll(RemovalCause.EXPLICIT);
        }
    }

    void evicted(Entry<K, V> entry, RemovalCause cause) {
        if (this.evicted == null) {
            return;
        }
        Object key = entry.key;
        if (key != null) {
            this.evicted.evicted(key, entry.value, cause);
        }
    }

    public boolean containsKey(Object key) {
        int hash = CacheLIRS.getHash(key);
        return this.getSegment(hash).containsKey(key, hash);
    }

    public V peek(K key) {
        int hash = CacheLIRS.getHash(key);
        Entry<K, V> e = this.getSegment(hash).find(key, hash);
        return e == null ? null : (V)e.value;
    }

    public V put(K key, V value, int memory) {
        int hash = CacheLIRS.getHash(key);
        return this.getSegment(hash).put(key, hash, value, memory);
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, this.sizeOf(key, value));
    }

    @Override
    public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
        int hash = CacheLIRS.getHash(key);
        return this.getSegment(hash).get(key, hash, valueLoader);
    }

    @Override
    public V getUnchecked(K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e);
        }
    }

    @Override
    public V get(K key) throws ExecutionException {
        int hash = CacheLIRS.getHash(key);
        return this.getSegment(hash).get(key, hash, this.loader);
    }

    @Override
    public void refresh(K key) {
        int hash = CacheLIRS.getHash(key);
        try {
            this.getSegment(hash).refresh(key, hash, this.loader);
        }
        catch (ExecutionException e) {
            LOG.warn("Could not refresh value for key " + key, e);
        }
    }

    V replace(K key, V value) {
        int hash = CacheLIRS.getHash(key);
        return this.getSegment(hash).replace(key, hash, value, this.sizeOf(key, value));
    }

    boolean replace(K key, V oldValue, V newValue) {
        int hash = CacheLIRS.getHash(key);
        return this.getSegment(hash).replace(key, hash, oldValue, newValue, this.sizeOf(key, newValue));
    }

    boolean remove(Object key, Object value) {
        int hash = CacheLIRS.getHash(key);
        return this.getSegment(hash).remove(key, hash, value);
    }

    protected V putIfAbsent(K key, V value) {
        int hash = CacheLIRS.getHash(key);
        return this.getSegment(hash).putIfAbsent(key, hash, value, this.sizeOf(key, value));
    }

    @Override
    @Nullable
    public V getIfPresent(Object key) {
        int hash = CacheLIRS.getHash(key);
        return this.getSegment(hash).get(key, hash);
    }

    protected int sizeOf(K key, V value) {
        if (this.weigher == null) {
            return this.averageMemory;
        }
        return this.weigher.weigh(key, value);
    }

    @Override
    public void invalidate(Object key) {
        int hash = CacheLIRS.getHash(key);
        this.getSegment(hash).invalidate(key, hash, RemovalCause.EXPLICIT);
    }

    public V remove(Object key) {
        int hash = CacheLIRS.getHash(key);
        return this.getSegment(hash).remove(key, hash);
    }

    @Override
    public void invalidateAll(Iterable<?> keys) {
        for (Object k : keys) {
            this.invalidate(k);
        }
    }

    public int getMemory(K key) {
        int hash = CacheLIRS.getHash(key);
        return this.getSegment(hash).getMemory(key, hash);
    }

    private Segment<K, V> getSegment(int hash) {
        int segmentIndex = hash >>> this.segmentShift & this.segmentMask;
        return this.segments[segmentIndex];
    }

    static int getHash(Object key) {
        int hash = key.hashCode();
        hash = (hash >>> 16 ^ hash) * 73244475;
        hash = (hash >>> 16 ^ hash) * 73244475;
        hash = hash >>> 16 ^ hash;
        return hash;
    }

    public long getUsedMemory() {
        long x = 0L;
        for (Segment<K, V> s : this.segments) {
            x += s.usedMemory;
        }
        return x;
    }

    public void setMaxMemory(long maxMemory) {
        if (maxMemory < 0L) {
            throw new IllegalArgumentException("Max memory must not be negative");
        }
        this.maxMemory = maxMemory;
        if (this.segments != null) {
            long max = 1L + maxMemory / (long)this.segments.length;
            for (Segment<K, V> s : this.segments) {
                s.setMaxMemory(max);
            }
        }
    }

    public void setAverageMemory(int averageMemory) {
        if (averageMemory <= 0) {
            throw new IllegalArgumentException("Average memory must be larger than 0");
        }
        this.averageMemory = averageMemory;
        if (this.segments != null) {
            for (Segment<K, V> s : this.segments) {
                s.setAverageMemory(averageMemory);
            }
        }
    }

    public int getAverageMemory() {
        return this.averageMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public synchronized Set<Map.Entry<K, V>> entrySet() {
        HashMap<K, V> map = new HashMap<K, V>();
        for (K k : this.keySet()) {
            V v = this.peek(k);
            if (v == null) continue;
            map.put(k, v);
        }
        return map.entrySet();
    }

    protected Collection<V> values() {
        ArrayList<V> list = new ArrayList<V>();
        for (K k : this.keySet()) {
            V v = this.peek(k);
            if (v == null) continue;
            list.add(v);
        }
        return list;
    }

    boolean containsValue(Object value) {
        for (Segment<K, V> s : this.segments) {
            for (K k : s.keySet()) {
                V v = this.peek(k);
                if (v == null || !v.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized Set<K> keySet() {
        HashSet<K> set = new HashSet<K>();
        for (Segment<K, V> s : this.segments) {
            set.addAll(s.keySet());
        }
        return set;
    }

    public int sizeNonResident() {
        int x = 0;
        for (Segment<K, V> s : this.segments) {
            x += s.queue2Size;
        }
        return x;
    }

    public int sizeMapArray() {
        int x = 0;
        for (Segment<K, V> s : this.segments) {
            x += s.entries.length;
        }
        return x;
    }

    public int sizeHot() {
        int x = 0;
        for (Segment<K, V> s : this.segments) {
            x += s.mapSize - s.queueSize - s.queue2Size;
        }
        return x;
    }

    @Override
    public long size() {
        int x = 0;
        for (Segment<K, V> s : this.segments) {
            x += s.mapSize - s.queue2Size;
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Segment<K, V>[] segmentArray = this.segments;
        int n = segmentArray.length;
        for (int i = 0; i < n; ++i) {
            Segment<K, V> s;
            Segment<K, V> segment = s = segmentArray[i];
            synchronized (segment) {
                if (this.evicted != null) {
                    s.evictedAll(RemovalCause.EXPLICIT);
                }
                s.clear();
                continue;
            }
        }
    }

    public synchronized List<K> keys(boolean cold, boolean nonResident) {
        ArrayList<K> keys = new ArrayList<K>();
        for (Segment<K, V> s : this.segments) {
            keys.addAll(s.keys(cold, nonResident));
        }
        return keys;
    }

    @Override
    public CacheStats stats() {
        long hitCount = 0L;
        long missCount = 0L;
        long loadSuccessCount = 0L;
        long loadExceptionCount = 0L;
        long totalLoadTime = 0L;
        long evictionCount = 0L;
        for (Segment<K, V> s : this.segments) {
            hitCount += s.hitCount.longValue();
            missCount += s.missCount.longValue();
            loadSuccessCount += s.loadSuccessCount.longValue();
            loadExceptionCount += s.loadExceptionCount.longValue();
            totalLoadTime += s.totalLoadTime.longValue();
            evictionCount += s.evictionCount.longValue();
        }
        CacheStats stats = new CacheStats(hitCount, missCount, loadSuccessCount, loadExceptionCount, totalLoadTime, evictionCount);
        return stats;
    }

    public static <K, V> Builder<K, V> newBuilder() {
        return new Builder();
    }

    @Override
    public ImmutableMap<K, V> getAllPresent(Iterable<?> keys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        return new ConcurrentMap<K, V>(){

            @Override
            public int size() {
                long size = CacheLIRS.this.size();
                return (int)Math.min(size, Integer.MAX_VALUE);
            }

            @Override
            public boolean isEmpty() {
                return CacheLIRS.this.size() == 0L;
            }

            @Override
            public boolean containsKey(Object key) {
                return CacheLIRS.this.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return CacheLIRS.this.containsValue(value);
            }

            @Override
            public V get(Object key) {
                return CacheLIRS.this.peek(key);
            }

            @Override
            public V put(K key, V value) {
                return CacheLIRS.this.put(key, value, CacheLIRS.this.sizeOf(key, value));
            }

            @Override
            public V remove(Object key) {
                Object old = CacheLIRS.this.getUnchecked(key);
                CacheLIRS.this.invalidate(key);
                return old;
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> m) {
                for (Map.Entry e : m.entrySet()) {
                    this.put(e.getKey(), e.getValue());
                }
            }

            @Override
            public void clear() {
                CacheLIRS.this.clear();
            }

            @Override
            public Set<K> keySet() {
                return CacheLIRS.this.keySet();
            }

            @Override
            public Collection<V> values() {
                return CacheLIRS.this.values();
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return CacheLIRS.this.entrySet();
            }

            @Override
            public V putIfAbsent(K key, V value) {
                return CacheLIRS.this.putIfAbsent(key, value);
            }

            @Override
            public boolean remove(Object key, Object value) {
                return CacheLIRS.this.remove(key, value);
            }

            @Override
            public boolean replace(K key, V oldValue, V newValue) {
                return CacheLIRS.this.replace(key, oldValue, newValue);
            }

            @Override
            public V replace(K key, V value) {
                return CacheLIRS.this.replace(key, value);
            }
        };
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public V apply(K key) {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    @Deprecated(since="2022-12-01")
    public static class Builder<K, V> {
        private String module;
        private Weigher<K, V> weigher;
        private long maxWeight;
        private int averageWeight = 100;
        private int segmentCount = 16;
        private int stackMoveDistance = 16;
        private EvictionCallback<K, V> evicted;

        public Builder<K, V> recordStats() {
            return this;
        }

        public Builder<K, V> module(String module) {
            this.module = module;
            return this;
        }

        public Builder<K, V> weigher(Weigher<K, V> weigher) {
            this.weigher = weigher;
            return this;
        }

        public Builder<K, V> maximumWeight(long maxWeight) {
            this.maxWeight = maxWeight;
            return this;
        }

        public Builder<K, V> averageWeight(int averageWeight) {
            this.averageWeight = averageWeight;
            return this;
        }

        public Builder<K, V> maximumSize(long maxSize) {
            this.maxWeight = maxSize;
            this.averageWeight = 1;
            return this;
        }

        public Builder<K, V> segmentCount(int segmentCount) {
            if (Integer.bitCount(segmentCount) != 1 || segmentCount < 0 || segmentCount > 65536) {
                LOG.warn("Illegal segment count: " + segmentCount + ", using 16");
                segmentCount = 16;
            }
            this.segmentCount = segmentCount;
            return this;
        }

        public Builder<K, V> stackMoveDistance(int stackMoveDistance) {
            if (stackMoveDistance < 0) {
                LOG.warn("Illegal stack move distance: " + stackMoveDistance + ", using 16");
                stackMoveDistance = 16;
            }
            this.stackMoveDistance = stackMoveDistance;
            return this;
        }

        public Builder<K, V> evictionCallback(EvictionCallback<K, V> evicted) {
            this.evicted = evicted;
            return this;
        }

        public CacheLIRS<K, V> build() {
            return this.build(null);
        }

        public CacheLIRS<K, V> build(CacheLoader<K, V> cacheLoader) {
            return new CacheLIRS<K, V>(this.weigher, this.maxWeight, this.averageWeight, this.segmentCount, this.stackMoveDistance, cacheLoader, this.evicted, this.module);
        }
    }

    @Deprecated(since="2022-12-01")
    static class Entry<K, V> {
        final K key;
        V value;
        int memory;
        int topMove;
        Entry<K, V> stackNext;
        Entry<K, V> stackPrev;
        Entry<K, V> queueNext;
        Entry<K, V> queuePrev;
        Entry<K, V> mapNext;

        Entry(K key, V value, int memory) {
            this.key = key;
            this.value = value;
            this.memory = memory;
        }

        Entry() {
            this(null, null, 0);
        }

        boolean isHot() {
            return this.queueNext == null;
        }
    }

    @Deprecated(since="2022-12-01")
    static class Segment<K, V> {
        int mapSize;
        int queueSize;
        int queue2Size;
        Entry<K, V>[] entries;
        long usedMemory;
        LongAdder hitCount = new LongAdder();
        LongAdder missCount = new LongAdder();
        LongAdder loadSuccessCount = new LongAdder();
        LongAdder loadExceptionCount = new LongAdder();
        LongAdder totalLoadTime = new LongAdder();
        LongAdder evictionCount = new LongAdder();
        private final CacheLIRS<K, V> cache;
        private final int stackMoveDistance;
        private long maxMemory;
        private int averageMemory;
        private int stackSize;
        private Entry<K, V> stack;
        private Entry<K, V> queue;
        private Entry<K, V> queue2;
        private int stackMoveCounter;

        Segment(CacheLIRS<K, V> cache, long maxMemory, int averageMemory, int stackMoveDistance) {
            this.cache = cache;
            this.setMaxMemory(maxMemory);
            this.setAverageMemory(averageMemory);
            this.stackMoveDistance = stackMoveDistance;
            this.clear();
        }

        public void evictedAll(RemovalCause cause) {
            Entry e = this.stack.stackNext;
            while (e != this.stack) {
                if (e.value != null) {
                    this.cache.evicted(e, cause);
                }
                e = e.stackNext;
            }
            e = this.queue.queueNext;
            while (e != this.queue) {
                if (e.stackNext == null) {
                    this.cache.evicted(e, cause);
                }
                e = e.queueNext;
            }
            e = this.queue2.queueNext;
            while (e != this.queue2) {
                this.cache.evicted(e, cause);
                e = e.queueNext;
            }
        }

        synchronized void clear() {
            long l;
            long maxLen = (long)((double)(this.maxMemory / (long)this.averageMemory) / 0.75);
            for (l = 8L; l < maxLen; l += l) {
            }
            int len = (int)Math.min(0x80000000L, l);
            this.stack = new Entry();
            this.stack.stackNext = this.stack;
            this.stack.stackPrev = this.stack.stackNext;
            this.queue = new Entry();
            this.queue.queueNext = this.queue;
            this.queue.queuePrev = this.queue.queueNext;
            this.queue2 = new Entry();
            this.queue2.queueNext = this.queue2;
            this.queue2.queuePrev = this.queue2.queueNext;
            Entry[] small = new Entry[1];
            this.entries = small;
            Entry[] e = new Entry[len];
            this.entries = e;
            this.mapSize = 0;
            this.usedMemory = 0L;
            this.queue2Size = 0;
            this.queueSize = 0;
            this.stackSize = 0;
        }

        int getMemory(K key, int hash) {
            Entry<K, V> e = this.find(key, hash);
            return e == null ? 0 : e.memory;
        }

        V get(Object key, int hash) {
            Entry<K, V> e;
            if (LOG.isTraceEnabled()) {
                LOG.trace("#{} get hash {} key {}", this.cache.cacheId, hash, key);
            }
            if ((e = this.find(key, hash)) == null) {
                this.missCount.increment();
                return null;
            }
            Object value = e.value;
            if (value == null) {
                this.missCount.increment();
                return null;
            }
            if (e.isHot()) {
                if (e != this.stack.stackNext && (this.stackMoveDistance == 0 || this.stackMoveCounter - e.topMove > this.stackMoveDistance)) {
                    this.access(key, hash);
                }
            } else {
                this.access(key, hash);
            }
            this.hitCount.increment();
            return value;
        }

        private synchronized void access(Object key, int hash) {
            Entry<K, V> e = this.find(key, hash);
            if (e == null || e.value == null) {
                return;
            }
            if (e.isHot()) {
                if (e != this.stack.stackNext && (this.stackMoveDistance == 0 || this.stackMoveCounter - e.topMove > this.stackMoveDistance)) {
                    boolean wasEnd = e == this.stack.stackPrev;
                    this.removeFromStack(e);
                    if (wasEnd) {
                        this.pruneStack();
                    }
                    this.addToStack(e);
                }
            } else {
                this.removeFromQueue(e);
                if (e.stackNext != null) {
                    this.removeFromStack(e);
                    this.convertOldestHotToCold();
                } else {
                    this.addToQueue(this.queue, e);
                }
                this.addToStack(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        V get(K key, int hash, Callable<? extends V> valueLoader) throws ExecutionException {
            V value;
            while ((value = this.get(key, hash)) == null) {
                AtomicBoolean alreadyLoading;
                AtomicBoolean loadNow;
                Integer outer = CURRENTLY_LOADING.get();
                if (outer != null && hash <= outer) {
                    return this.load(key, hash, valueLoader);
                }
                ConcurrentHashMap<K, AtomicBoolean> loading = this.cache.loadingInProgress;
                AtomicBoolean atomicBoolean = loadNow = new AtomicBoolean();
                synchronized (atomicBoolean) {
                    alreadyLoading = loading.putIfAbsent(key, loadNow);
                    if (alreadyLoading == null) {
                        CURRENTLY_LOADING.set(hash);
                        V v = this.load(key, hash, valueLoader);
                        return v;
                        finally {
                            loading.remove(key);
                            if (loadNow.get()) {
                                loadNow.notifyAll();
                            }
                            CURRENTLY_LOADING.remove();
                        }
                    }
                }
                atomicBoolean = alreadyLoading;
                synchronized (atomicBoolean) {
                    alreadyLoading.set(true);
                    AtomicBoolean alreadyLoading2 = loading.get(key);
                    if (alreadyLoading2 != alreadyLoading) {
                        continue;
                    }
                    try {
                        alreadyLoading.wait(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return value;
        }

        V load(K key, int hash, Callable<? extends V> valueLoader) throws ExecutionException {
            V value;
            long start = System.nanoTime();
            try {
                value = valueLoader.call();
                this.loadSuccessCount.increment();
            }
            catch (Exception e) {
                this.loadExceptionCount.increment();
                throw new ExecutionException(e);
            }
            finally {
                long time = System.nanoTime() - start;
                this.totalLoadTime.add(time);
            }
            this.put(key, hash, value, this.cache.sizeOf(key, value));
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V get(K key, int hash, CacheLoader<K, V> loader) throws ExecutionException {
            V value = this.get(key, hash);
            if (value != null) {
                return value;
            }
            if (loader == null) {
                return null;
            }
            Segment segment = this;
            synchronized (segment) {
                value = this.get(key, hash);
                if (value != null) {
                    return value;
                }
                long start = System.nanoTime();
                try {
                    value = loader.load(key);
                    this.loadSuccessCount.increment();
                }
                catch (Exception e) {
                    this.loadExceptionCount.increment();
                    throw new ExecutionException(e);
                }
                finally {
                    long time = System.nanoTime() - start;
                    this.totalLoadTime.add(time);
                }
                this.put(key, hash, value, this.cache.sizeOf(key, value));
                return value;
            }
        }

        synchronized V replace(K key, int hash, V value, int memory) {
            if (this.containsKey(key, hash)) {
                return this.put(key, hash, value, memory);
            }
            return null;
        }

        synchronized boolean replace(K key, int hash, V oldValue, V newValue, int memory) {
            V old = this.get(key, hash);
            if (old != null && old.equals(oldValue)) {
                this.put(key, hash, newValue, memory);
                return true;
            }
            return false;
        }

        synchronized boolean remove(Object key, int hash, Object value) {
            V old = this.get(key, hash);
            if (old != null && old.equals(value)) {
                this.invalidate(key, hash, RemovalCause.EXPLICIT);
                return true;
            }
            return false;
        }

        synchronized V remove(Object key, int hash) {
            V old = this.get(key, hash);
            this.invalidate(key, hash, RemovalCause.EXPLICIT);
            return old;
        }

        synchronized V putIfAbsent(K key, int hash, V value, int memory) {
            V old = this.get(key, hash);
            if (old == null) {
                this.put(key, hash, value, memory);
                return null;
            }
            return old;
        }

        synchronized void refresh(K key, int hash, CacheLoader<K, V> loader) throws ExecutionException {
            V value;
            if (loader == null) {
                return;
            }
            V old = this.get(key, hash);
            long start = System.nanoTime();
            try {
                if (old == null) {
                    value = loader.load(key);
                } else {
                    ListenableFuture<V> future = loader.reload(key, old);
                    value = future.get();
                }
                this.loadSuccessCount.increment();
            }
            catch (Exception e) {
                this.loadExceptionCount.increment();
                throw new ExecutionException(e);
            }
            finally {
                long time = System.nanoTime() - start;
                this.totalLoadTime.add(time);
            }
            this.put(key, hash, value, this.cache.sizeOf(key, value));
        }

        synchronized V put(K key, int hash, V value, int memory) {
            V old;
            boolean existed;
            if (value == null) {
                throw new NullPointerException("The value may not be null");
            }
            Entry<K, V> e = this.find(key, hash);
            if (e == null) {
                existed = false;
                old = null;
            } else {
                existed = true;
                old = e.value;
                this.invalidate(key, hash, RemovalCause.REPLACED);
            }
            e = new Entry<K, V>(key, value, memory);
            Entry<K, V>[] array = this.entries;
            int mask = array.length - 1;
            int index = hash & mask;
            e.mapNext = array[index];
            array[index] = e;
            this.usedMemory += (long)memory;
            if (this.usedMemory > this.maxMemory && this.mapSize > 0) {
                this.evict(e);
            }
            ++this.mapSize;
            this.addToStack(e);
            if (existed && PUT_HOT) {
                this.access(key, hash);
            }
            return old;
        }

        synchronized void invalidate(Object key, int hash, RemovalCause cause) {
            Entry<K, V>[] array = this.entries;
            int mask = array.length - 1;
            int index = hash & mask;
            Entry<K, V> e = array[index];
            if (e == null) {
                return;
            }
            if (e.key.equals(key)) {
                array[index] = e.mapNext;
            } else {
                do {
                    Entry<K, V> last = e;
                    e = e.mapNext;
                    if (e != null) continue;
                    return;
                } while (!e.key.equals(key));
                last.mapNext = e.mapNext;
            }
            --this.mapSize;
            this.usedMemory -= (long)e.memory;
            if (e.stackNext != null) {
                this.removeFromStack(e);
            }
            if (e.isHot()) {
                Entry nc = this.queue.queueNext;
                if (nc != this.queue) {
                    this.removeFromQueue(nc);
                    if (nc.stackNext == null) {
                        this.addToStackBottom(nc);
                    }
                }
            } else {
                this.removeFromQueue(e);
            }
            this.pruneStack();
            this.cache.evicted(e, cause);
        }

        private void evict(Entry<K, V> newCold) {
            while (this.queueSize <= this.mapSize >>> 5 && this.stackSize > 0) {
                this.convertOldestHotToCold();
            }
            if (this.stackSize > 0) {
                this.addToQueue(this.queue, newCold);
            }
            while (this.usedMemory > this.maxMemory && this.queueSize > 1) {
                Entry e = this.queue.queuePrev;
                this.usedMemory -= (long)e.memory;
                this.evictionCount.increment();
                this.removeFromQueue(e);
                this.cache.evicted(e, RemovalCause.SIZE);
                e.value = null;
                e.memory = 0;
                this.addToQueue(this.queue2, e);
                while (this.queue2Size + this.queue2Size > this.stackSize) {
                    e = this.queue2.queuePrev;
                    int hash = CacheLIRS.getHash(e.key);
                    this.invalidate(e.key, hash, RemovalCause.SIZE);
                }
            }
        }

        private void convertOldestHotToCold() {
            Entry last = this.stack.stackPrev;
            if (last == this.stack) {
                throw new IllegalStateException();
            }
            this.removeFromStack(last);
            this.addToQueue(this.queue, last);
            this.pruneStack();
        }

        private void pruneStack() {
            Entry last;
            while (!(last = this.stack.stackPrev).isHot()) {
                this.removeFromStack(last);
            }
        }

        Entry<K, V> find(Object key, int hash) {
            Entry<K, V>[] array = this.entries;
            int mask = array.length - 1;
            int index = hash & mask;
            Entry<K, V> e = array[index];
            while (e != null && !e.key.equals(key)) {
                e = e.mapNext;
            }
            return e;
        }

        private void addToStack(Entry<K, V> e) {
            e.stackPrev = this.stack;
            e.stackNext = this.stack.stackNext;
            e.stackNext.stackPrev = e;
            this.stack.stackNext = e;
            ++this.stackSize;
            e.topMove = this.stackMoveCounter++;
        }

        private void addToStackBottom(Entry<K, V> e) {
            e.stackNext = this.stack;
            e.stackPrev = this.stack.stackPrev;
            e.stackPrev.stackNext = e;
            this.stack.stackPrev = e;
            ++this.stackSize;
        }

        private void removeFromStack(Entry<K, V> e) {
            e.stackPrev.stackNext = e.stackNext;
            e.stackNext.stackPrev = e.stackPrev;
            e.stackNext = null;
            e.stackPrev = null;
            --this.stackSize;
        }

        private void addToQueue(Entry<K, V> q, Entry<K, V> e) {
            e.queuePrev = q;
            e.queueNext = q.queueNext;
            e.queueNext.queuePrev = e;
            q.queueNext = e;
            if (e.value != null) {
                ++this.queueSize;
            } else {
                ++this.queue2Size;
            }
        }

        private void removeFromQueue(Entry<K, V> e) {
            e.queuePrev.queueNext = e.queueNext;
            e.queueNext.queuePrev = e.queuePrev;
            e.queueNext = null;
            e.queuePrev = null;
            if (e.value != null) {
                --this.queueSize;
            } else {
                --this.queue2Size;
            }
        }

        synchronized List<K> keys(boolean cold, boolean nonResident) {
            ArrayList keys = new ArrayList();
            if (cold) {
                Entry<K, V> start = nonResident ? this.queue2 : this.queue;
                Entry e = start.queueNext;
                while (e != start) {
                    keys.add(e.key);
                    e = e.queueNext;
                }
            } else {
                Entry e = this.stack.stackNext;
                while (e != this.stack) {
                    keys.add(e.key);
                    e = e.stackNext;
                }
            }
            return keys;
        }

        boolean containsKey(Object key, int hash) {
            Entry<K, V> e = this.find(key, hash);
            return e != null && e.value != null;
        }

        synchronized Set<K> keySet() {
            HashSet set = new HashSet();
            Entry e = this.stack.stackNext;
            while (e != this.stack) {
                set.add(e.key);
                e = e.stackNext;
            }
            e = this.queue.queueNext;
            while (e != this.queue) {
                set.add(e.key);
                e = e.queueNext;
            }
            return set;
        }

        void setMaxMemory(long maxMemory) {
            if (maxMemory <= 0L) {
                throw new IllegalArgumentException("Max memory must be larger than 0");
            }
            this.maxMemory = maxMemory;
        }

        void setAverageMemory(int averageMemory) {
            if (averageMemory <= 0) {
                throw new IllegalArgumentException("Average memory must be larger than 0");
            }
            this.averageMemory = averageMemory;
        }
    }

    @Deprecated(since="2022-12-01")
    public static interface EvictionCallback<K, V> {
        public void evicted(@NotNull K var1, @Nullable V var2, @NotNull RemovalCause var3);
    }
}

