/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.observation;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopReader;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.jetbrains.annotations.Nullable;

public final class ChangeSet {
    public static final String COMMIT_CONTEXT_OBSERVATION_CHANGESET = "oak.observation.changeSet";
    private final int maxPathDepth;
    private final Set<String> parentPaths;
    private final Set<String> parentNodeNames;
    private final Set<String> parentNodeTypes;
    private final Set<String> propertyNames;
    private final Set<String> allNodeTypes;
    private final boolean hitsMaxPathDepth;

    ChangeSet(int maxPathDepth, Set<String> parentPaths, Set<String> parentNodeNames, Set<String> parentNodeTypes, Set<String> propertyNames, Set<String> allNodeTypes) {
        this.maxPathDepth = maxPathDepth;
        this.parentPaths = parentPaths == null ? null : ImmutableSet.copyOf(parentPaths);
        this.parentNodeNames = parentNodeNames == null ? null : ImmutableSet.copyOf(parentNodeNames);
        this.parentNodeTypes = parentNodeTypes == null ? null : ImmutableSet.copyOf(parentNodeTypes);
        this.propertyNames = propertyNames == null ? null : ImmutableSet.copyOf(propertyNames);
        this.allNodeTypes = allNodeTypes == null ? null : ImmutableSet.copyOf(allNodeTypes);
        boolean hitsMaxPathDepth = false;
        if (parentPaths != null) {
            for (String aPath : parentPaths) {
                if (PathUtils.getDepth(aPath) < maxPathDepth) continue;
                hitsMaxPathDepth = true;
                break;
            }
        }
        this.hitsMaxPathDepth = hitsMaxPathDepth;
    }

    public String toString() {
        return "ChangeSet{paths[maxDepth:" + this.maxPathDepth + "]=" + this.parentPaths + ", propertyNames=" + this.propertyNames + ", parentNodeNames=" + this.parentNodeNames + ", parentNodeTypes=" + this.parentNodeTypes + ", allNodeTypes=" + this.allNodeTypes + ", any overflow: " + this.anyOverflow() + ", hits max path depth: " + this.hitsMaxPathDepth + "}";
    }

    public boolean doesHitMaxPathDepth() {
        return this.hitsMaxPathDepth;
    }

    @Nullable
    public Set<String> getParentPaths() {
        return this.parentPaths;
    }

    @Nullable
    public Set<String> getParentNodeNames() {
        return this.parentNodeNames;
    }

    @Nullable
    public Set<String> getParentNodeTypes() {
        return this.parentNodeTypes;
    }

    @Nullable
    public Set<String> getPropertyNames() {
        return this.propertyNames;
    }

    public int getMaxPrefilterPathDepth() {
        return this.maxPathDepth;
    }

    @Nullable
    public Set<String> getAllNodeTypes() {
        return this.allNodeTypes;
    }

    public boolean anyOverflow() {
        return this.getAllNodeTypes() == null || this.getParentNodeNames() == null || this.getParentNodeTypes() == null || this.getParentPaths() == null || this.getPropertyNames() == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeSet changeSet = (ChangeSet)o;
        if (this.maxPathDepth != changeSet.maxPathDepth) {
            return false;
        }
        if (this.parentPaths != null ? !this.parentPaths.equals(changeSet.parentPaths) : changeSet.parentPaths != null) {
            return false;
        }
        if (this.parentNodeNames != null ? !this.parentNodeNames.equals(changeSet.parentNodeNames) : changeSet.parentNodeNames != null) {
            return false;
        }
        if (this.parentNodeTypes != null ? !this.parentNodeTypes.equals(changeSet.parentNodeTypes) : changeSet.parentNodeTypes != null) {
            return false;
        }
        if (this.propertyNames != null ? !this.propertyNames.equals(changeSet.propertyNames) : changeSet.propertyNames != null) {
            return false;
        }
        return this.allNodeTypes != null ? this.allNodeTypes.equals(changeSet.allNodeTypes) : changeSet.allNodeTypes == null;
    }

    public int hashCode() {
        return 0;
    }

    public String asString() {
        JsopBuilder json = new JsopBuilder();
        json.object();
        json.key("maxPathDepth").value(this.maxPathDepth);
        ChangeSet.addToJson(json, "parentPaths", this.parentPaths);
        ChangeSet.addToJson(json, "parentNodeNames", this.parentNodeNames);
        ChangeSet.addToJson(json, "parentNodeTypes", this.parentNodeTypes);
        ChangeSet.addToJson(json, "propertyNames", this.propertyNames);
        ChangeSet.addToJson(json, "allNodeTypes", this.allNodeTypes);
        json.endObject();
        return ((Object)json).toString();
    }

    public static ChangeSet fromString(String json) {
        JsopTokenizer reader = new JsopTokenizer(json);
        int maxPathDepth = 0;
        Set<String> parentPaths = null;
        Set<String> parentNodeNames = null;
        Set<String> parentNodeTypes = null;
        Set<String> propertyNames = null;
        Set<String> allNodeTypes = null;
        reader.read(123);
        if (!reader.matches(125)) {
            do {
                String name = reader.readString();
                reader.read(58);
                if ("maxPathDepth".equals(name)) {
                    maxPathDepth = Integer.parseInt(reader.read(2));
                    continue;
                }
                Set<String> data = ChangeSet.readArrayAsSet(reader);
                if ("parentPaths".equals(name)) {
                    parentPaths = data;
                    continue;
                }
                if ("parentNodeNames".equals(name)) {
                    parentNodeNames = data;
                    continue;
                }
                if ("parentNodeTypes".equals(name)) {
                    parentNodeTypes = data;
                    continue;
                }
                if ("propertyNames".equals(name)) {
                    propertyNames = data;
                    continue;
                }
                if (!"allNodeTypes".equals(name)) continue;
                allNodeTypes = data;
            } while (reader.matches(44));
            reader.read(125);
        }
        reader.read(0);
        return new ChangeSet(maxPathDepth, parentPaths, parentNodeNames, parentNodeTypes, propertyNames, allNodeTypes);
    }

    private static Set<String> readArrayAsSet(JsopReader reader) {
        HashSet<String> values = Sets.newHashSet();
        reader.read(91);
        boolean first = true;
        while (!reader.matches(93)) {
            if (!first) {
                reader.read(44);
            }
            values.add(reader.readString());
            first = false;
        }
        return values;
    }

    private static void addToJson(JsopWriter json, String name, Set<String> values) {
        if (values == null) {
            return;
        }
        json.key(name).array();
        for (String v : values) {
            json.value(v);
        }
        json.endArray();
    }
}

