/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol;

import java.util.Collection;
import javax.jcr.security.NamedAccessControlPolicy;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReadPolicy
implements NamedAccessControlPolicy {
    public static final NamedAccessControlPolicy INSTANCE = new ReadPolicy();

    private ReadPolicy() {
    }

    @Override
    public String getName() {
        return "Grants read access on configured trees.";
    }

    public static boolean hasEffectiveReadPolicy(@NotNull Collection<String> readPaths, @Nullable String oakPath) {
        if (oakPath == null) {
            return false;
        }
        if (readPaths.contains(oakPath)) {
            return true;
        }
        for (String rp : readPaths) {
            if (!Text.isDescendant(rp, oakPath)) continue;
            return true;
        }
        return false;
    }
}

