/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.as.response;

import javax.servlet.http.HttpServletRequest;
import org.apache.oltu.oauth2.common.message.OAuthResponse;

public class OAuthASResponse
extends OAuthResponse {
    protected OAuthASResponse(String uri, int responseStatus) {
        super(uri, responseStatus);
    }

    public static OAuthAuthorizationResponseBuilder authorizationResponse(HttpServletRequest request, int code) {
        return new OAuthAuthorizationResponseBuilder(request, code);
    }

    public static OAuthTokenResponseBuilder tokenResponse(int code) {
        return new OAuthTokenResponseBuilder(code);
    }

    public static class OAuthTokenResponseBuilder
    extends OAuthResponse.OAuthResponseBuilder {
        public OAuthTokenResponseBuilder(int responseCode) {
            super(responseCode);
        }

        public OAuthTokenResponseBuilder setAccessToken(String token) {
            this.parameters.put("access_token", token);
            return this;
        }

        public OAuthTokenResponseBuilder setExpiresIn(String expiresIn) {
            this.parameters.put("expires_in", expiresIn == null ? null : Long.valueOf(expiresIn));
            return this;
        }

        public OAuthTokenResponseBuilder setRefreshToken(String refreshToken) {
            this.parameters.put("refresh_token", refreshToken);
            return this;
        }

        public OAuthTokenResponseBuilder setTokenType(String tokenType) {
            this.parameters.put("token_type", tokenType);
            return this;
        }

        @Override
        public OAuthTokenResponseBuilder setParam(String key, String value) {
            this.parameters.put(key, value);
            return this;
        }

        @Override
        public OAuthTokenResponseBuilder location(String location) {
            this.location = location;
            return this;
        }
    }

    public static class OAuthAuthorizationResponseBuilder
    extends OAuthResponse.OAuthResponseBuilder {
        public OAuthAuthorizationResponseBuilder(HttpServletRequest request, int responseCode) {
            super(responseCode);
            String state = request.getParameter("state");
            if (state != null) {
                this.setState(state);
            }
        }

        OAuthAuthorizationResponseBuilder setState(String state) {
            this.parameters.put("state", state);
            return this;
        }

        public OAuthAuthorizationResponseBuilder setCode(String code) {
            this.parameters.put("code", code);
            return this;
        }

        public OAuthAuthorizationResponseBuilder setAccessToken(String token) {
            this.parameters.put("access_token", token);
            return this;
        }

        public OAuthAuthorizationResponseBuilder setExpiresIn(String expiresIn) {
            this.parameters.put("expires_in", expiresIn == null ? null : Long.valueOf(expiresIn));
            return this;
        }

        public OAuthAuthorizationResponseBuilder setExpiresIn(Long expiresIn) {
            this.parameters.put("expires_in", expiresIn);
            return this;
        }

        @Override
        public OAuthAuthorizationResponseBuilder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public OAuthAuthorizationResponseBuilder setParam(String key, String value) {
            this.parameters.put(key, value);
            return this;
        }
    }
}

