/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.util.List;
import org.apache.sling.repoinit.parser.impl.QuotableStringUtil;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.apache.sling.repoinit.parser.operations.OperationVisitor;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class RemoveGroupMembers
extends Operation {
    private final String groupname;
    private final List<String> members;

    public RemoveGroupMembers(List<String> members, String groupname) {
        this.groupname = groupname;
        this.members = members;
    }

    @Override
    public void accept(OperationVisitor v) {
        v.visitRemoveGroupMembers(this);
    }

    @Override
    protected String getParametersDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.members);
        sb.append(" in group ").append(this.groupname);
        return sb.toString();
    }

    @Override
    @NotNull
    public String asRepoInitString() {
        return String.format("remove %s from group %s%n", RemoveGroupMembers.listToString(QuotableStringUtil.forRepoInitString(this.members)), QuotableStringUtil.forRepoInitString((String)this.groupname));
    }

    public String getGroupname() {
        return this.groupname;
    }

    public List<String> getMembers() {
        return this.members;
    }
}

