/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.ner.corenlp;

import com.github.openjson.JSONException;
import com.github.openjson.JSONObject;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tika.io.IOUtils;
import org.apache.tika.parser.ner.NERecogniser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreNLPNERecogniser
implements NERecogniser {
    private static final Logger LOG = LoggerFactory.getLogger(CoreNLPNERecogniser.class);
    public static final String NER_3CLASS_MODEL = "edu/stanford/nlp/models/ner/english.all.3class.distsim.crf.ser.gz";
    public static final String NER_4CLASS_MODEL = "edu/stanford/nlp/models/ner/english.conll.4class.distsim.crf.ser.gz";
    public static final String NER_7CLASS_MODEL = "edu/stanford/nlp/models/ner/english.muc.7class.distsim.crf.ser.gz";
    public static final String DEFAULT_MODEL_PATH = "edu/stanford/nlp/models/ner/english.muc.7class.distsim.crf.ser.gz";
    public static final String MODEL_PROP_NAME = "ner.corenlp.model";
    public static final Set<String> ENTITY_TYPES = new HashSet<String>(){
        {
            this.add("PERSON");
            this.add("TIME");
            this.add("LOCATION");
            this.add("ORGANIZATION");
            this.add("MONEY");
            this.add("PERCENT");
            this.add("DATE");
        }
    };
    private static final String CLASSIFIER_CLASS_NAME = "edu.stanford.nlp.ie.crf.CRFClassifier";
    private boolean available = false;
    private Field firstField;
    private Field secondField;
    private Field thirdField;
    private Object classifierInstance;
    private Method classifyMethod;

    public CoreNLPNERecogniser() {
        this(System.getProperty(MODEL_PROP_NAME, "edu/stanford/nlp/models/ner/english.muc.7class.distsim.crf.ser.gz"));
    }

    public CoreNLPNERecogniser(String modelPath) {
        try {
            Properties props = new Properties();
            Class<?> classifierClass = Class.forName(CLASSIFIER_CLASS_NAME);
            Method loadMethod = classifierClass.getMethod("getClassifier", String.class, Properties.class);
            this.classifierInstance = loadMethod.invoke(classifierClass, modelPath, props);
            this.classifyMethod = classifierClass.getMethod("classifyToCharacterOffsets", String.class);
            Class<?> tripleClass = Class.forName("edu.stanford.nlp.util.Triple");
            this.firstField = tripleClass.getField("first");
            this.secondField = tripleClass.getField("second");
            this.thirdField = tripleClass.getField("third");
            this.available = true;
        }
        catch (Exception e) {
            LOG.warn("{} while trying to load the model from {}", (Object)e.getMessage(), (Object)modelPath);
        }
        LOG.info("Available for service ? {}", (Object)this.available);
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public Set<String> getEntityTypes() {
        return ENTITY_TYPES;
    }

    @Override
    public Map<String, Set<String>> recognise(String text) {
        HashMap<String, Set<String>> names = new HashMap<String, Set<String>>();
        try {
            Object result = this.classifyMethod.invoke(this.classifierInstance, text);
            List entries = (List)result;
            for (Object entry : entries) {
                String entityType = (String)this.firstField.get(entry);
                if (!names.containsKey(entityType)) {
                    names.put(entityType, new HashSet());
                }
                Integer start = (Integer)this.secondField.get(entry);
                Integer end = (Integer)this.thirdField.get(entry);
                String name = text.substring(start, end);
                if ((name = name.trim().replaceAll("(\\s\\s+)|\n|\t", " ")).isEmpty()) continue;
                ((Set)names.get(entityType)).add(name);
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
        }
        return names;
    }

    public static void main(String[] args) throws IOException, JSONException {
        if (args.length != 1) {
            System.err.println("Error: Invalid Args");
            System.err.println("This tool finds names inside text");
            System.err.println("Usage: <path/to/text/file>");
            return;
        }
        try (FileInputStream stream = new FileInputStream(args[0]);){
            String text = IOUtils.toString(stream);
            CoreNLPNERecogniser ner = new CoreNLPNERecogniser();
            Map<String, Set<String>> names = ner.recognise(text);
            JSONObject jNames = new JSONObject(names);
            System.out.println(jNames.toString(2));
        }
    }
}

