/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.odf;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class FlatOpenDocumentMacroHandler
extends ContentHandlerDecorator {
    static String MODULE = "module";
    private static String SOURCE_CODE = "source-code";
    static String NAME = "name";
    private final ContentHandler contentHandler;
    private final ParseContext parseContext;
    private EmbeddedDocumentExtractor embeddedDocumentExtractor;
    private final StringBuilder macroBuffer = new StringBuilder();
    String macroName = null;
    boolean inMacro = false;

    FlatOpenDocumentMacroHandler(ContentHandler contentHandler, ParseContext parseContext) {
        super(contentHandler);
        this.contentHandler = contentHandler;
        this.parseContext = parseContext;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        if (MODULE.equals(localName)) {
            this.macroName = XMLReaderUtils.getAttrValue(NAME, attrs);
        } else if (SOURCE_CODE.equals(localName)) {
            this.inMacro = true;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inMacro) {
            this.macroBuffer.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (SOURCE_CODE.equals(localName)) {
            try {
                this.handleMacro();
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
            finally {
                this.resetMacroState();
            }
        }
    }

    protected void resetMacroState() {
        this.macroBuffer.setLength(0);
        this.macroName = null;
        this.inMacro = false;
    }

    protected void handleMacro() throws IOException, SAXException {
        byte[] bytes = this.macroBuffer.toString().getBytes(StandardCharsets.UTF_8);
        if (this.embeddedDocumentExtractor == null) {
            this.embeddedDocumentExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(this.parseContext);
        }
        Metadata embeddedMetadata = new Metadata();
        if (!StringUtils.isBlank(this.macroName)) {
            embeddedMetadata.set("resourceName", this.macroName);
        }
        embeddedMetadata.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.MACRO.toString());
        if (this.embeddedDocumentExtractor.shouldParseEmbedded(embeddedMetadata)) {
            try (TikaInputStream is = TikaInputStream.get(bytes);){
                this.embeddedDocumentExtractor.parseEmbedded(is, this.contentHandler, embeddedMetadata, false);
            }
        }
    }
}

