/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.converter;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

class DTOUtil {
    private static final Method[] OBJECT_CLASS_METHODS = Object.class.getMethods();

    private DTOUtil() {
    }

    static boolean isDTOType(Class<?> cls, boolean ignorePublicNoArgsCtor) {
        if (!ignorePublicNoArgsCtor && Arrays.stream(cls.getConstructors()).noneMatch(ctor -> ctor.getParameterCount() == 0)) {
            return false;
        }
        for (Method m : cls.getMethods()) {
            if (!Arrays.stream(OBJECT_CLASS_METHODS).noneMatch(om -> om.getName().equals(m.getName()) && Arrays.equals(om.getParameterTypes(), m.getParameterTypes()))) continue;
            return false;
        }
        boolean foundField = false;
        for (Field f : cls.getFields()) {
            int modifiers = f.getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            if (!Modifier.isPublic(modifiers)) {
                return false;
            }
            foundField = true;
        }
        return foundField;
    }
}

