/*
 * Type1WidthFetcher
 *
  * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 * 
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.font.type1;

/**
 * A charstring consumer used to fetch the widths from a type1 charstring.
 * 
 * <h4>Synchronization</h4>
 * 
 * This class is not synchronized. Multiple instances can safely
 * coexist without threadsafety issues, but each must only be accessed 
 * from one thread (or must be guarded by the client).
 */
final class Type1WidthFetcher extends Type1CStringConsumerDefault {
	private double w;
	
	public boolean width(double wx) {
		w = wx;
		
		// don't continue upon return...
		return false;
	}
	
	double getWidth()
	{
		return w;
	}
}
