/*
 * File: Base14CacheResourceBuilder.java
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2009 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.fontmanagement;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

import com.adobe.fontengine.font.Base14;
import com.adobe.fontengine.fontmanagement.CacheSupportInfo;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontDescription;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontDescription;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontDescription;

public final class Base14CacheResourceBuilder
{
	private static String[] base14Fonts = {
		"Times-Roman",
		"Times-Bold",
		"Times-BoldItalic",
		"Times-Italic",
		"Helvetica",
		"Helvetica-Bold",
		"Helvetica-BoldOblique",
		"Helvetica-Oblique",
		"Courier",
		"Courier-Bold",
		"Courier-BoldOblique",
		"Courier-Oblique",
		"Symbol",
		"ZapfDingbats"
	};

	/**
	 * Here we simply go over each currently defined FontDescription type and put
	 * an instance of it in the cache for each base14 font. Nothing guarantees the
	 * completeness of these references. If a new FontDescription type is added
	 * you MUST add a reference to it here or it will NOT appear in the pre-built
	 * base14 cache.
	 */
	public static void main (String[] args)
		throws Exception
	{
		HashMap<String, HashMap<String, Object>>fontCache = new HashMap<String, HashMap<String, Object>>();
		for (String base14FontName : base14Fonts) {
			Base14Font b14Font = (Base14Font)Base14.fromPSName(base14FontName);
			HashMap<String, Object> fontNode = new HashMap<String, Object>();
			CacheSupportInfo info = b14Font.getCacheSupportInfo();
			fontNode.put(CacheSupportInfo.class.getSimpleName(), info);
			CSS20FontDescription[] css20 = b14Font.getCSS20FontDescription();
			fontNode.put(CSS20FontDescription[].class.getSimpleName(), css20);
			FXGFontDescription[] fxg = b14Font.getFXGFontDescription();
			fontNode.put(FXGFontDescription[].class.getSimpleName(), fxg);
			PlatformFontDescription[] plat = b14Font.getPlatformFontDescription();
			fontNode.put(PlatformFontDescription[].class.getSimpleName(), plat);
			PostscriptFontDescription[] post = b14Font.getPostscriptFontDescription();
			fontNode.put(PostscriptFontDescription[].class.getSimpleName(), post);
			fontCache.put(base14FontName, fontNode);
		}
		File cacheFile = new File(args[1] + File.separator + "com/adobe/fontengine/font/Base14Cache");
		cacheFile.delete();
		cacheFile.createNewFile();
		FileOutputStream fileOutStm = new FileOutputStream(cacheFile);
		ObjectOutputStream objOutStm = new ObjectOutputStream(fileOutStm);
		objOutStm.writeObject(fontCache);
		objOutStm.close();
	}
}
