/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.socialgraph;

/**
 * Defines relationship directions used when getting relationships from a node.
 * A relationship has a direction from a node's point of view. If a node is the start node of a relationship it will be
 * an {@link #OUTGOING} relationship from that node's point of view. If a node is the end node of a relationship it will
 * be an {@link #INCOMING} relationship from that node's point of view. The {@link #BOTH} direction is used when
 * direction is of no importance, such as "give me all" relationships that are either OUTGOING or INCOMING.
 */
public enum Direction  {

    /**
     * Defines both incoming and outgoing relationships.
     */
    BOTH,

    /**
     * Defines incoming relationships.
     */
    INCOMING,

    /**
     * Defines outgoing relationships.
     */
    OUTGOING
}
