/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa.ut;

import java.util.ArrayList;
import java.util.List;

/**
 * Public header file for class MsgFormat: format strings -- usually messages,
 * often used with jfExFull. MsgFormat will perform place-holder substitution
 * (%s).
 * 
 * Note: Where place-holder substitution must be position-dependent, use
 * MsgFormatPos.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public class MsgFormat {

	private int mnResId;

	private int mnSourceIndex;

	private final List<String> moParms = new ArrayList<String>(); // pushed parameters

	private StringBuilder msResult = new StringBuilder();

	private String msSource;

	protected MsgFormat() {
	}

	/**
	 * Copy Constructor
	 * 
	 * @param oSource
	 *            MsgFormat to be copied
	 */
	public MsgFormat(MsgFormat oSource) {
		assign(oSource);
	}

	/**
	 * Resource Id Constructor
	 * 
	 * @param nResId
	 *            Resource Id representing a string to be formatted
	 */
	public MsgFormat(int nResId) {
		initialize(nResId);
	}

	// TODO not sure what to do with jfAtom
//	/**
//	 * Resource Id Constructor
//	 * 
//	 * @param nResId
//	 *            Resource Id representing a string to be formatted
//	 * @param aOut
//	 *            input value to be applied to the format
//	 */
//	public MsgFormat(ResId nResId, jfAtom aOut) {
//		initialize(nResId);
//		format(aOut);
//	}

	/**
	 * Resource Id Constructor
	 * 
	 * @param nResId
	 *            Resource Id representing a string to be formatted
	 * @param sOut
	 *            input value to be applied to the format
	 */
	public MsgFormat(int nResId, String sOut) {
		initialize(nResId);
		format(sOut);
	}

	/**
	 * String Constructor
	 * 
	 * @param sSource
	 *            string to be formatted
	 */
	public MsgFormat(String sSource) {
		initialize(sSource);
	}

	/**
	 * String Constructor
	 * 
	 * @param sSource
	 *            string to be formatted
	 * @param sOut
	 *            input value to be applied to the format
	 */
	public MsgFormat(String sSource, String sOut) {
		initialize(sSource);
		format(sOut);
	}

	private void append(char cappend) {
		msResult.append(cappend);
	}

	private void append(String sAppend) {
		msResult.append(sAppend);
		moParms.add(sAppend);
	}

	/**
	 * Assignment operator.
	 * 
	 * @param oSource
	 *            MsgFormat to be copied
	 */
	public MsgFormat assign(MsgFormat oSource) {
		if (this == oSource)
			return this;

		mnResId = oSource.mnResId;
		msSource = oSource.msSource;
		msResult = oSource.msResult;
		moParms.addAll(oSource.moParms);
		mnSourceIndex = oSource.mnSourceIndex;

		return this;
	}

	private void findNextformat() {
		// We are about to append a whole bunch of characters onto msResult.
		// Do one allocation to hold the max. number of characters.
		if (StringUtils.isEmpty(msResult))
			msResult.ensureCapacity(msSource.length());

		for (; mnSourceIndex < msSource.length(); mnSourceIndex++) {
			if (msSource.charAt(mnSourceIndex) == '%') {
				mnSourceIndex++;
				if (mnSourceIndex < msSource.length()) {
					if (msSource.charAt(mnSourceIndex) != '%')
						break;
				}
			}
			append(msSource.charAt(mnSourceIndex));
		}
	}

	// TODO not sure what to do with jfAtom
//	/**
//	 * formatting operator.
//	 * 
//	 * @param aOut
//	 *            input value to be applied to the format
//	 */
//	public MsgFormat format(jfAtom aOut) {
//		String sformat = loadformat();
//		formatString(sformat, String(aOut));
//		findNextformat();
//
//		return this;
//	}

	/**
	 * formatting operator.
	 * 
	 * @param sOut
	 *            input value to be applied to the format
	 */
	public MsgFormat format(String sOut) {
		//int cConversion;

		String sformat = loadformat();
		formatString(sformat, sOut);
		findNextformat();

		return this;
	}

	private void formatString(String sformat, String sOut) {
		append(sOut);
	}

	/**
	 * Retrieve the nth parameter as a string
	 * 
	 * @return the nth parameter as a string
	 */
	public String getParm(int nIndex) {
		return (nIndex > moParms.size()) ? "" : moParms.get(nIndex);
	}

	/**
	 * Retrieve the size of the parameter list
	 * 
	 * @return the size of the parameter list
	 */
	public int getParmCount() {
		return moParms.size();
	}

	private void initialize(int nResId) {
		mnResId = nResId;
		msSource = ResourceLoader.loadResource(nResId);
		mnSourceIndex = 0;
		findNextformat();
	}

	private void initialize(String sSource) {
		mnResId = 0;
		msSource = sSource;
		mnSourceIndex = 0;
		findNextformat();
	}

	private String loadformat() {

		int nStart = mnSourceIndex;
		boolean bDotFound = false;
		boolean bSkipL = false;
		//int cConversion;

		String sformat = "%";
		for (; mnSourceIndex < msSource.length(); mnSourceIndex++) {
			char cNext = msSource.charAt(mnSourceIndex);
			if (cNext == '.') {
				if (bDotFound)
					break;
			} else if (cNext == 'l') {
				bSkipL = true;
				break;
			} else if ((cNext < '0') || (cNext > '9')) {
				break;
			}
		}

		sformat = sformat + msSource.substring(nStart, mnSourceIndex);
		if (bSkipL)
			mnSourceIndex++;

		if (mnSourceIndex >= msSource.length()) {
			//cConversion = '\0';
		}
		else {
			//cConversion = msSource.charAt(mnSourceIndex);
			mnSourceIndex++;
		}

		return sformat;
	}

//	private String makeformatString(String sformat, String pcConversion) {
//		sformat += pcConversion;
//		return sformat;
//	}

	/**
	 * Retrieve the resource id
	 * 
	 * @return the resource id for this
	 */
	public int resId() {
		return mnResId;
	}

	/**
	 * Retrieve the source string
	 * 
	 * @return the source string for this
	 */
	public String sourceString() {
		return msSource;
	}

	/**
	 * Conversion operator.
	 * 
	 * @return *this as a jfstring
	 */
	public String toString() {
		return msResult.toString();
	}

}
