/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.replication;

import java.util.List;

/**
 * An aggregation of multiple {@link ReplicationAction}s.
 */
public class CompositeReplicationAction {

    private final List<ReplicationAction> actions;
    private final String[] paths;
    private boolean hasTestAction = false;

    public CompositeReplicationAction(List<ReplicationAction> actions) {
        this.actions = actions;

        if (actions.size() == 0) {
            throw new RuntimeException("cannot build an empty multiple action");
        }

        paths = new String[actions.size()];
        int i = 0;
        ReplicationAction sample = actions.get(0);
        for (ReplicationAction action : actions) {
            paths[i] = action.getPath();
            if (!sample.getType().equals(action.getType())) {
                throw new RuntimeException("all composing actions of a multiple action must have same type");
            }
            if (ReplicationActionType.TEST.equals(action.getType())) {
                hasTestAction = true;
            }
            i++;
        }
    }

    public List<ReplicationAction> getActions() {
        return actions;
    }

    public String[] getPaths() {
        return paths;
    }

    public boolean hasTestAction() {
        return hasTestAction;
    }

    public ReplicationAction asAction() {
        ReplicationAction delegate = actions.get(0);
        return new ReplicationAction(delegate.getType(), paths, delegate.getTime(), delegate.getUserId(),
                delegate.getRevision());
    }
}
