/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2019 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.adobeims.imsprofile;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * Object deserialized from the json response received - IMS profile json.
 * It contains the needed fields from the 'prodCtx' object.
 */
public class ImsProfileProdCtx {

    private String serviceCode;
    private String statusCode;
    private String userVisibleName;
    private String groupId;
    private String serviceLevel;

    @JsonCreator
    public ImsProfileProdCtx(@JsonProperty("serviceCode") String serviceCode,
            @JsonProperty("statusCode") String statusCode, @JsonProperty("user_visible_name") String userVisibleName,
            @JsonProperty("groupid") String groupId) {
        this.serviceCode = serviceCode;
        this.statusCode = statusCode;
        this.userVisibleName = userVisibleName;
        this.groupId = groupId;
    }

    public String getServiceCode() {
        return serviceCode;
    }

    public String getStatusCode() {
        return statusCode;
    }

    public String getUserVisibleName() {
        return userVisibleName;
    }

    public String getGroupId() {
        return groupId;
    }

    @JsonSetter("serviceLevel")
    public void setServiceLevel(String serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public String getServiceLevel() {
        return serviceLevel;
    }

    @Override
    public String toString() {
        return "ImsProfileProdCtx{" + "serviceCode='" + serviceCode + "'" + ", statusCode='" + statusCode + "'"
                + ", userVisibleName='" + userVisibleName + "'" + ", groupId='" + groupId + ", serviceLevel='" + serviceLevel +'\'' + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ImsProfileProdCtx that = (ImsProfileProdCtx) o;
        return Objects.equals(serviceCode, that.serviceCode) && Objects.equals(statusCode, that.statusCode)
                && Objects.equals(userVisibleName, that.userVisibleName) && Objects.equals(groupId, that.groupId) && Objects.equals(serviceLevel, that.serviceLevel);
    }

    @Override
    public int hashCode() {
        return Objects.hash(serviceCode, statusCode, userVisibleName, groupId, serviceLevel);
    }
}
