/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.cloudservices.provisioning;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

/**
 * The {@link ProvisioningProperties} is an utility class to read a properties file containing data for automatic
 * provisioning.
 */
public final class ProvisioningProperties {

    /**
     * Request parameter name for automatic provisioning.
     */
    public static final String PARAM_AUTOMATIC_PROVISIONING = "automaticProvisioning";

    /**
     * Name of the system property holding the parent directory of the properties file.
     */
    public static final String PROP_PROVISIONING_CONTAINER_FOLDER = "mac.provisioning.file.container";

    /**
     * File name of the properties file holding the provisioning data.
     */
    public static final String PROP_PROVISIONING_FILE_NAME = "marketingcloud.properties";

    private static final Logger logger = LoggerFactory.getLogger(ProvisioningProperties.class);

    private ProvisioningProperties() {

    }

    /**
     * Reads the provisioning properties file with the name {@link #PROP_PROVISIONING_FILE_NAME} from the working
     * directory. If the system property {@link #PROP_PROVISIONING_CONTAINER_FOLDER} is set, the method attempts to read
     * the file from there.
     * <p>
     * <p>The file should contain prefixed properties in the form of {@code <servicename>.<property> (i.e.
     * analytics.company)}</p>
     *
     * @return Properties or {@code null} if the file does not exist or can't be read.
     */
    public static Properties getAutomaticProvisioningData() {
        Properties provisioningProps = null;

        try {
            File provisioningFile = new File(System.getProperty(PROP_PROVISIONING_CONTAINER_FOLDER, "."),
                    PROP_PROVISIONING_FILE_NAME);

            provisioningProps = new Properties();
            provisioningProps.load(new FileInputStream(provisioningFile));
        } catch (Exception e) {
            logger.error(String.format("Unable to read the provisioning file %s.",
                    System.getProperty(PROP_PROVISIONING_CONTAINER_FOLDER, ".") + PROP_PROVISIONING_FILE_NAME), e);
        }

        return provisioningProps;
    }
}
