/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.cq.dam.cfm.content;

import aQute.bnd.annotation.ProviderType;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

/**
 * <p>Provides a service to render a Content Fragment to its final destination,
 * typically a paragraph on a CQ page.</p>
 */
@ProviderType
public interface FragmentRenderService {

    /**
     * <p>Renders the provided resource (which must reference a component that references
     * a Content Fragment).</p>
     *
     * @param paragraph The paragraph
     * @return The rendered HTML
     */
    String render(Resource paragraph);

    /**
     * <p>Renders the provided resource (which must reference a component that references
     * a Content Fragment).</p>
     *
     * <p>This method allow to provide additional, implementation-specific configuration.
     * For a documentation about the supported options, please consult the Adobe AEM
     * documentation on Content Fragments.</p>
     *
     * @param paragraph The paragraph
     * @param config Additional configurationls
     * @return The rendered HTML
     */
    String render(Resource paragraph, ValueMap config);

}
