/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package com.adobe.cq.dam.mac.sync.api;

import aQute.bnd.annotation.ProviderType;

/**
 * Provides the <code>SyncAgent</code> for a given type.
 */
@ProviderType
public interface SyncAgentFactory {
    /**
     * Provides SyncAgent instance for a particular type
     * @param type Type of the sync agent.
     *
     *
     * @return sync agent instance
     *
     * @throws java.lang.IllegalArgumentException if type is <code>null</code> or is not recognized.
     */
    SyncAgent getSyncAgent(String type);

    /**
     * Provides SyncAgent instance for a particular type, the name of the agent is formed using the nameHint
     * @param type Type of the sync agent.
     * @param nameHint hint for agent name
     *
     * @return sync agent instance
     *
     * @throws java.lang.IllegalArgumentException if type is <code>null</code> or is not recognized.
     */
    SyncAgent getSyncAgent(String type, String nameHint);
}
