/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.cq.ui.wcm.commons.config;

/**
 * Provides configuration properties for the Next Generation Dynamic Media integration
 */
public interface NextGenDynamicMediaConfig {

    /**
     * Checks if the configuration/feature is enabled.
     * 
     * @return true if enabled and false otherwise
     */
    boolean enabled();

    /**
     * Gets the Next Generation Dynamic Media tenant (also known technically as the repository Id) This would typically be a host name with
     * the format 'delivery-pXX-eYY.adobeaemcloud.com' for PROD environments and 'delivery-pXX-eYY-smstg.adobeaemcloud.com' for STAGE
     * environments.
     * 
     * @return the repository id
     */
    String getRepositoryId();

    /**
     * Gets the API key for accessing the asset selectors UI
     * 
     * @return the API key for accessing the asset selectors UI
     */
    String getApiKey();

    /**
     * Gets the environment string which should be 'PROD' or 'STAGE'
     * 
     * @return the environment string
     */
    String getEnv();

    /**
     * Gets the Adobe IMS Organization ID the user is a part of
     * 
     * @return the Adobe IMS Organization ID the user is a part of
     * 
     * @deprecated No replacement. IMS Org need not be sent to discovery service.
     * The access is determined based on the repository ID.
     */
    @Deprecated
    String getImsOrg();

    /**
     * Gets the IMS environment string which should be "prd" for IMS PROD environments and "stg1" for IMS STAGE environments
     * 
     * @return the IMS environment string
     * 
     * @deprecated No replacement. IMSenv is an invalid property from asset selector's point of view.
     * The IMS environment is determined solely on the basis of env property which accepts values as STAGE or PROD.
     */
    @Deprecated
    String getImsEnv();

    /**
     * Gets the IMS client identifier
     * 
     * @return the IMS client identifier
     */
    String getImsClient();

    /**
     * Gets the absolute URL for the javascript which contains the microfrontend for the remote asset selector.
     * 
     * @return the absolute URL for the javascript which contains the microfrontend for the remote asset selector
     */
    String getAssetSelectorsJsUrl();

    /**
     * Gets the path expression for the image delivery path. The following placeholders with the below meaning are contained within that
     * path:
     * <ul>
     * <li>{asset-id} - the uuid of the asset in the format 'urn:aaid:aem:UUID', e.g. urn:aaid:aem:1a034bee-ebda-4787-bad3-f924d0772b75</li>
     * <li>{seo-name} - any url-encoded or alphanumeric, non-whitespace set of characters. may contain hyphens and dots</li>
     * <li>{format} - output format</li>
     * </ul>
     * 
     * @return the path expression for the image delivery path
     */
    String getImageDeliveryBasePath();

    /**
     * Gets the path expression for the adaptive video manifest/player path. The following placeholders with the below meaning are contained
     * within that path:
     * <ul>
     * <li>{asset-id} - the uuid of the asset in the format 'urn:aaid:aem:UUID' along with optional format
     * e.g. urn:aaid:aem:1a034bee-ebda-4787-bad3-f924d0772b75 OR urn:aaid:aem:1a034bee-ebda-4787-bad3-f924d0772b75.mp4</li>
     * </ul>
     * 
     * @return the path expression for the video delivery path
     */
    String getVideoDeliveryPath();

    /**
     * Gets the path expression for the the Original Asset Delivery which delivers the bitstream as-is
     * <ul>
     * <li>{asset-id} - the uuid of the asset in the format 'urn:aaid:aem:UUID', e.g. urn:aaid:aem:1a034bee-ebda-4787-bad3-f924d0772b75</li>
     * <li>{seo-name} - any url-encoded or alphanumeric, non-whitespace set of characters. may contain hyphens and dots</li>
     * </ul>
     * 
     * @return the path expression for the asset (bitstream) delivery path
     */
    String getAssetOriginalBinaryDeliveryPath();

    /**
     * Gets the path expression for getting the metadata of an asset. The following placeholders with the below meaning are contained within
     * that path:
     * <ul>
     * <li>{asset-id} - the uuid of the asset in the format 'urn:aaid:aem:UUID', e.g. urn:aaid:aem:1a034bee-ebda-4787-bad3-f924d0772b75</li>
     * </ul>
     * 
     * @return the path expression for the metadata path
     */
    String getAssetMetadataPath();
}