/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.wcm.style;

/**
 * Constants for style information.
 */
public final class StyleConstants {

    private StyleConstants() {
        // constants only
    }

    /**
     * Style groups node name below which allowed style groups are defined.
     */
    public static final String NN_STYLE_GROUPS = "cq:styleGroups";

    /**
     * Styles node name below which allowed styles are defined.
     */
    public static final String NN_STYLES = "cq:styles";

    /**
     * Style group multiple property name that defines whether multiple selection is allowed for an allowed style group.
     */
    public static final String PN_STYLE_GROUP_MULTIPLE = "cq:styleGroupMultiple";

    /**
     * Style group label property name that defines a readable name for an allowed style group.
     */
    public static final String PN_STYLE_GROUP_LABEL = "cq:styleGroupLabel";

    /**
     * Style ID property name that defines a unique identifier for an allowed style.
     */
    public static final String PN_STYLE_ID = "cq:styleId";

    /**
     * Style IDs property name that defines the list of styles to be applied for the resource.
     */
    public static final String PN_STYLE_IDS = "cq:styleIds";

    /**
     * Style classes property name that defines a space-separated list of CSS classes for an allowed style.
     */
    public static final String PN_STYLE_CLASSES = "cq:styleClasses";

    /**
     * Style label property name that defines a readable name for an allowed style.
     */
    public static final String PN_STYLE_LABEL = "cq:styleLabel";

    /**
     * Style element property name that defines the HTML element name of a style.
     */
    public static final String PN_STYLE_ELEMENT = "cq:styleElement";

    /**
     * Style elements property name that defines allowed HTML elements for a component.
     */
    public static final String PN_STYLE_ELEMENTS = "cq:styleElements";

    /**
     * Style default classes property name that defines a space-separated list of default CSS classes at a content policy.
     * @since com.adobe.cq.wcm.style 2.1.0
     */
    public static final String PN_STYLE_DEFAULT_CLASSES = "cq:styleDefaultClasses";

    /**
     * Style default element property name that defines the default HTML element name at a content policy.
     * @since com.adobe.cq.wcm.style 2.1.0
     */
    public static final String PN_STYLE_DEFAULT_ELEMENT = "cq:styleDefaultElement";
}