/*
 *
 *	File: FontException.java
 *
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.font;

import com.adobe.fontengine.FontEngineException;

/**
 * Generally thrown when a font is incorrect in a way that cannot be worked around.
 * 
 * <h4>Synchronization</h4>
 * 
 * <p>This class has the same threadsafety guarantees as java.lang.Exception.</p>
 
 */

public abstract class FontException extends FontEngineException {
    // invalidFont is protected by 'this'
    static final long serialVersionUID = 1;
    protected Font invalidFont = null;
    
    public FontException () {
        super ();
    }
    
    public FontException (Font font) {
        super ();
        this.invalidFont = font;
    }
    
    public FontException (String message) {
        super (message);
    }
    
    public FontException (String message, Font font) {
        super (message);
        this.invalidFont = font;
    }
    
    public FontException (String message, Throwable cause) {
        super (message, cause);
    }
    
    public FontException (String message, Throwable cause, Font font) {
        super (message, cause);
        this.invalidFont = font;
    }
    
    public FontException (Throwable cause) {
        super (cause);
    }
    
    public FontException (Throwable cause, Font font) {
        super (cause);
        this.invalidFont = font;
    }
    
    /**
     * @return the invalid font that caused the exception
     */
    public Font getFont () {
      synchronized (this) { // access to invalidFont
        return invalidFont; }
    }
    
    /**
     * @param font the invalid font that caused the exception
     */
    public void initFont (Font font) {
      synchronized (this) { // access to invalidFont
        if (this.invalidFont != null) {
            throw new IllegalStateException ("Can't overwrite font"); }
        invalidFont = font; }
    }
    
    public String toString () {
      synchronized (this) { // access to invalidFont
        return super.toString() + ((invalidFont == null) ? "" : " : " + invalidFont.toString()); }
    }
}