/*
 * File: ScalerDebugger.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.font;

import com.adobe.fontengine.font.opentype.TTOutline;

/** Receives events during the process of hinting and rasterizing glyphs.
 * 
 * This interface is intended for development purposes only.
 * 
 * During the development of {@link Scaler}s, it is useful to have access
 * to internal data structures. In a typical C/C++ environment, this is
 * achieved with debugging code bracketed by #IFDEF statements. This 
 * technique is no available in Java; here is the pattern we follow
 * instead:
 * 
 * - this interface is meant to be called by the scalers, so that they 
 * can communicate interesting events and values to outside.
 * 
 * - scalers have a {@link Scaler#setDebugger(ScalerDebugger)} method
 * which can be called by the development environment to provide an
 * implementation of this interface, and therefore receive events.
 * This method typically stores the {@link ScalerDebugger} instance
 * in a field, e.g. <code>debugger<code>.
 * 
 * - inside a scaler, the typical pattern is at an instrumentation point
 * is:
 * 
 *     if (ScalerDebugger.debugOn && debugger != null) {
 *        this.debugger.foo (...); }
 * 
 * Note that all the code related to debugging is protected the static
 * final boolean {@link #debugOn}. If that constant is false (the normal 
 * value for checked-in code and therefore for shipped code), then much 
 * of the code related to debugging is eliminated by the compiler,
 * and we are left with a small overhead (a trivial setDebugger method
 * in the scalers, a field, and the class for this interface).
 * During development, one can set this constant to true to get fully
 * functional debugging.
 */

public interface ScalerDebugger {
  /** Enable or disable debugging support. */
  public static final boolean debugOn = false;

  
  public void ttInterpLog (String s);
  
  //----------------------------------------------------------------------------
  public void cscanCross (double x, double y);
  
  //----------------------------------------------------------------------------
  
  public OutlineConsumer2 getCFFOutlineConsumer ();
  
  public void unhintedTTOutline (TTOutline outline);
  public void hintedTTOutline (TTOutline outline);
  
  //----------------------------------------------------------------------------
  public void ttScanScanType (int scanType);
  
  public void ttScanLog (String s);
  
  public void ttScanLine (int /*26.6*/ x1, int /*26.6*/ y1,
                          int /*26.6*/ x2, int /*26.6*/ y2);
  
  public void ttScanQuadCurve (int /*26.6*/ x1, int /*26.6*/ y1,
                               int /*26.6*/ x2, int /*26.6*/ y2,
                               int /*26.6*/ x3, int /*26.6*/ y3);
  
  public void ttScanHCross (int /*26.6*/ coordOnScanLine, 
                            int scanLineCoordI, boolean on);

  public void ttScanVCross (int /*26.6*/ coordOnScanLine, 
                            int scanLineCoordI, boolean on);
}
