/*
*
*	File: NameIndex.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/

package com.adobe.fontengine.font.cff;

import java.io.IOException;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFByteArray.CFFByteArrayBuilder;

/** Represents a NameINDEX.
 */

class NameIndex extends Index {
  
  /* We inherit our strategy from our superclass. */
  
  /** Construct a <code>NameIndex</code> from a <code>CFFByteArray</code>.
   * @param data the CFFByteArray to get data from
   * @param offset the offset of the first byte in <code>data</code>
   */
  public NameIndex (CFFByteArray data, int offset)
      throws IOException, InvalidFontException, UnsupportedFontException {

    super (data, offset);
  }
  
  /** Returns the value of the nth string in the NameINDEX.
   */
  public String getNthName (int n) throws InvalidFontException {
    if (n < 0 || entryCount < n) {
      return null; }
    
    int offset = offsetOf (n);
    int size = sizeOf (n);
    
    char[] chars = new char [size];
    for (int i = 0; i < size; i++) {
      chars [i] = (char) data.getcard8 (offset++); }
    
    return new String (chars);
  } 
  
  static public void toBinary (CFFByteArrayBuilder bb, String s) {
    Cursor cursor = startIndex (bb, 1);
    for (int j = 0; j < s.length (); j++) {
    	if (s.charAt(j) != 0)
    		bb.addCard8 (s.charAt (j)); }
    cursor = elementEntered (bb, cursor);
  }
}
