/*
*
*	File: Gdef.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/

package com.adobe.fontengine.font.opentype;

import java.util.Map;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray.OTByteArrayBuilder;

/** Gives access to a 'GDEF' table. */
final public class Gdef extends LayoutTable {

  protected Gdef (FontByteArray buffer) 
  throws java.io.IOException, InvalidFontException, UnsupportedFontException {
    super (buffer);
  }
  
  public int getGlyphClass (int glyph)
  throws InvalidFontException {
    
    int glyphClassOffset = this.data.getuint16 (4);
    return getClassIndex (glyph, glyphClassOffset);
  }
  
  public int getMarkAttachClass (int glyph)
  throws InvalidFontException {
    
    int markAttachOffset = this.data.getuint16 (10);
    
    if (markAttachOffset != 0) {
      return getClassIndex (glyph, markAttachOffset); }
    else {
      return 0; }
  } 
  
  public void stream(Map tables) {
	  OTByteArrayBuilder newData = this.getDataAsByteArray();
	  tables.put (new Integer (Tag.table_GDEF), newData);
  }
  
  void subsetAndStream(Subset subset, int numGlyphs, Map tables) throws InvalidFontException, UnsupportedFontException
  {
	  GdefSubsetter subsetter = new GdefSubsetter(this);
	  OTByteArrayBuilder newData = subsetter.subsetAndStream(subset, numGlyphs);
	  tables.put (new Integer (Tag.table_GDEF), newData);
	  
  }
}
