/*
 *
 *	File: Type1Glyph.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 * 
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.font.type1;

/**
 * Holds the "important" information from the charstring dictionary in
 * a type1 font. Namely, the glyphName and the charstring.
 *
 * <h4>Synchronization</h4>
 * 
 * This class is immutable after contruction and contains no mutable
 * static data. It is therefore threadsafe.
 */
final class Type1Glyph {
    final String glyphName;
    final byte[] charString;
    
    Type1Glyph(byte[] name, byte[] cstring)
    {
        charString = cstring;
        
        char[] chars = new char [name.length];
        for (int i = 0; i < name.length; i++) {
          chars [i] = (char)(name[i]& 0xff); }
        
        glyphName = new String (chars);
    }
    
    // This ctor is only used to make temporary objects for searching.
    // The cstring field remains invalid after construction.
    Type1Glyph(String name)
    {
        glyphName = name;
        charString = null;
    }
}
