/*
 *
 *	File: Type1Subset.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 * 
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.InvalidFontException;
/**
 * Type1Subset
 */
final public class Type1Subset extends SubsetDefaultImpl {
  
    final Type1Font font;
   
    Type1Subset(Type1Font font, boolean subset) throws UnsupportedFontException, InvalidFontException
    {
        super(font.getNumGlyphs(), subset);
	this.font = font;
        getSubsetGid(0); // add .notdef to the subset.
    }

	public String getSubsetGlyphName(int subsetGid)
		throws UnsupportedFontException, InvalidFontException
	{
		return font.getGlyphName(getFullGid(subsetGid));
	}
}
