/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.logging;


/**
 * A log configuration entry for the {@link LogAnalyser}
 */
public class LogConfigurationEntry {

    private final LogLevel level;

    private final String loggerName;

    /**
     * Create a new configuration entry.
     * @param level      The log level to set
     * @param loggerName The logger name (category)
     */
    public LogConfigurationEntry(final LogLevel level, final String loggerName) {
        this.level = level;
        this.loggerName = loggerName;
    }

    /**
     * Return the log level
     * @return The log level
     */
    public LogLevel getLogLevel() {
        return this.level;
    }

    /**
     * Return the logger name
     * @return The logger name
     */
    public String getLoggerName() {
        return this.loggerName;
    }
}
