/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.resourceresolverhelper;

import java.util.concurrent.Callable;

import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.annotation.versioning.ProviderType;

/**
 * The <code>ResourceResolverHelper</code> service provides access to a
 * <code>ResourceResolver</code> previously provided for the current thread.
 * <p>
 * The implementation provides two contexts:
 * <ul>
 * <li>While handling a Servlet API request the default
 * <code>ResourceResolver</code> provided is the one provided by the Sling
 * Engine through the <code>SlingHttpServletRequest</code></li>
 * <li>In a callstack opened by a call to the
 * {@link #callWith(ResourceResolver, Callable)} method</li>
 * </ul>
 * @deprecated Use {@link org.apache.sling.api.resource.ResourceResolverFactory}
 */
@Deprecated
@ProviderType
public interface ResourceResolverHelper {

    /**
     * Returns the current <code>ResourceResolver</code> for the current thread
     * or <code>null</code> if this method is called on a thread which is not
     * handling a request or which is not in a call stack started with a call to
     * the {@link #callWith(ResourceResolver, Callable)} method.
     * <p>
     * <code>ResourceResolver</code> instances must not be shared accross
     * threads because they are not thread safe.
     */
    ResourceResolver getResourceResolver();

    /**
     * Returns the current <code>ResourceResolver</code> adapted to the selected
     * type. If there is no curren <code>ResourceResolver</code> or if the
     * <code>ResourceResolver</code> does not adapt to the desired type
     * <code>null</code> is returned.
     * <p>
     * This method is equivalent to calling
     * <code>getResourceResolver().adaptTo(type)</code>.
     *
     * @param type The type to which the current <code>ResourceResolver</code>
     *            should be adapted.
     * @return The <code>ResourceResolver</code> adapted to the desired
     *         <code>type</code> or <code>null</code>
     */
    <Type> Type getResourceResolverAs(final Class<Type> type);

    /**
     * Calls the given <code>callable</code> under the provides
     * <code>ResourceResolver</code>. Before calling the <code>callable</code>
     * the <code>resolver</code> is set as the current
     * <code>ResourceResolver</code> such that the
     * {@link #getResourceResolver()} method returns the given
     * <code>ResourceResolver</code>.
     *
     * @param resolver The <code>ResourceResolver</code> to set as the current
     *            <code>ResourceResolver</code> before calling the
     *            <code>callable</code>.
     * @param callable The code to execute under the <code>resolver</code>.
     * @return The result from calling the <code>callable</code>
     * @throws NullPointerException if <code>callable</code> is
     *             <code>null</code>.
     * @throws Exception The exception thrown by the <code>callable</code> is
     *             returned.
     */
    <Type> Type callWith(final ResourceResolver resolver, final Callable<Type> callable) throws Exception;

}