/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.taskmanagement;

/**
 * <code>ComparisonOperator</code> is used in the construction of {@link Filter} expressions.
 */
public enum ComparisonOperator {
    /**
     * A value that represents the Equals operator.
     */
    EQUALS,

    /**
     * A value that represents the Greater Than operator.
     */
     GREATER_THAN,

    /**
     * A value that represents the Less Than operator.
     */
     LESS_THAN,

    /**
     * A value that represents the Not Equals operator.
     */
     NOT_EQUALS,

    /**
     * A value that represents the Greater Than Or Equals operator.
     */
     GREATER_THAN_EQUALS,

    /**
     * A value that represents the Less Than Or Equals operator.
     */
     LESS_THAN_EQUALS,

    /**
     * A value that represents the Begins With operator.
     */
     BEGINS_WITH,

    /**
     * A value that represents the Ends With operator.
     */
     ENDS_WITH,

    /**
     * A value that represents the Contains operator.
     */
     CONTAINS,

    /**
     * A value that represents the In list operator.
     */
     IN_LIST
}
