/*************************************************************************
* ADOBE CONFIDENTIAL
* ___________________
*
* Copyright 2013 Adobe
* All Rights Reserved.
*
* NOTICE: All information contained herein is, and remains
* the property of Adobe and its suppliers, if any. The intellectual
* and technical concepts contained herein are proprietary to Adobe
* and its suppliers and are protected by all applicable intellectual
* property laws, including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe.
**************************************************************************/
package com.adobe.granite.ui.components;

import java.util.Locale;

import javax.annotation.Nonnull;
import javax.servlet.jsp.PageContext;

import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.annotation.versioning.ProviderType;

/**
 * A service to resolve an expression into an actual object.
 */
@ProviderType
public interface ExpressionResolver {

    /**
     * Resolves the given expression.
     *
     * @param expression
     *            The expression to resolve
     * @param locale
     *            The locale
     * @param expectedType
     *            The type the result of the expression will be coerced to after
     *            evaluation
     * @param pageContext
     *            The current page context
     * @param <T>
     *            The type of the resolved expression
     * @return The result of expression
     */
    @Nonnull
    <T> T resolve(@Nonnull String expression, @Nonnull Locale locale, @Nonnull Class<T> expectedType,
            @Nonnull PageContext pageContext);

    /**
     * Resolves the given expression.
     *
     * @param expression
     *            The expression to resolve
     * @param locale
     *            The locale
     * @param expectedType
     *            The type the result of the expression will be coerced to after
     *            evaluation
     * @param request
     *            The current request
     * @param <T>
     *            The type of the resolved expression
     * @return The result of expression
     */
    @Nonnull
    <T> T resolve(@Nonnull String expression, @Nonnull Locale locale, @Nonnull Class<T> expectedType,
            @Nonnull SlingHttpServletRequest request);
}
