/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.collection;

import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

/**
 * The <code>ResourceCollection</code> represents a collection of jcr resources (nodes)
 * which can be added/removed.
 * The collection is also able to listen to (jcr) modifications undertaken by
 * a certain user. this modifications respectively the modified resource is added
 * to the list as well.
 */
@ProviderType
public interface ResourceCollection {

    /**
     * Name of the node containing filter definitions' items
     */
    public static final String NN_FILTER = "filter";

    /**
     * Property name of a filter's item root path
     */
    public static final String PN_FILTER_ROOT = "root";

    /**
     * All collection members are returned
     *
     * @param allowedNodeOrResourceTypes list of node primary or sling resource types to be considered. The selection by resource type doesn't include inheritance
     *
     * @return a list of all members
     *
     * @throws javax.jcr.RepositoryException in case an error occurs while
     *         fetching the list.
     */
    @Nonnull
    List<Node> list(String[] allowedNodeOrResourceTypes) throws RepositoryException;

    /**
     * Remove member
     *
     * @param node node to remove
     */
    void remove(Node node);

    /**
     * Returns collection path
     * @return collection path
     */
    String getPath();
    /**
     * @param path path to be find
     * @return true if member exist, false otherwise
     */
    boolean hasNode(String path);
}
