/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.exec;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.metadata.MetaDataMap;

/**
 * The <code>ParticipantStepChooser</code> interface is intended for impls that
 * will define the participant dynamically.
 * 
 */
public interface ParticipantStepChooser {

    /** Constant denoting the name of the label service property. Value = {@value} */
    public static final String SERVICE_PROPERTY_LABEL = "chooser.label";

    /**
     * Returns the dynamically resolved {@link java.security.Principal} id
     * 
     * @param workItem
     *            Current workitem
     * @param workflowSession
     *            Workflow session
     * @param args
     *            Participant chooser specific arguments can be passed here
     * 
     * @return the dynamically resolved {@link java.security.Principal} id
     * 
     * @throws com.adobe.granite.workflow.WorkflowException
     *             thrown in case something goes wrong during execution
     */
    String getParticipant(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args)
            throws WorkflowException;
}
