/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.workflow.rule;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkflowData;

/**
 * provides a way to implement custom rule engines in the Workflow engine
 */
public interface RuleEngine {

    /**
     * Evaluate a rule.
     * @param rule the rule data
     * @param data the associated Workflow data for the rule being evaluated
     * @param workflowSession the workflow session
     * @return true if the rule evaluated to true, false otherwise
     * @throws WorkflowException in case there's a failure during evaluation
     */
    boolean evaluate(String rule, WorkflowData data, WorkflowSession workflowSession) throws WorkflowException;

    /**
     * Indicates if the rule in question can be evaluated by this rule engine
     * @param rule the rule to be evaluated
     * @return true if this rule engine can handle this rule
     */
    boolean canEvaluate(String rule);
}
