/* $Header: /Faultline/com/adobe/acrobat/filters/DCTError.java 1     9/25/98 6:35p Gdow $$NoKeywords: $ */
/*
  DCTError.java

  The various structures used by the JPEG encoder and decoder
  Split into multiple files

  (C) Copyright 1997 Adobe Systems Inc.  All rights reserved.

  Modification log:
    5/27/97 Marc Kaufman - Java version
    2/20/97 Edward Fiala -  Version 3010 of the DCT code
*/
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFilterFormatException;



/* Errors */
class DCTError
{
    static final String dctcmmn1 = "Cannot allocate %ld bytes";
    static final String dctcmmn2 = "Unusable value 0x%X in AC HuffTable";
    static final String dctcmmn3 = "Unusable value 0x%X in DC HuffTable";
    static final String dctcmmn4 = "Caption > 32767-byte limit";
    static final String dctcmmn6 = "Invalid sampling";
    static final String dctcmmn7 = "Sum(HSamples * VSamples) > 10 limit";
    static final String dctcmmn8 = "Unusable ColorTransform=%ld";
    static final String dctcmmn9 = "Over-committed Huffman specification";
    static final String dctcmmn10 = "HuffTable exceeds %ld entry limit";
    static final String dctdcore1 = "Missing EOB Huffcode in scan %ld 8x8 block %ld";
    static final String dctdhuff1 = "Invalid JPEG RST%X marker in scan %ld block %ld";
    static final String dctdhuff2 = "Invalid JPEG marker 0x%2X in scan %ld 8x8 block %ld";
    static final String dctdhuff3 = "Huffcode too big in scan %ld 8x8 block %ld";
    static final String dctdhuff4 = "Source error or end in scan %ld 8x8 block %ld";
    static final String dctdhuff5 = "Missing marker before scan %ld 8x8 block %ld";
    static final String dctdmain1 = "Precision > 8 bits/color disallowed";
    static final String dctdmain2 = "Image width is 0";
    static final String dctdmain3 = "Image height is 0";
    static final String dctdmain4 = "Number of colors is not [1..4]";
    static final String dctdmain5 = "QuantTable precision is not 8 bits";
    static final String dctdmain6 = "QuantTable number is not [0..3]";
    static final String dctdmain7 = "Quantizer is 0";
    static final String dctdmain8 = "Input did not begin with a JPEG SOI marker";
    static final String dctdmain9 = "Invalid JPEG APPE marker";
    static final String dctdmain10 = "JPEG APPE marker scan directory length > 32";
    static final String dctdmain12 = "Invalid table number in JPEG DHT marker";
    static final String dctdmain14 = "Invalid number of colors in JPEG SOS marker";
    static final String dctdmain15 = "JPEG SOS marker component ID matches no frame ID";
    static final String dctdmain16 = "Invalid QuantTable number in JPEG SOF marker";
    static final String dctdmain17 = "More than 1 AC scan color is invalid";
    static final String dctdmain18 = "Invalid Ss Se Ah or Al field in JPEG SOS marker";
    static final String dctdmain19 = "Progressive JPEG disallowed";
    static final String dctdmain21 = "JPEG DQT marker is invalid after first scan";
    static final String dctdmain22 = "JPEG SOFn DQT or DHT marker missing before SOS marker";
    static final String dctdmain23 = "Spatial/lossless JPEG disallowed";
    static final String dctdmain24 = "Arithmetic-coded JPEG disallowed";
    static final String dctdmain25 = "Differential JPEG disallowed";
    static final String dctdmain26 = "JPEG extension marker 0x%X disallowed";
    static final String dctdmain27 = "Unknown or invalid JPEG marker = 0x%X";
    static final String dctdmain28 = "JPEG 0x%X marker too short";
    static final String dctdmain29 = "JPEG 0x%X marker too long";
    static final String dctdmain30 = "Second SOI or SOFn JPEG marker is disallowed";
    static final String dctdmain31 = "Source is not Progressive or Sequential JPEG";
    static final String dctehuff1 = "Needed code is not in HuffTable";
    static final String dctehuff2 = "Image too big for optimized JPEG";
    static final String dctemain1 = "Error or end-of-file prevented writing output";
    static final String dctemain3 = "Reposition of compressed output stream failed";
    static final String dctemain4 = "Optimized parameter conflicts with Baseline JPEG";
    static final String dctemain5 = "Part of image raster was not coded";
    static final String dctemain6 = "Required dictionary is omitted";
    static final String dctemain7 = "More than 2 unique Huffman tables exceeds JPEG Baseline limit";
    static final String dcteopen1 = "Bad JFIF Units specification";
    static final String dcteopen2 = "JPEG Comment > 65533 bytes";
    static final String dcteopen3 = "Caption is illegal without Adobe APPE marker";
    static final String dcteopen5 = "QFactor < 0.0";
    static final String dcteopen6 = "Invalid JPEG encoding method";
/* These first errors may occur during filter Open or stream execution. */
    static final String filtTypeErr = "Open parameter type incorrect";
    static final String filtRangeErr = "Open parameter out-of-range";
    static final String filtLengthErr = "Open string, array, or list parameter too long";
    static final String filtIncCombErr = "Open option combination is incompatible";
    static final String filtUndefinedErr = "Open required parameter unspecified";
    static final String filtUnimpErr = "Specified variation is legal but unimplemented";
    static final String filtResourceErr = "Required system resource unavailable, or non-existant";
    static final String filtAllocErr = "Memory allocation failed";
    static final String filtNoSuchFileErr = "Specified file cannot be opened";
    static final String filtOtherErr = "Other filter error";

  /* The 'filtSrc...' and 'filtDest...' errors occur during stream operations */
  /* 'src...Err' errors report input data or base ASStm problems. */
    static final String filtSrcEndErr = "Decode filter source terminated prematurely";
    static final String filtSrcFeebleErr = "Decode filter or its source is incapable of required operations";
    static final String filtSrcRangeErr = "Decode filter processed an out-of-range data item or an incorrect data structure";
    static final String filtSrcLengthErr = "Decode filter processed an item whose length was outside its legal range";

  /* 'dest...Err' errors report output data or output base ASStm problems. */
    static final String filtDestEndErr = "Encode filter target indicates an EOF or error";
    static final String filtDestFeebleErr = "Encode filter or its target is incapable of required operations";
    static final String filtDestRangeErr = "Encode filter processed an out-of-range data item";
    static final String filtDestLengthErr = "Encode filter processed an item whose length was outside its legal range";

    static final String filtOtherStmErr = "Other filter stream error";

  /* These errors could happen any time. */
    static final String filtBugErr = "Bug detected; filter continuation impossible";
    static final String filtBadBugErr = "Bad bug or hardware failure; terminate application";

    static void err(String dctErr, String text, String filtErr)
    throws PDFFilterFormatException
    {
        throw new PDFFilterFormatException(text);
    }
}
