/* ****************************************************************************
 *
 *	File: ASArray.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/
package com.adobe.internal.pdftoolkit.core.types;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;

public class ASArray extends ASObject implements List<ASObject>
{
	private ArrayList<ASObject> list;

	public ASArray()
	{
		list = new ArrayList<ASObject>();
	}

	
	@Override
	public String toString() {
		StringBuilder value = new StringBuilder("[ ");
		ASObject valueAtIndex = null;
		for(int i = 0; i < list.size(); i++) {
			valueAtIndex = list.get(i);
			if(valueAtIndex != null)
				value.append(valueAtIndex.toString());
			else 
				value.append("null");
			value.append(" ");
		}
		value.append("]");
		return value.toString();
	}

	public ASNumber getNumber(int index) throws PDFUnableToCompleteOperationException
	{
		ASObject obj = list.get(index);
		if (obj != null && !(obj instanceof ASNumber))
			throw new PDFUnableToCompleteOperationException("ASNumber Expected");
		return (ASNumber)obj;
	}

	public ASBoolean getBoolean(int index) throws PDFUnableToCompleteOperationException
	{
		ASObject obj = list.get(index);
		if (obj != null && !(obj instanceof ASBoolean))
			throw new PDFUnableToCompleteOperationException("ASBoolean Expected");
		return (ASBoolean)obj;
	}

	public ASName getName(int index) throws PDFUnableToCompleteOperationException
	{
		ASObject obj = list.get(index);
		if (obj != null && !(obj instanceof ASName))
			throw new PDFUnableToCompleteOperationException("ASName Expected");
		return (ASName)obj;
	}

	public ASString getString(int index) throws PDFUnableToCompleteOperationException
	{
		ASObject obj = list.get(index);
		if (obj != null && !(obj instanceof ASString))
			throw new PDFUnableToCompleteOperationException("ASString Expected");
		return (ASString)obj;
	}

	public ASArray getArray(int index) throws PDFUnableToCompleteOperationException
	{
		ASObject obj = list.get(index);
		if (obj != null && !(obj instanceof ASArray))
			throw new PDFUnableToCompleteOperationException("ASArray Expected");
		return (ASArray)obj;
	}

	public ASDictionary getDictionary(int index) throws PDFUnableToCompleteOperationException
	{
		ASObject obj = list.get(index);
		if (obj != null && !(obj instanceof ASDictionary))
			throw new PDFUnableToCompleteOperationException("ASDictionary Expected");
		return (ASDictionary)obj;
	}

	/* (non-Javadoc)
	 * @see java.util.List#size()
	 */
	public int size() {
		return list.size();
	}

	/* (non-Javadoc)
	 * @see java.util.List#clear()
	 */
	public void clear() {
		list.clear();
	}

	/* (non-Javadoc)
	 * @see java.util.List#isEmpty()
	 */
	public boolean isEmpty() {
		return list.isEmpty();
	}

	
	/* (non-Javadoc)
	 * @see java.util.List#toArray()
	 */
	public Object[] toArray() {
		return list.toArray();
	}

	/* (non-Javadoc)
	 * @see java.util.List#get(int)
	 */
	public ASObject get(int index) {

		return list.get(index);
	}

	/* (non-Javadoc)
	 * @see java.util.List#remove(int)
	 */
	public ASObject remove(int index) {
		return list.remove(index);
	}

	
	/* (non-Javadoc)
	 * @see java.util.List#add(int, java.lang.Object)
	 */
	public void add(int index, ASObject element) {
		list.add(index, element);
	}

	
	/* (non-Javadoc)
	 * @see java.util.List#indexOf(java.lang.Object)
	 */
	public int indexOf(Object o) {
		return list.indexOf(o);
	}

	
	/* (non-Javadoc)
	 * @see java.util.List#lastIndexOf(java.lang.Object)
	 */
	public int lastIndexOf(Object o) {
		return list.lastIndexOf(o);
	}

	
	/* (non-Javadoc)
	 * @see java.util.List#add(java.lang.Object)
	 */
	public boolean add(ASObject o) {
		return list.add(o);
	}

	
	/* (non-Javadoc)
	 * @see java.util.List#contains(java.lang.Object)
	 */
	public boolean contains(Object o) {
		return list.contains(o);
	}

	
	/* (non-Javadoc)
	 * @see java.util.List#remove(java.lang.Object)
	 */
	public boolean remove(Object o) {
		return list.remove(o);
	}

	
	/* (non-Javadoc)
	 * @see java.util.List#addAll(int, java.util.Collection)
	 */
	public boolean addAll(int index, Collection<? extends ASObject> c) {
		return list.addAll(index, c);
	}

	
	/* (non-Javadoc)
	 * @see java.util.List#addAll(java.util.Collection)
	 */
	public boolean addAll(Collection<? extends ASObject> c) {
		return list.addAll(c);
	}

	
	/* (non-Javadoc)
	 * @see java.util.List#containsAll(java.util.Collection)
	 */
	public boolean containsAll(Collection<?> c) {
		return list.containsAll(c);
	}

	
	/* (non-Javadoc)
	 * @see java.util.List#removeAll(java.util.Collection)
	 */
	public boolean removeAll(Collection<?> c) {
		return list.removeAll(c);
	}

	/* (non-Javadoc)
	 * @see java.util.List#retainAll(java.util.Collection)
	 */
	public boolean retainAll(Collection<?> c) {
		return list.retainAll(c);
	}

	
	/* (non-Javadoc)
	 * @see java.util.List#iterator()
	 */
	public Iterator<ASObject> iterator() {
		return list.iterator();
	}

	
	/* (non-Javadoc)
	 * @see java.util.List#subList(int, int)
	 */
	public List<ASObject> subList(int fromIndex, int toIndex) {
		return list.subList(fromIndex, toIndex);
	}

	
	/* (non-Javadoc)
	 * @see java.util.List#listIterator()
	 */
	public ListIterator<ASObject> listIterator() {
		return list.listIterator();
	}

	
	/* (non-Javadoc)
	 * @see java.util.List#listIterator(int)
	 */
	public ListIterator<ASObject> listIterator(int index) {
		return list.listIterator(index);
	}

	
	/* (non-Javadoc)
	 * @see java.util.List#set(int, java.lang.Object)
	 */
	public ASObject set(int index, ASObject element) {
		return list.set(index, element);
	}
	
	
	/* (non-Javadoc)
	 * @see java.util.List#toArray(java.lang.Object[])
	 */
	public Object[] toArray(Object[] a) {
		return list.toArray(a);
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.pdftoolkit.core.cos.util.ASObject#write(java.io.OutputStream)
	 */
	@Override
	public void write(OutputByteStream outputByteStream)
		throws PDFIOException
	{
		try {
			outputByteStream.write('[');
			Iterator iter = this.iterator();
			while(iter.hasNext()) {
				ASObject value = (ASObject)(iter.next());
				value.write(outputByteStream);
	   
				if (iter.hasNext())
					outputByteStream.write(' ');
			}
			outputByteStream.write(']');
		} catch (IOException e) {
			throw new PDFIOException(e);
		}
	}
}
