/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.reef.siren.builder;

import java.util.LinkedList;
import java.util.List;

import com.adobe.reef.siren.Action;
import com.adobe.reef.siren.Field;
import com.adobe.reef.siren.Action.Method;

/**
 * {@code ActionBuilder} is a {@link Builder} implementation for {@link Action}.
 */
public class ActionBuilder extends Builder<Action> {

    private String name;

    private String[] clazz;

    private Method method;

    private String href;

    private String title;

    private String type;

    private List<Field> fields = new LinkedList<Field>();

    public ActionBuilder() {

    }

    public ActionBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ActionBuilder setClass(String[] clazz) {
        this.clazz = clazz;
        return this;
    }

    public ActionBuilder setMethod(Method method) {
        this.method = method;
        return this;
    }

    public ActionBuilder setHref(String href) {
        this.href = href;
        return this;
    }

    public ActionBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public ActionBuilder setType(String type) {
        this.type = type;
        return this;
    }

    public ActionBuilder setFields(List<Field> fields) {
        this.fields = fields;
        return this;
    }

    public ActionBuilder addField(Field field) {
        this.fields.add(field);
        return this;
    }

    public ActionBuilder clear() {
        clazz = null;
        method = null;
        type = null;
        title = null;
        fields.clear();
        return this;
    }

    protected Action doBuild() throws BuilderException {
        try {
            Action action = new Action(name, href);
            action.setClazz(clazz);
            action.setMethod(method);
            action.setType(type);
            action.setTitle(title);
            action.setFields(fields);
            return action;
        } catch (IllegalArgumentException e) {
            throw new BuilderException(e.getMessage(), e);
        }
    }

    protected void validate(Action action) throws BuilderValidationException {
        if (action.getName() == null || action.getName().isEmpty() ||
                action.getHref() == null || action.getHref().isEmpty()) {
            throw new BuilderValidationException("name and href attribute cannot be null or empty.");
        }
    }

}
