/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

/**
 * An element that describes a unit of xml dsig data.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */

public final class DSigData extends Element {

	public DSigData(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.DSIGDATA, XFA.DSIGDATA, null,
				XFA.DSIGDATATAG, XFA.DSIGDATA);
	}

	
	/**
	 * Get the text stored in this element
	 * @param bAsFragment get text as XML fragment if TRUE
	 * @return the text string
	 */
	public String getValue(boolean bAsFragment/*=FALSE*/) {
		return getValuesFromDom(bAsFragment, this);
	}

	/**
	 * Cast this element to a String.  This allows this object to be used in
	 * contexts where a string is expected without needing to explicitly call
	 * getValue().
	 * @return the text value.
	 */
	public String toString() {
		return getValue(false);
	}
 
	/**
	 * Set the value of this element
	 * @param sText xml to replace the dom element stored in this element
	 */
	void setValue(String sText) {
		
		//JavaPort:
		// The C++ equivalent re-populates the jfDOM and re-sets the peer.
		// In Java we'll just replace our children with the provided XML.
		// Hopefully this works without needing to replace/update the current node ?
		ByteArrayInputStream is;
        try {
            is = new ByteArrayInputStream(sText.getBytes(Document.Encoding));
    		loadXML(is, false,true);
        } catch (UnsupportedEncodingException e) {
        }
	}

	static String getValuesFromDom(boolean bAsFragment, Node oDomNode) {
		StringBuilder htmlTextValue = new StringBuilder();
		if (bAsFragment) {
			//Use UTF-8 converter to avoid losing asian characters
			ByteArrayOutputStream oFragmentStream = new ByteArrayOutputStream();
			DOMSaveOptions oOptions = new DOMSaveOptions();
			oOptions.setSaveTransient(true);
			oOptions.setDisplayFormat(DOMSaveOptions.RAW_OUTPUT);
			oDomNode.getOwnerDocument().saveAs(oFragmentStream, oDomNode, oOptions);
			htmlTextValue.append(oFragmentStream.toString());
		}
		else {
			htmlTextValue.append(oDomNode.getData());
			
			Node oChild = oDomNode.getFirstXMLChild();
			while (oChild != null) {
				htmlTextValue.append(getValuesFromDom(bAsFragment, oChild));
				oChild = oChild.getNextXMLSibling();
			}
		}
		return htmlTextValue.toString();
	}
	
}
