/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EventManager;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptHandler;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.Container;


/**
 * @exclude from public api.
 */
class ScriptRunAtDispatcher extends com.adobe.xfa.ScriptDispatcher {
	
	private final int meRunAt;
	
	
	ScriptRunAtDispatcher(Element scriptContextNode,
						  String sEventContext,
						  int nEventID,
						  EventManager eventManager,
						  String sScript,
						  String sContentType,
						  int eRunAt,
						  String sTarget) {
		super(scriptContextNode,
				sEventContext, 
				nEventID, 
				eventManager,
				sScript,
				sContentType);		
		
		meRunAt = eRunAt;
	}

	public void dispatch() {
		Element node = getActionContextNode();

		if (node == null)
			return;
		
		String sContentType = getContentType();
		int eRunAt = getRunAt();
		int nEventID = getEventID();

		assert( node instanceof FormField ||
				node instanceof FormSubform ||
				node instanceof FormExclGroup);

		// note would be nice to directly access mpoFieldImpl.mpModel
		FormModel formModel = (FormModel)(node.getModel());

		if (formModel == null)
			return;		// a remerge() can cause the form model to be null
		
		// As of //https://zerowing.corp.adobe.com/display/xtg/InactivePresenceXFAProposal,
		// event processing associated with inactive containers must not occur.
		// To mitigate performance on older forms, only do this check for XFA 3.0 documents and higher.
		AppModel appModel = node.getAppModel();
		if (appModel != null) {
			TemplateModel templateModel = TemplateModel.getTemplateModel(appModel, false);
			if ((templateModel != null) &&
				(templateModel.getOriginalXFAVersion() >= Schema.XFAVERSION_30) &&
		        (node instanceof Container)) {
				Container container = (Container)node;
				int ePresence = container.getRuntimePresence(EnumAttr.UNDEFINED);
				if (EnumAttr.PRESENCE_INACTIVE == ePresence)
					return;
			}
		}

		String sActivity = getEventManager().getEventIDByIndex(nEventID).msEventName;

		int eModelRunAtSetting = formModel.getRunScripts();

		// ensure we can run the script
		if (eModelRunAtSetting == EnumAttr.RUNSCRIPTS_NONE)
			return;
		else if (eModelRunAtSetting == EnumAttr.RUNSCRIPTS_SERVER && eRunAt == EnumAttr.RUNAT_CLIENT)
			return;
		else if (eModelRunAtSetting == EnumAttr.RUNSCRIPTS_CLIENT && eRunAt == EnumAttr.RUNAT_SERVER)
		{
			// Not a match, so skip execution of script, with one exception.
			// If we're set to be the client (i.e. eModelRunAtSetting == EnumAttr.RUNSCRIPTS_CLIENT)
			// and we're provided with a ServerExchange, ship the entire data
			// dom to the server and retrieve its response.
			formModel.serverExchange(node, sActivity);
			return;
		}
		
		String sScript = getScript();
		node.evaluate(sScript, sContentType, ScriptHandler.stringToExecuteReason(sActivity), true);
	}

	int getRunAt() {
		return meRunAt;
	}
}
