/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template;


import com.adobe.xfa.ChildReln;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.ImagingBBoxEnum;
import com.adobe.xfa.Int;
import com.adobe.xfa.Measurement;
import com.adobe.xfa.Schema;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.STRS;
import com.adobe.xfa.XFA;
import com.adobe.xfa.template.containers.Rotate;
import com.adobe.xfa.svg.SVGSchema;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;


/**
 * Hold the schema relationships for the XFA Template DOM.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public class TemplateSchema extends Schema {

	private final ChildReln moZeroOrMore2;

	private final ChildReln moZeroOrMore4;

	/**
	 * @exclude from public api.
	 */
	public TemplateSchema() {
		super(STRS.XFATEMPLATENS,
				XFA.XFA_ATTRIBUTE_MIN, 
				XFA.XFA_ATTRIBUTE_MAX, 
				XFA.XFA_ELEMENT_MIN, 
				XFA.XFA_ELEMENT_MAX);

		moZeroOrMore2 = new ChildReln(ChildReln.zeroOrMore, 2);
		moZeroOrMore4 = new ChildReln(ChildReln.zeroOrMore, 4);

		initSchema();
	}

	// To add an Attribute to the TemplateSchema, follow these steps:
	// 1. Add the attribute name as a namespace in xfanamespace.h+cpp
	// 2. Add the attribute to 'mAttrNames', and up the value of
	// XFA_TEMPLATE_ATTR_COUNT by one
	// 3. Add the attribute will a default value to mAttributes
	// 4. For each element that this attribute will apply to, add it's name
	// to the attribute list for this element schema definition (the
	// attribute list definition used in the putSchema(element) call)

	protected void initSchema() {
		//
		// populate the schema relationships
		//
		super.initSchema();
		// proto
		// children are added by putPropAttrs and putChildAttrs

		// assist
		// Added with CL38709 Aug 13, 2002
		putPropAttrs(XFA.ASSISTTAG);
		putAttribute(XFA.ASSISTTAG, XFA.ROLETAG, null, Schema.XFAVERSION_22, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_ROLE, */ 0); // Added with CL139919 July 15, 2004
		putElement(XFA.ASSISTTAG, XFA.SPEAKTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_SPEAK, */ 0); // Added with CL38709 Aug 13, 2002
		putElement(XFA.ASSISTTAG, XFA.TOOLTIPTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TOOLTIP, */ 0); // Added with CL38867 Aug 19, 2002

		// bind
		// Added with CL40262 Oct 9, 2002
		// Added nullType attribute with CL62451 Aug 6, 2003
		// Added connection attribute with CL74309 Nov 13, 2003
		// Added usage attribute with CL74309 Nov 13, 2003
		// Removed connection attribute with CL74659 Nov 17, 2003
		// Removed usage attribute with CL74659 Nov 17, 2003
		putAttribute(XFA.BINDTAG, XFA.REFTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_REF_BIND, */ 0); // Added with CL40262 Oct 9, 2002
		putAttribute(XFA.BINDTAG, EnumValue.getEnum(XFA.MATCHTAG, EnumAttr.getEnum(EnumAttr.MATCH_ONCE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_MATCH, */ 0); // Added with CL40262 Oct 9, 2002
		putElement(XFA.BINDTAG, XFA.PICTURETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_PICTURE, */ 0); // Added with CL40262 Oct 9, 2002

		// bindItems
		// Added with CL181307 Mar 4, 2005
		putAttribute(XFA.BINDITEMSTAG, XFA.REFTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_REF_BINDITEMS, */ 0); // Added with CL181307 Mar 4, 2005
		putAttribute(XFA.BINDITEMSTAG, XFA.CONNECTIONTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_CONNECTION_BINDITEMS, */ 0);	// Added with CL181307 Mar 4, 2005
		putAttribute(XFA.BINDITEMSTAG, XFA.LABELREFTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_LABELREF, */ 0);	// Added with CL181307 Mar 4, 2005
		putAttribute(XFA.BINDITEMSTAG, XFA.VALUEREFTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_VALUEREF, */ 0);	// Added with CL181307 Mar 4, 2005

		// setProperty
		// Added with CL181307 Mar 4, 2005
		putAttribute(XFA.SETPROPERTYTAG, XFA.REFTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_REF_SETPROPERTY, */ 0); // Added with CL181307 Mar 4, 2005
		putAttribute(XFA.SETPROPERTYTAG, XFA.CONNECTIONTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_CONNECTION_SETPROPERTY, */ 0); // Added with CL181307 Mar 4, 2005
		putAttribute(XFA.SETPROPERTYTAG, XFA.TARGETTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TARGET_SETPROPERTY, */ 0); // Added with CL181307 Mar 4, 2005

		// button
		putPropAttrs(XFA.BUTTONTAG);
		putAttribute(XFA.BUTTONTAG, EnumValue.getEnum(XFA.HIGHLIGHTTAG, EnumAttr.getEnum(EnumAttr.HIGHLIGHT_INVERTED)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_HIGHLIGHT, */ 0); // Added with CL290364 Apr 12, 2006
		putElement(XFA.BUTTONTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// datetimeedit
		putPropAttrs(XFA.DATETIMEEDITTAG);
		putAttribute(XFA.DATETIMEEDITTAG, EnumValue.getEnum(XFA.HSCROLLPOLICYTAG, EnumAttr.getEnum(EnumAttr.SCROLLPOLICY_AUTO)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_HSCROLLPOLICY, */ 0); // Added with CL271273 Jan 27, 2006
		putAttribute(XFA.DATETIMEEDITTAG, EnumValue.getEnum(XFA.PICKERTAG, EnumAttr.getEnum(EnumAttr.PICKER_HOST)), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_PICKER, */ 0); 
		putElement(XFA.DATETIMEEDITTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		putElement(XFA.DATETIMEEDITTAG, XFA.BORDERTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BORDER, */ 0); // Added with CL65290 Sep 8, 2003
		putElement(XFA.DATETIMEEDITTAG, XFA.MARGINTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_MARGIN, */ 0); // Added with CL68513 Oct 3, 2003
		putElement(XFA.DATETIMEEDITTAG, XFA.COMBTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_COMB, */ 0); // Added with CL288351 Apr 5, 2006

		// certificates
		// Added with CL130260 May 20, 2004
		putPropAttrs(XFA.CERTIFICATESTAG);
		putAttribute(XFA.CERTIFICATESTAG, XFA.URLTAG, null, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_URL, */ 0); // Added with CL130260 May 20, 2004
		putAttribute(XFA.CERTIFICATESTAG, XFA.URLPOLICYTAG, new StringAttr(XFA.URLPOLICY, "enrollmentServer"), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_URLPOLICY, */ 0); // Added with CL315612 Jul 6, 2006
		putAttribute(XFA.CERTIFICATESTAG, EnumValue.getEnum(XFA.CREDENTIALSERVERPOLICYTAG, EnumAttr.getEnum(EnumAttr.CREDENTIAL_OPTIONAL)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_CREDENTIALSERVERPOLICY, */ 0); // Added with CL315612 Jul 6, 2006
		putElement(XFA.CERTIFICATESTAG, XFA.SIGNINGTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_SIGNING, */ 0); // Added with CL130260 May 20, 2004
		putElement(XFA.CERTIFICATESTAG, XFA.ISSUERSTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_ISSUERS, */ 0); // Added with CL130260 May 20, 2004
		putElement(XFA.CERTIFICATESTAG, XFA.OIDSTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_OIDS, */ 0); // Added with CL130260 May 20, 2004
		putElement(XFA.CERTIFICATESTAG, XFA.SUBJECTDNSTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_SUBJECTDNS, */ 0); // Added with CL315612 Jul 6, 2006
		putElement(XFA.CERTIFICATESTAG, XFA.KEYUSAGETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_KEYUSAGE, */ 0); // Added with CL315612 Jul 6, 2006

		// certificate
		// Added with CL130260 May 20, 2004
		putChildAttrs(XFA.CERTIFICATETAG);
		putElement(XFA.CERTIFICATETAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTNODE_CERTIFICATE, */ 0); // Added with CL130260 May 20, 2004

		// subjectDNs
		// Added with CL315612 Jul 6, 2006
		putPropAttrs(XFA.SUBJECTDNSTAG);
		putAttribute(XFA.SUBJECTDNSTAG, EnumValue.getEnum(XFA.TYPETAG, EnumAttr.getEnum(EnumAttr.REQUIREMENT_OPTIONAL)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_TYPE, */ 0); // Added with CL315612 Jul 6, 2006
		putElement(XFA.SUBJECTDNSTAG, XFA.SUBJECTDNTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_SUBJECTDN, */ 0); // Added with CL315612 Jul 6, 2006

		// subjectDN
		// Added with CL315612 Jul 6, 2006
		// Removed delimiter attribute with CL316436 Jul 11, 2006
		// Added delimiter attribute with CL317221 Jul 14, 2006
		putChildAttrs(XFA.SUBJECTDNTAG);
		putAttribute(XFA.SUBJECTDNTAG, XFA.DELIMITERTAG, new StringAttr(XFA.DELIMITER, ","), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_DELIMITER, */ 0); // Added with CL317221 Jul 14, 2006
		putElement(XFA.SUBJECTDNTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_TEXTNODE_SUBJECTDN, */ 0); // Added with CL315612 Jul 6, 2006

		// keyUsage
		// Added with CL315612 Jul 6, 2006
		putPropAttrs(XFA.KEYUSAGETAG);
		putAttribute(XFA.KEYUSAGETAG, XFA.DIGITALSIGNATURETAG, null, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_DIGITALSIGNATURE, */ 0); // Added with CL315612 Jul 6, 2006
		putAttribute(XFA.KEYUSAGETAG, XFA.NONREPUDIATIONTAG, null, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_NONREPUDIATION, */ 0); // Added with CL315612 Jul 6, 2006
		putAttribute(XFA.KEYUSAGETAG, XFA.KEYENCIPHERMENTTAG, null, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_KEYENCIPHERMENT, */ 0); // Added with CL315612 Jul 6, 2006
		putAttribute(XFA.KEYUSAGETAG, XFA.DATAENCIPHERMENTTAG, null, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_DATAENCIPHERMENT, */ 0); // Added with CL315612 Jul 6, 2006
		putAttribute(XFA.KEYUSAGETAG, XFA.KEYAGREEMENTTAG, null, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_KEYAGREEMENT, */ 0); // Added with CL315612 Jul 6, 2006
		putAttribute(XFA.KEYUSAGETAG, XFA.KEYCERTSIGNTAG,  null, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_KEYCERTSIGN, */ 0); // Added with CL315612 Jul 6, 2006
		putAttribute(XFA.KEYUSAGETAG, XFA.CRLSIGNTAG,   null, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_CRLSIGN, */ 0); // Added with CL315612 Jul 6, 2006
		putAttribute(XFA.KEYUSAGETAG, XFA.ENCIPHERONLYTAG, null, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_ENCIPHERONLY, */ 0); // Added with CL315612 Jul 6, 2006
		putAttribute(XFA.KEYUSAGETAG, XFA.DECIPHERONLYTAG, null, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_DECIPHERONLY, */ 0); // Added with CL315612 Jul 6, 2006
		putAttribute(XFA.KEYUSAGETAG, EnumValue.getEnum(XFA.TYPETAG, EnumAttr.getEnum(EnumAttr.REQUIREMENT_OPTIONAL)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_DECIPHERONLY, */ 0); // Added with CL315612 Jul 6, 2006

		// defaultUi
		putPropAttrs(XFA.DEFAULTUITAG);
		putElement(XFA.DEFAULTUITAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// solid
		putPropAttrs(XFA.SOLIDTAG);
		putElement(XFA.SOLIDTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// break
		// Removed reserveH with CL45166 Feb 20, 2003
		// Removed onChange with CL51258 Apr 17, 2003
		// Removed afterException, afterStrength, beforeException, befterStrength with CL60140 Jul 7, 2003
		// Removed bookendLeader attribute with CL68936 Oct 6, 2003
		// Removed bookendTrailer attribute with CL68936 Oct 6, 2003
		// Added afterLeader attribute with CL181321 Mar 4, 2005
		// Added afterTest attribute with CL181321 Mar 4, 2005
		// Added afterTrailer attribute with CL181321 Mar 4, 2005
		// Added beforeLeader attribute with CL181321 Mar 4, 2005
		// Added beforeTest attribute with CL181321 Mar 4, 2005
		// Added beforeTrailer attribure with CL181321 Mar 4, 2005
		// Added leader attribute with CL183667 Mar 14, 2005
		// Added trailer attribute with CL183667 Mar 14, 2005
		// Removed afterLeader attribute with CL186214 Mar 23, 2005
		// Removed afterTest attribute with CL186214 Mar 23, 2005
		// Removed afterTrailer attribute with CL186214 Mar 23, 2005
		// Removed beforeLeader attribute with CL186214 Mar 23, 2005
		// Removed beforeTest attribute with CL186214 Mar 23, 2005
		// Removed beforeTrailer attribure with CL186214 Mar 23, 2005
		// Removed leader attribute with CL193310 Apr 22, 2005
		// Removed trailer attribute with CL193310 Apr 22, 2005
		// Added breakLeader attribute with CL193310 Apr 22, 2005
		// Added breakTrailer attribute with CL193310 Apr 22, 2005
		// Removed breakLeader attribute with CL204030 May 29, 2005
		// Removed breakTrailer attribute with CL204030 May 29, 2005
		//
		// NOTE: As indicated in http://xtg.can.adobe.com/twiki/bin/view/XFA/ConditionalBreakXFAV24Proposal, the <break>
		// element is deprecated. It will remain part of the schema and be supported for backwards compatibility.
		// Ideally users should be using one or more of <breakBefore>/<breakAfter>/<overflow>/<bookend>
		putPropAttrs(XFA.BREAKTAG);
		putAttribute(XFA.BREAKTAG, XFA.AFTERTARGETTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_AFTERTARGET, Schema.XFAVERSION_24, */ 0);
		putAttribute(XFA.BREAKTAG, EnumValue.getEnum(XFA.AFTERTAG, EnumAttr.getEnum(EnumAttr.BREAK_AUTO)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_AFTER, Schema.XFAVERSION_24, */ 0);
		putAttribute(XFA.BREAKTAG, XFA.BEFORETARGETTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_BEFORETARGET, Schema.XFAVERSION_24, */ 0);
		putAttribute(XFA.BREAKTAG, EnumValue.getEnum(XFA.BEFORETAG, EnumAttr.getEnum(EnumAttr.BREAK_AUTO)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_BEFORE, Schema.XFAVERSION_24, */ 0);
		putAttribute(XFA.BREAKTAG, XFA.BOOKENDLEADERTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_BOOKENDLEADER, Schema.XFAVERSION_24, */ 0); // Added with CL69030 Oct 7, 2003
		putAttribute(XFA.BREAKTAG, XFA.BOOKENDTRAILERTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_BOOKENDTRAILER, Schema.XFAVERSION_24, */ 0);
		putAttribute(XFA.BREAKTAG, XFA.OVERFLOWLEADERTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_OVERFLOWLEADER, Schema.XFAVERSION_24, */ 0);
		putAttribute(XFA.BREAKTAG, XFA.OVERFLOWTARGETTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_OVERFLOWTARGET, Schema.XFAVERSION_24, */ 0);
		putAttribute(XFA.BREAKTAG, XFA.OVERFLOWTRAILERTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_OVERFLOWTRAILER, Schema.XFAVERSION_24, */ 0);
		putAttribute(XFA.BREAKTAG, EnumValue.getEnum(XFA.STARTNEWTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_STARTNEW_BREAK, Schema.XFAVERSION_24, */ 0);
		putElement(XFA.BREAKTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, Schema.XFAVERSION_24, */ 0);

		// choiceList
		// Added with CL14260 Mar 1, 2000
		putPropAttrs(XFA.CHOICELISTTAG);
		putAttribute(XFA.CHOICELISTTAG, EnumValue.getEnum(XFA.COMMITONTAG, EnumAttr.getEnum(EnumAttr.COMMITON_SELECT)), Schema.XFAVERSION_22, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_COMMITON, */ 0); // Added with CL129344 May 14, 2004
		putAttribute(XFA.CHOICELISTTAG, EnumValue.getEnum(XFA.OPENTAG, EnumAttr.getEnum(EnumAttr.USER_CONTROL)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_OPEN, */ 0); // Added with CL18907 Oct 5, 2000
		putAttribute(XFA.CHOICELISTTAG, EnumValue.getEnum(XFA.TEXTENTRYTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TEXTENTRY, */ 0); // Added with CL18907 Oct 5, 2000
		putElement(XFA.CHOICELISTTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0); // Addd with CL14260 Mar 1, 2000
		putElement(XFA.CHOICELISTTAG, XFA.BORDERTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BORDER, */ 0); // Added with CL65290 Sep 8, 2003
		putElement(XFA.CHOICELISTTAG, XFA.MARGINTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_MARGIN, */ 0); // Added with CL68513 Oct 3, 2003

		// color
		// Added with CL14260 Mar 1, 2000
		putPropAttrs(XFA.COLORTAG);
		putAttribute(XFA.COLORTAG, XFA.CSPACETAG, new StringAttr(XFA.CSPACE, STRS.SRGB), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_CSPACE, */ 0); // Added with CL14260 Mar 1, 2000
		putAttribute(XFA.COLORTAG, XFA.VALUETAG, new StringAttr(XFA.VALUE, STRS.BLACKCOLOR), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_VALUE_COLOR, */ 0); // Added with CL14380 Mar 3, 2000
		putElement(XFA.COLORTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0); // Added with CL14260 Mar 1, 2000

		// breakBefore
		// Added with CL203583 May 26, 2005
		putPropAttrs(XFA.BREAKBEFORETAG);
		putAttribute(XFA.BREAKBEFORETAG, XFA.TARGETTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TARGET, */ 0); // Added with CL203583 May 26, 2005
		putAttribute(XFA.BREAKBEFORETAG, EnumValue.getEnum(XFA.TARGETTYPETAG, EnumAttr.getEnum(EnumAttr.BREAK_AUTO)), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TARGETTYPE_BREAKBEFORE, */ 0); // Added with CL203583 May 26, 2005
		putAttribute(XFA.BREAKBEFORETAG, XFA.LEADERTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_LEADER, */ 0); // Added with CL203583 May 26, 2005
		putAttribute(XFA.BREAKBEFORETAG, XFA.TRAILERTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TRAILER, */ 0); // Added with CL203583 May 26, 2005
		putAttribute(XFA.BREAKBEFORETAG, EnumValue.getEnum(XFA.STARTNEWTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_STARTNEW, */ 0); // Added with CL203583 May 26, 2005
		putElement(XFA.BREAKBEFORETAG, XFA.SCRIPTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_SCRIPT, */ 0); // Added with CL203583 May 26, 2005

		// breakAfter
		// Added with CL203583 May 26, 2005
		putPropAttrs(XFA.BREAKAFTERTAG);
		putAttribute(XFA.BREAKAFTERTAG, XFA.TARGETTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TARGET, */ 0); // Added with CL203583 May 26, 2005
		putAttribute(XFA.BREAKAFTERTAG, EnumValue.getEnum(XFA.TARGETTYPETAG, EnumAttr.getEnum(EnumAttr.BREAK_AUTO)), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TARGETTYPE_BREAKAFTER, */ 0); // Added with CL203583 May 26, 2005
		putAttribute(XFA.BREAKAFTERTAG, XFA.LEADERTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_LEADER, */ 0); // Added with CL203583 May 26, 2005
		putAttribute(XFA.BREAKAFTERTAG, XFA.TRAILERTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TRAILER, */ 0); // Added with CL203583 May 26, 2005
		putAttribute(XFA.BREAKAFTERTAG, EnumValue.getEnum(XFA.STARTNEWTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_STARTNEW, */ 0); // Added with CL203583 May 26, 2005
		putElement(XFA.BREAKAFTERTAG, XFA.SCRIPTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_SCRIPT, */ 0); // Added with CL203583 May 26, 2005

		// overflow
		// Added with CL203583 May 26, 2005
		putPropAttrs(XFA.OVERFLOWTAG);
		putAttribute(XFA.OVERFLOWTAG, XFA.LEADERTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_LEADER, */ 0); // Added with CL203583 May 26, 2005
		putAttribute(XFA.OVERFLOWTAG, XFA.TRAILERTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TRAILER, */ 0); // Added with CL203583 May 26, 2005
		putAttribute(XFA.OVERFLOWTAG, XFA.TARGETTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TARGET_OVERFLOW, */ 0); // Added with CL203583 May 26, 2005

		// bookend
		// Added with CL203583 May 26, 2005
		putPropAttrs(XFA.BOOKENDTAG);
		putAttribute(XFA.BOOKENDTAG, XFA.LEADERTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_LEADER, */ 0); // Added with CL203583 May 26, 2005
		putAttribute(XFA.BOOKENDTAG, XFA.TRAILERTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TRAILER, */ 0); // Added with CL203583 May 26, 2005

		// connect
		// Added with CL74659 Nov 17, 2003
		putPropAttrs(XFA.CONNECTTAG);
		putAttribute(XFA.CONNECTTAG, XFA.REFTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_REF_CONNECT, */ 0); // Added with CL74659 Nov 17, 2003
		putAttribute(XFA.CONNECTTAG, XFA.CONNECTIONTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_CONNECTION, */ 0); // Added with CL74659 Nov 17, 2003
		putAttribute(XFA.CONNECTTAG, EnumValue.getEnum(XFA.USAGETAG, EnumAttr.getEnum(EnumAttr.USAGE_EXPORTANDIMPORT)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_USAGE, */ 0); // Added with CL74659 Nov 17, 2003
		putElement(XFA.CONNECTTAG, XFA.PICTURETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_PICTURE); // Added with CL74659 Nov 17, 2003, */ 0);

		// date
		// Added with CL77101 Dec 7, 2003
		putChildAttrs(XFA.DATETAG);
		putElement(XFA.DATETAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTNODE_DATE, */ 0); // Added with CL77101 Dec 7, 2003

		// dateTime
		// Added with CL77101 Dec 7, 2003
		putChildAttrs(XFA.DATETIMETAG);
		putElement(XFA.DATETIMETAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTNODE_DATETIME, */ 0); // Added with CL77101 Dec 7, 2003

		// decimal
		// Added with CL77101 Dec 7, 2003
		putChildAttrs(XFA.DECIMALTAG);
		putAttribute(XFA.DECIMALTAG, XFA.FRACDIGITSTAG, new Int(XFA.FRACDIGITS, 2), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_FRACDIGITS, */ 0); // Added with CL77101 Dec 7, 2003
		putAttribute(XFA.DECIMALTAG, XFA.LEADDIGITSTAG, new Int(XFA.LEADDIGITS, -1), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_LEADDIGITS, */ 0);	// Added with CL77101 Dec 7, 2003
		putElement(XFA.DECIMALTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTNODE_DECIMAL, */ 0); // Added with CL77101 Dec 7, 2003

		// filter
		// Added with CL130260 May 20, 2004
		putChildAttrs(XFA.FILTERTAG);
		putAttribute(XFA.FILTERTAG, XFA.VERSIONTAG, null, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_VERSION, */ 0); // Added with CL326612 Aug 23, 2006
		putAttribute(XFA.FILTERTAG, XFA.ADDREVOCATIONINFOTAG, null, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_ADDREVOCATIONINFO, */ 0); // Added with CL315612 Jul 6, 2006
		putElement(XFA.FILTERTAG, XFA.HANDLERTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_HANDLER, */ 0); // Added with CL130260 May 20, 2004
		putElement(XFA.FILTERTAG, XFA.REASONSTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_REASONS, */ 0); // Added with CL130260 May 20, 2004
		putElement(XFA.FILTERTAG, XFA.CERTIFICATESTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_CERTIFICATES, */ 0); // Added with CL130260 May 20, 2004
		putElement(XFA.FILTERTAG, XFA.MDPTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_MDP, */ 0); // Added with CL262678 Dec 20, 2005
		putElement(XFA.FILTERTAG, XFA.TIMESTAMPTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_TIMESTAMP, */ 0); // Added with CL262678 Dec 20, 2005
		putElement(XFA.FILTERTAG, XFA.ENCODINGSTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_ENCODINGS, */ 0); // Added with CL315612 Jul 6, 2006
		putElement(XFA.FILTERTAG, XFA.DIGESTMETHODSTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_DIGESTMETHODS, */ 0); // Added with CL315612 Jul 6, 2006
		putElement(XFA.FILTERTAG, XFA.LOCKDOCUMENTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_LOCKDOCUMENT, */ 0); 
		putElement(XFA.FILTERTAG, XFA.APPEARANCEFILTERTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_APPEARANCEFILTER, */ 0); 

		// mdp
		// Added with CL262678 Dec 20, 2005
		putPropAttrs(XFA.MDPTAG);
		putAttribute(XFA.MDPTAG, EnumValue.getEnum(XFA.SIGNATURETYPETAG, EnumAttr.getEnum(EnumAttr.MDPSIGNATURETYPE_FILLER)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_SIGNATURETYPE, */ 0); // Added with CL262678 Dec 20, 2005
		putAttribute(XFA.MDPTAG, EnumValue.getEnum(XFA.PERMISSIONSTAG, EnumAttr.getEnum(EnumAttr.MDPPERMISSIONS_TWO)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_PERMISSIONS, */ 0); // Added with CL262678 Dec 20, 2005

		// timeStamp
		// Added with CL262678 Dec 20, 2005
		putPropAttrs(XFA.TIMESTAMPTAG);
		putAttribute(XFA.TIMESTAMPTAG, EnumValue.getEnum(XFA.TYPETAG, EnumAttr.getEnum(EnumAttr.REQUIREMENT_OPTIONAL)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_TYPE, */ 0); // Added with CL262678 Dec 20, 2005
		putAttribute(XFA.TIMESTAMPTAG, XFA.SERVERTAG, null, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_SERVER, */ 0); // Added with CL262678 Dec 20, 2005

		// encodings
		// Added with CL315612 Jul 6, 2006
		putPropAttrs(XFA.ENCODINGSTAG);
		putAttribute(XFA.ENCODINGSTAG, EnumValue.getEnum(XFA.TYPETAG, EnumAttr.getEnum(EnumAttr.REQUIREMENT_OPTIONAL)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_TYPE, */ 0); // Added with CL315612 Jul 6, 2006
		putElement(XFA.ENCODINGSTAG, XFA.ENCODINGTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_ENCODING, */ 0); // Added with CL315612 Jul 6, 2006

		// encoding
		// Added with CL315612 Jul 6, 2006
		putPropAttrs(XFA.ENCODINGTAG);
		putElement(XFA.ENCODINGTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_TEXTNODE_ENCODING, */ 0); // Added with CL315612 Jul 6, 2006

		// digestMethods
		// Added with CL315612 Jul 6, 2006
		putPropAttrs(XFA.DIGESTMETHODSTAG);
		putAttribute(XFA.DIGESTMETHODSTAG, EnumValue.getEnum(XFA.TYPETAG, EnumAttr.getEnum(EnumAttr.REQUIREMENT_OPTIONAL)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_TYPE, */ 0); // Added with CL315612 Jul 6, 2006
		putElement(XFA.DIGESTMETHODSTAG, XFA.DIGESTMETHODTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_DIGESTMETHOD, */ 0); // Added with CL315612 Jul 6, 2006

		// digestMethod
		// Added with CL315612 Jul 6, 2006
		putPropAttrs(XFA.DIGESTMETHODTAG);
		putElement(XFA.DIGESTMETHODTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_TEXTNODE_DIGESTMETHOD, */ 0); // Added with CL315612 Jul 6, 2006

		// lockDocument
		putPropAttrs(XFA.LOCKDOCUMENTTAG);
		putAttribute(XFA.LOCKDOCUMENTTAG, EnumValue.getEnum(XFA.TYPETAG, EnumAttr.getEnum(EnumAttr.REQUIREMENT_OPTIONAL)), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_TYPE, */ 0); 
		putElement(XFA.LOCKDOCUMENTTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_28,  Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_TEXTNODE_LOCKDOCUMENT, */ 0); 

		// appearanceFilter
		putPropAttrs(XFA.APPEARANCEFILTERTAG);
		putAttribute(XFA.APPEARANCEFILTERTAG, EnumValue.getEnum(XFA.TYPETAG, EnumAttr.getEnum(EnumAttr.REQUIREMENT_OPTIONAL)), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_TYPE, */ 0); 
		putElement(XFA.APPEARANCEFILTERTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_TEXTNODE_APPEARANCEFILTER, */ 0); 

		// float
		// Added with CL77101 Dec 7, 2003
		putChildAttrs(XFA.FLOATTAG);
		putElement(XFA.FLOATTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTNODE_FLOAT, */ 0); // Added with CL77101 Dec 7, 2003

		// handler
		// Added with CL130260 May 20, 2004
		// Removed version attribute with CL326612 Aug 23, 2006
		putPropAttrs(XFA.HANDLERTAG);
		putAttribute(XFA.HANDLERTAG, EnumValue.getEnum(XFA.TYPETAG, EnumAttr.getEnum(EnumAttr.REQUIREMENT_OPTIONAL)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_TYPE_HANDLER, */ 0); // Added with CL130260 May 20, 2004
		putElement(XFA.HANDLERTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_TEXTNODE_HANLDER, */ 0); // Added with CL130260 May 20, 2004

		// integer
		// Added with CL77101 Dec 7, 2003
		putChildAttrs(XFA.INTEGERTAG);
		putElement(XFA.INTEGERTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTNODE_INTEGER, */ 0); // Added with CL77101 Dec 7, 2003

		// text
		// Added with CL77101 Dec 7, 2003
		putChildAttrs(XFA.TEXTTAG);
		putAttribute(XFA.TEXTTAG, XFA.MAXCHARSTAG, new Int(XFA.MAXCHARS, 0), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_MAXCHARS, */ 0); // Added with CL77101 Dec 7, 2003
		putAttribute(XFA.TEXTTAG, XFA.RIDTAG, null, Schema.XFAVERSION_27, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RID, */ 0); // Added June 2006
		putElement(XFA.TEXTTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTNODE_TEXT, */ 0); // Added with CL77101 Dec 7, 2003

		// time
		// Added with CL77101 Dec 7, 2003
		putChildAttrs(XFA.TIMETAG);
		putElement(XFA.TIMETAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTNODE_TIME, */ 0); // Added with CL77101 Dec 7, 2003

		// exData
		// Added with CL77101 Dec 7, 2003
		putChildAttrs(XFA.EXDATATAG);
		putAttribute(XFA.EXDATATAG, XFA.CONTENTTYPETAG, new StringAttr(XFA.CONTENTTYPE, STRS.TEXTPLAIN), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_CONTENTTYPE_EXDATA, */ 0); // Added with CL77101 Dec 7, 2003
		putAttribute(XFA.EXDATATAG, XFA.HREFTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_HREF, */ 0); // Added with CL77101 Dec 7, 2003
		putAttribute(XFA.EXDATATAG, XFA.MAXLENGTHTAG, new Int(XFA.MAXLENGTH, -1), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_MAXLENGTH, */ 0); // Added with CL77101 Dec 7, 2003
		putAttribute(XFA.EXDATATAG, EnumValue.getEnum(XFA.TRANSFERENCODINGTAG, EnumAttr.getEnum(EnumAttr.TRANSFER_NONE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TRANSFERENCODING, */ 0); // Added with CL77101 Dec 7, 2003
		putAttribute(XFA.EXDATATAG, XFA.RIDTAG, null, Schema.XFAVERSION_27, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RID, */ 0); // Added June 2006
		putElement(XFA.EXDATATAG, XFA.TEXTNODETAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTNODE_EXDATA, */ 0); // Added with CL77101 Dec 7, 2003
		putElement(XFA.EXDATATAG, XFA.RICHTEXTNODETAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTNODE_EXDATA, */ 0); // Added with CL77101 Dec 7, 2003
		putElement(XFA.EXDATATAG, XFA.XMLMULTISELECTNODETAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTNODE_EXDATA, */ 0); // Added with CL78087 Dec 13, 2003

		// desc
		putPropAttrs(XFA.DESCTAG);
		putElement(XFA.DESCTAG, XFA.BOOLEANTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BOOLEAN, */ 0);
		putElement(XFA.DESCTAG, XFA.DATETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DATE, */ 0);
		putElement(XFA.DESCTAG, XFA.DATETIMETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DATETIME, */ 0);
		putElement(XFA.DESCTAG, XFA.DECIMALTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DECIMAL, */ 0);
		putElement(XFA.DESCTAG, XFA.EXDATATAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXDATA, */ 0);
		putElement(XFA.DESCTAG, XFA.FLOATTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_FLOAT, */ 0);
		putElement(XFA.DESCTAG, XFA.IMAGETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_IMAGE, */ 0);
		putElement(XFA.DESCTAG, XFA.INTEGERTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_INTEGER, */ 0);
		putElement(XFA.DESCTAG, XFA.TEXTTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXT, */ 0);
		putElement(XFA.DESCTAG, XFA.TIMETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TIME, */ 0);

		// fill
		putPropAttrs(XFA.FILLTAG);
		putAttribute(XFA.FILLTAG, EnumValue.getEnum(XFA.PRESENCETAG, EnumAttr.getEnum(EnumAttr.PRESENCE_VISIBLE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_PRESENCE, */ 0);
		putElement(XFA.FILLTAG, XFA.COLORTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_COLOR, */ 0);
		putElement(XFA.FILLTAG, XFA.SOLIDTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_SOLID, */ 0);
		putElement(XFA.FILLTAG, XFA.PATTERNTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_PATTERN, */ 0);
		putElement(XFA.FILLTAG, XFA.LINEARTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_LINEAR, */ 0);
		putElement(XFA.FILLTAG, XFA.RADIALTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_RADIAL, */ 0);
		putElement(XFA.FILLTAG, XFA.STIPPLETAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_STIPPLE, */ 0);
		putElement(XFA.FILLTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// font
		putPropAttrs(XFA.FONTTAG);
		putAttribute(XFA.FONTTAG, EnumValue.getEnum(XFA.LINETHROUGHTAG, EnumAttr.getEnum(EnumAttr.LINETHROUGH_ZERO)), Schema.XFAVERSION_21,  Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF,  /* XFA_IS_ATTRDESC_LINETHROUGH, */ 0);
		putAttribute(XFA.FONTTAG, EnumValue.getEnum(XFA.LINETHROUGHPERIODTAG, EnumAttr.getEnum(EnumAttr.LINETHROUGH_ALL)), Schema.XFAVERSION_21,  Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF,  /* XFA_IS_ATTRDESC_LINETHROUGHPERIOD, */ 0);
		putAttribute(XFA.FONTTAG, XFA.TYPEFACETAG, new StringAttr(XFA.TYPEFACE, STRS.COURIERSTD), Schema.XFAVERSION_21,  Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF,  /* XFA_IS_ATTRDESC_TYPEFACE, */ 0);
		putAttribute(XFA.FONTTAG, XFA.SIZETAG, new Measurement(XFA.SIZE, STRS.TENPT), Schema.XFAVERSION_21,  Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF,  /* XFA_IS_ATTRDESC_SIZE_FONT, */ 0);
		putAttribute(XFA.FONTTAG, EnumValue.getEnum(XFA.WEIGHTTAG, EnumAttr.getEnum(EnumAttr.WEIGHT_NORMAL)), Schema.XFAVERSION_21,  Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF,  /* XFA_IS_ATTRDESC_WEIGHT, */ 0);
		putAttribute(XFA.FONTTAG, EnumValue.getEnum(XFA.POSTURETAG, EnumAttr.getEnum(EnumAttr.POSTURE_NORMAL)), Schema.XFAVERSION_21,  Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF,  /* XFA_IS_ATTRDESC_POSTURE, */ 0);
		putAttribute(XFA.FONTTAG, EnumValue.getEnum(XFA.UNDERLINETAG, EnumAttr.getEnum(EnumAttr.UNDER_ZERO)), Schema.XFAVERSION_21,  Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF,  /* XFA_IS_ATTRDESC_UNDERLINE, */ 0);
		putAttribute(XFA.FONTTAG, EnumValue.getEnum(XFA.UNDERLINEPERIODTAG, EnumAttr.getEnum(EnumAttr.UNDER_ALL)), Schema.XFAVERSION_21,  Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF,  /* XFA_IS_ATTRDESC_UNDERLINEPERIOD, */ 0);
		putAttribute(XFA.FONTTAG, EnumValue.getEnum(XFA.OVERLINETAG, EnumAttr.getEnum(EnumAttr.OVERLINE_ZERO)), Schema.XFAVERSION_21,  Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF,  /* XFA_IS_ATTRDESC_OVERLINE, */ 0);
		putAttribute(XFA.FONTTAG, EnumValue.getEnum(XFA.OVERLINEPERIODTAG, EnumAttr.getEnum(EnumAttr.OVER_ALL)), Schema.XFAVERSION_21,  Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF,  /* XFA_IS_ATTRDESC_OVERLINEPERIOD, */ 0);
		putAttribute(XFA.FONTTAG, XFA.BASELINESHIFTTAG, new Measurement(XFA.BASELINESHIFT, "0"), Schema.XFAVERSION_21,  Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF,  /* XFA_IS_ATTRDESC_BASELINESHIFT, */ 0);
		putAttribute(XFA.FONTTAG, XFA.FONTHORIZONTALSCALETAG, new StringAttr(XFA.FONTHORIZONTALSCALE, STRS.HUNDREDPERCENT), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_FONTHORIZONTALSCALE, */ 0); // Added with CL402419 June 2007
		putAttribute(XFA.FONTTAG, XFA.FONTVERTICALSCALETAG, new StringAttr(XFA.FONTVERTICALSCALE, STRS.HUNDREDPERCENT), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_FONTVERTICALSCALE, */ 0); // Added with CL402419 June 2007
		putAttribute(XFA.FONTTAG, XFA.LETTERSPACINGTAG, new StringAttr(XFA.LETTERSPACING, "0"), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_LETTERSPACING, */ 0); // Added with CL402419 June 2007
		putAttribute(XFA.FONTTAG, EnumValue.getEnum(XFA.KERNINGMODETAG, EnumAttr.getEnum(EnumAttr.KERNINGMODE_NONE)), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_KERNINGMODE, */ 0); // Added with CL402419 June 2007
		putElement(XFA.FONTTAG, XFA.FILLTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21,  Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF,  /* XFA_IS_CHILDDESC_FILL, */ 0);
		putElement(XFA.FONTTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21,  Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF,  /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		
		// format
		putPropAttrs(XFA.FORMATTAG);
		putElement(XFA.FORMATTAG, XFA.PICTURETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_PICTURE, */ 0);
		putElement(XFA.FORMATTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		
		// items
		// Removed arc, line and rectangle elements CL60121 Jul 7, 2003
		putChildAttrs(XFA.ITEMSTAG);
		putAttribute(XFA.ITEMSTAG, EnumValue.getEnum(XFA.PRESENCETAG, EnumAttr.getEnum(EnumAttr.PRESENCE_VISIBLE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_PRESENCE, */ 0); 
		putAttribute(XFA.ITEMSTAG, EnumValue.getEnum(XFA.SAVETAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_SAVE, */ 0);
		putAttribute(XFA.ITEMSTAG, XFA.REFTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_REF_ITEMS, */ 0); // Added with CL70412 Oct 17, 2003
		putElement(XFA.ITEMSTAG, XFA.BOOLEANTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BOOLEAN, */ 0);
		putElement(XFA.ITEMSTAG, XFA.DATETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DATE, */ 0);
		putElement(XFA.ITEMSTAG, XFA.DATETIMETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DATETIME, */ 0);
		putElement(XFA.ITEMSTAG, XFA.DECIMALTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DECIMAL, */ 0);
		putElement(XFA.ITEMSTAG, XFA.EXDATATAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXDATA, */ 0);
		putElement(XFA.ITEMSTAG, XFA.FLOATTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_FLOAT, */ 0);
		putElement(XFA.ITEMSTAG, XFA.IMAGETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_IMAGE, */ 0);
		putElement(XFA.ITEMSTAG, XFA.INTEGERTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_INTEGER, */ 0);
		putElement(XFA.ITEMSTAG, XFA.TEXTTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXT, */ 0);
		putElement(XFA.ITEMSTAG, XFA.TIMETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TIME, */ 0);

		// issuers
		// Added with CL130260 May 20, 2004
		putPropAttrs(XFA.ISSUERSTAG);
		putAttribute(XFA.ISSUERSTAG, EnumValue.getEnum(XFA.TYPETAG, EnumAttr.getEnum(EnumAttr.REQUIREMENT_OPTIONAL)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TYPE, */ 0); // Added with CL130260 May 20, 2004
		putElement(XFA.ISSUERSTAG, XFA.CERTIFICATETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_CERTIFICATE, */ 0); // Added with CL130260 May 20, 2004

		// keep
		// intactException, nextException, nextStrength, previousException, previousStrength removed with CL60140 Jul 7, 2003
		putPropAttrs(XFA.KEEPTAG);
		putAttribute(XFA.KEEPTAG, EnumValue.getEnum(XFA.INTACTTAG, EnumAttr.getEnum(EnumAttr.KEEP_NONE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_INTACT, */ 0); 
		putAttribute(XFA.KEEPTAG, EnumValue.getEnum(XFA.NEXTTAG, EnumAttr.getEnum(EnumAttr.KEEP_NONE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_NEXT, */ 0); 
		putAttribute(XFA.KEEPTAG, EnumValue.getEnum(XFA.PREVIOUSTAG, EnumAttr.getEnum(EnumAttr.KEEP_NONE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_PREVIOUS, */ 0);
		putElement(XFA.KEEPTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// margin
		putPropAttrs(XFA.MARGINTAG);
		putAttribute(XFA.MARGINTAG, XFA.TOPINSETTAG, new Measurement(XFA.TOPINSET, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TOPINSET, */ 0);
		putAttribute(XFA.MARGINTAG, XFA.LEFTINSETTAG, new Measurement(XFA.LEFTINSET, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_LEFTINSET, */ 0);
		putAttribute(XFA.MARGINTAG, XFA.BOTTOMINSETTAG, new Measurement(XFA.BOTTOMINSET, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_BOTTOMINSET, */ 0);
		putAttribute(XFA.MARGINTAG, XFA.RIGHTINSETTAG, new Measurement(XFA.RIGHTINSET, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RIGHTINSET, */ 0);
		putElement(XFA.MARGINTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// message
		// Removed boolean, date, datetime, decimal, float, integer and time elements CL60127 Jul 7, 2003
		// Removed exData, extras and image with CL81809 Jan 19, 2004
		putPropAttrs(XFA.MESSAGETAG);
		// 0...n - do not change! AC, Any child of message should be 0..n
		putElement(XFA.MESSAGETAG, XFA.TEXTTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXT, */ 0); 

		// imageEdit
		// Added with CL100875 Feb 5, 2004
		putPropAttrs(XFA.IMAGEEDITTAG);
		putAttribute(XFA.IMAGEEDITTAG, EnumValue.getEnum(XFA.DATATAG, EnumAttr.getEnum(EnumAttr.DATA_LINK)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_DATA, */ 0); // Added with CL100875 Feb 5, 2004
		putElement(XFA.IMAGEEDITTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0); // Added with CL100875 Feb 5, 2004	
		putElement(XFA.IMAGEEDITTAG, XFA.BORDERTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BORDER, */ 0); // Added with CL100875 Feb 5, 2004
		putElement(XFA.IMAGEEDITTAG, XFA.MARGINTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_MARGIN, */ 0); // Added with CL100875 Feb 5, 2004

		// numericEdit
		// Removed currencySign, decimalChar, digitGroupChar, digitinGroup,
		// positiveChar and showPositive attributes with CL60835 Jul 17, 2003
		putPropAttrs(XFA.NUMERICEDITTAG);
		putAttribute(XFA.NUMERICEDITTAG, EnumValue.getEnum(XFA.HSCROLLPOLICYTAG, EnumAttr.getEnum(EnumAttr.SCROLLPOLICY_AUTO)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_HSCROLLPOLICY, */ 0); // Added with CL271273 Jan 27, 2006
		putElement(XFA.NUMERICEDITTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		putElement(XFA.NUMERICEDITTAG, XFA.BORDERTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BORDER, */ 0); // Added with CL65290 Sep 8, 2003
		putElement(XFA.NUMERICEDITTAG, XFA.MARGINTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_MARGIN, */ 0); // Added with CL68513 Oct 3, 2003
		putElement(XFA.NUMERICEDITTAG, XFA.COMBTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_COMB, */ 0); // Added with CL288351 Apr 5, 2006

		// occur
		putPropAttrs(XFA.OCCURTAG);
		putAttribute(XFA.OCCURTAG, XFA.INITIALTAG, new Int(XFA.INITIAL, 1), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_INITIAL, */ 0);
		putAttribute(XFA.OCCURTAG, XFA.MINTAG, new Int(XFA.MAX, 1), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_MIN, */ 0);
		putAttribute(XFA.OCCURTAG, XFA.MAXTAG, new Int(XFA.MIN, 1), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_MAX, */ 0);
		putElement(XFA.OCCURTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		putElement(XFA.OCCURTAG, XFA.SCRIPTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_SCRIPT, */ 0);

		// passwordEdit
		putPropAttrs(XFA.PASSWORDEDITTAG);
		putAttribute(XFA.PASSWORDEDITTAG, XFA.PASSWORDCHARTAG, new StringAttr(XFA.PASSWORDCHAR, "*"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_PASSWORDCHAR, */ 0);
		putAttribute(XFA.PASSWORDEDITTAG, EnumValue.getEnum(XFA.HSCROLLPOLICYTAG, EnumAttr.getEnum(EnumAttr.SCROLLPOLICY_AUTO)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_HSCROLLPOLICY, */ 0); // Added with CL271273 Jan 27, 2006
		putElement(XFA.PASSWORDEDITTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		putElement(XFA.PASSWORDEDITTAG, XFA.BORDERTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BORDER, */ 0); // Added with CL65290 Sep 8, 2003
		putElement(XFA.PASSWORDEDITTAG, XFA.MARGINTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_MARGIN, */ 0); // Added with CL68513 Oct 3, 2003

		// textEdit
		putPropAttrs(XFA.TEXTEDITTAG);
		putAttribute(XFA.TEXTEDITTAG, EnumValue.getEnum(XFA.ALLOWRICHTEXTTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_ALLOWRICHTEXT, */ 0); // Added with CL74238 Nov 13, 2003
		putAttribute(XFA.TEXTEDITTAG, EnumValue.getEnum(XFA.MULTILINETAG, EnumAttr.getEnum(EnumAttr.BOOL_TRUE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_MULTILINE, */ 0);
		putAttribute(XFA.TEXTEDITTAG, EnumValue.getEnum(XFA.VSCROLLPOLICYTAG, EnumAttr.getEnum(EnumAttr.SCROLLPOLICY_AUTO)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_VSCROLLPOLICY, */ 0); // Added with CL271273 Jan 27, 2006
		putAttribute(XFA.TEXTEDITTAG, EnumValue.getEnum(XFA.HSCROLLPOLICYTAG, EnumAttr.getEnum(EnumAttr.SCROLLPOLICY_AUTO)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_HSCROLLPOLICY, */ 0); // Added with CL271273 Jan 27, 2006
		putElement(XFA.TEXTEDITTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		putElement(XFA.TEXTEDITTAG, XFA.BORDERTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BORDER, */ 0); // Added with CL65290 Sep 8, 2003
		putElement(XFA.TEXTEDITTAG, XFA.MARGINTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_MARGIN, */ 0); // Added with CL68513 Oct 3, 2003
		putElement(XFA.TEXTEDITTAG, XFA.COMBTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_COMB, */ 0); // Added with CL109301 Mar 3, 2004

		// ui
		putPropAttrs(XFA.UITAG);
		putElement(XFA.UITAG, XFA.BARCODETAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BARCODE, */ 0); // Added with CL59830 Jul 2, 2003
		putElement(XFA.UITAG, XFA.BUTTONTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BUTTON, */ 0);
		putElement(XFA.UITAG, XFA.CHECKBUTTONTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_CHECKBUTTON, */ 0);
		putElement(XFA.UITAG, XFA.CHOICELISTTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_CHOICELIST, */ 0);
		putElement(XFA.UITAG, XFA.DATETIMEEDITTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DATETIMEEDIT, */ 0);
		putElement(XFA.UITAG, XFA.DEFAULTUITAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DEFAULTUI, */ 0);
		putElement(XFA.UITAG, XFA.EXOBJECTTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXOBJECT, */ 0);
		putElement(XFA.UITAG, XFA.NUMERICEDITTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_NUMERICEDIT, */ 0);
		putElement(XFA.UITAG, XFA.IMAGEEDITTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_IMAGEEDIT, */ 0); // Added with CL100875 Feb 5, 2004
		putElement(XFA.UITAG, XFA.PASSWORDEDITTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_PASSWORDEDIT, */ 0);
		putElement(XFA.UITAG, XFA.PICTURETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_PICTURE, */ 0);
		putElement(XFA.UITAG, XFA.SIGNATURETAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_SIGNATURE, */ 0); // Added with CL62912 Aug 13, 2003
		putElement(XFA.UITAG, XFA.TEXTEDITTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTEDIT, */ 0);
		putElement(XFA.UITAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// image
		// Added with CL77101 Dec 7, 2003
		putChildAttrs(XFA.IMAGETAG);
		putAttribute(XFA.IMAGETAG, XFA.CONTENTTYPETAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_CONTENTTYPE_IMAGE, */ 0); // Added with CL77101 Dec 7, 2003
		putAttribute(XFA.IMAGETAG, XFA.HREFTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_HREF_IMAGE, */ 0); // Added with CL77101 Dec 7, 2003
		putAttribute(XFA.IMAGETAG, EnumValue.getEnum(XFA.TRANSFERENCODINGTAG, EnumAttr.getEnum(EnumAttr.TRANSFER_BASE64)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TRANSFERENCODING, */ 0); // Added with CL77101 Dec 7, 2003
		putAttribute(XFA.IMAGETAG, EnumValue.getEnum(XFA.ASPECTTAG, EnumAttr.getEnum(EnumAttr.ASPECT_FIT)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_ASPECT, */ 0); // Added with CL77101 Dec 7, 2003
		putElement(XFA.IMAGETAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTNODE_IMAGE, */ 0); // Added with CL77101 Dec 7, 2003

		// picture
		putPropAttrs(XFA.PICTURETAG);
		putElement(XFA.PICTURETAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTNODE_PICTURE, */ 0);

		// script
		putChildAttrs(XFA.SCRIPTTAG);
		putAttribute(XFA.SCRIPTTAG, XFA.CONTENTTYPETAG, new StringAttr(XFA.CONTENTTYPE, "application/x-formcalc"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_CONTENTTYPE_SCRIPT, */ 0);
		putAttribute(XFA.SCRIPTTAG, XFA.BINDINGTAG, new StringAttr(XFA.BINDING, "XFA"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_BINDING, */ 0); // Added with CL56350 May 28, 2003
		putAttribute(XFA.SCRIPTTAG, EnumValue.getEnum(XFA.RUNATTAG, EnumAttr.getEnum(EnumAttr.RUNAT_CLIENT)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RUNAT, */ 0); // Added with CL66570 Sep 18, 2003
		putAttribute(XFA.SCRIPTTAG, EnumValue.getEnum(XFA.STATELESSTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_STATELESS, */ 0);
		putElement(XFA.SCRIPTTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTNODE_SCRIPT, */ 0);

		// calculate
		// Removed type attribute with CL52288 Apr 25, 2003
		putPropAttrs(XFA.CALCULATETAG);
		putAttribute(XFA.CALCULATETAG, EnumValue.getEnum(XFA.OVERRIDETAG, EnumAttr.getEnum(EnumAttr.OVERRIDE_DISABLED)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_OVERRIDE_CALCULATE, */ 0);
		putElement(XFA.CALCULATETAG, XFA.SCRIPTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_SCRIPT, */ 0);
		putElement(XFA.CALCULATETAG, XFA.MESSAGETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_MESSAGE, */ 0); // Added with CL70955 Oct 22, 2003
		putElement(XFA.CALCULATETAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// validate
		putPropAttrs(XFA.VALIDATETAG);
		putAttribute(XFA.VALIDATETAG, EnumValue.getEnum(XFA.NULLTESTTAG, EnumAttr.getEnum(EnumAttr.TEST_DISABLED)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_nullTEST, */ 0);
		putAttribute(XFA.VALIDATETAG, EnumValue.getEnum(XFA.FORMATTESTTAG, EnumAttr.getEnum(EnumAttr.TEST_WARNING)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_FORMATTEST, */ 0);
		putAttribute(XFA.VALIDATETAG, EnumValue.getEnum(XFA.SCRIPTTESTTAG, EnumAttr.getEnum(EnumAttr.TEST_ERROR)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_SCRIPTTEST, */ 0);
		putAttribute(XFA.VALIDATETAG, EnumValue.getEnum(XFA.DISABLEALLTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_DISABLEALL, */ 0);
		putElement(XFA.VALIDATETAG, XFA.SCRIPTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_SCRIPT, */ 0);
		putElement(XFA.VALIDATETAG, XFA.MESSAGETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_MESSAGE, */ 0); // Subset
		putElement(XFA.VALIDATETAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		putElement(XFA.VALIDATETAG, XFA.PICTURETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_PICTURE, */ 0); // Added with CL77953 Dec 12, 2003

		// linear
		putPropAttrs(XFA.LINEARTAG);
		putAttribute(XFA.LINEARTAG, EnumValue.getEnum(XFA.TYPETAG, EnumAttr.getEnum(EnumAttr.TO_RIGHT)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TYPE_LINEAR, */ 0);
		putElement(XFA.LINEARTAG, XFA.COLORTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_COLOR, */ 0);
		putElement(XFA.LINEARTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// pattern
		putPropAttrs(XFA.PATTERNTAG);
		putAttribute(XFA.PATTERNTAG, EnumValue.getEnum(XFA.TYPETAG, EnumAttr.getEnum(EnumAttr.CROSS_HATCHING)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TYPE_PATTERN, */ 0);
		putElement(XFA.PATTERNTAG, XFA.COLORTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_COLOR, */ 0);
		putElement(XFA.PATTERNTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// radial
		putPropAttrs(XFA.RADIALTAG);
		putAttribute(XFA.RADIALTAG, EnumValue.getEnum(XFA.TYPETAG, EnumAttr.getEnum(EnumAttr.TO_EDGE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TYPE_RADIAL, */ 0);
		putElement(XFA.RADIALTAG, XFA.COLORTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_COLOR, */ 0);
		putElement(XFA.RADIALTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// corner
		// Changed thickness for edges and corners to .5pt CL60342 Jul 9, 2003
		putPropAttrs(XFA.CORNERTAG);
		putAttribute(XFA.CORNERTAG, EnumValue.getEnum(XFA.JOINTAG, EnumAttr.getEnum(EnumAttr.JOIN_SQUARE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_JOIN, */ 0);
		putAttribute(XFA.CORNERTAG, EnumValue.getEnum(XFA.PRESENCETAG, EnumAttr.getEnum(EnumAttr.PRESENCE_VISIBLE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_PRESENCE, */ 0);
		putAttribute(XFA.CORNERTAG, XFA.RADIUSTAG, new Measurement(XFA.RADIUS, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RADIUS, */ 0);
		putAttribute(XFA.CORNERTAG, EnumValue.getEnum(XFA.STROKETAG, EnumAttr.getEnum(EnumAttr.STROKE_SOLID)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_STROKE, */ 0);
		putAttribute(XFA.CORNERTAG, XFA.THICKNESSTAG, new Measurement(XFA.THICKNESS, "0.5pt"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_THICKNESS, */ 0);
		putAttribute(XFA.CORNERTAG, EnumValue.getEnum(XFA.INVERTEDTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_INVERTED, */ 0);
		putElement(XFA.CORNERTAG, XFA.COLORTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_COLOR, */ 0);
		putElement(XFA.CORNERTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// edge
		putPropAttrs(XFA.EDGETAG);
		putAttribute(XFA.EDGETAG, EnumValue.getEnum(XFA.PRESENCETAG, EnumAttr.getEnum(EnumAttr.PRESENCE_VISIBLE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_PRESENCE, */ 0);
		putAttribute(XFA.EDGETAG, EnumValue.getEnum(XFA.STROKETAG, EnumAttr.getEnum(EnumAttr.STROKE_SOLID)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_STROKE, */ 0);
		putAttribute(XFA.EDGETAG, XFA.THICKNESSTAG, new Measurement(XFA.THICKNESS, "0.5pt"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_THICKNESS, */ 0);
		putAttribute(XFA.EDGETAG, EnumValue.getEnum(XFA.CAPTAG, EnumAttr.getEnum(EnumAttr.SQUARE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_CAP, */ 0);
		putElement(XFA.EDGETAG, XFA.COLORTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_COLOR, */ 0);
		putElement(XFA.EDGETAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// boolean
		// Added with CL77101 Dec 7, 2003
		putChildAttrs(XFA.BOOLEANTAG);
		putElement(XFA.BOOLEANTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTNODE_BOOLEAN, */ 0); // Added with CL77101 Dec 7, 2003

		// extras
		// Removed the type attribute with CL59300 June 23, 2003
		putChildAttrs(XFA.EXTRASTAG);
		putElement(XFA.EXTRASTAG, XFA.BOOLEANTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BOOLEAN, */ 0);
		putElement(XFA.EXTRASTAG, XFA.DATETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DATE, */ 0);
		putElement(XFA.EXTRASTAG, XFA.DATETIMETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DATETIME, */ 0);
		putElement(XFA.EXTRASTAG, XFA.DECIMALTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DECIMAL, */ 0);
		putElement(XFA.EXTRASTAG, XFA.EXDATATAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXDATA, */ 0);
		putElement(XFA.EXTRASTAG, XFA.FLOATTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_FLOAT, */ 0);
		putElement(XFA.EXTRASTAG, XFA.IMAGETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_IMAGE, */ 0);
		putElement(XFA.EXTRASTAG, XFA.INTEGERTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_INTEGER, */ 0);
		putElement(XFA.EXTRASTAG, XFA.TEXTTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXT, */ 0);
		putElement(XFA.EXTRASTAG, XFA.TIMETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TIME, */ 0);
		putElement(XFA.EXTRASTAG, XFA.EXTRASTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// variables
		// Renamed docVar to variables CL62308 Aug 6, 2003
		// Removed id and use properties with CL64257 Aug 26, 2003
		putPropAttrs(XFA.VARIABLESTAG);
		putElement(XFA.VARIABLESTAG, XFA.BOOLEANTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BOOLEAN, */ 0); // Added with CL62308 Aug 6, 2003
		putElement(XFA.VARIABLESTAG, XFA.DATETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DATE, */ 0); // Added with CL62308 Aug 6, 2003
		putElement(XFA.VARIABLESTAG, XFA.DATETIMETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DATETIME, */ 0); // Added with CL62308 Aug 6, 2003
		putElement(XFA.VARIABLESTAG, XFA.DECIMALTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DECIMAL, */ 0); // Added with CL62308 Aug 6, 2003
		putElement(XFA.VARIABLESTAG, XFA.EXDATATAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXDATA, */ 0); // Added with CL62308 Aug 6, 2003
		putElement(XFA.VARIABLESTAG, XFA.FLOATTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_FLOAT, */ 0); // Added with CL62308 Aug 6, 2003
		putElement(XFA.VARIABLESTAG, XFA.IMAGETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_IMAGE, */ 0); // Added with CL62308 Aug 6, 2003
		putElement(XFA.VARIABLESTAG, XFA.INTEGERTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_INTEGER, */ 0); // Added with CL62308 Aug 6, 2003
		putElement(XFA.VARIABLESTAG, XFA.TEXTTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXT, */ 0); // Added with CL62308 Aug 6, 2003
		putElement(XFA.VARIABLESTAG, XFA.TIMETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TIME, */ 0); // Added with CL62308 Aug 6, 2003
		putElement(XFA.VARIABLESTAG, XFA.SCRIPTTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_SCRIPT, */ 0); // Added with CL64257 Aug 26, 2003
		putElement(XFA.VARIABLESTAG, XFA.MANIFESTTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_MANIFEST, */ 0); // Added with CL203825 May 27, 2005

		// stipple
		putPropAttrs(XFA.STIPPLETAG);
		putAttribute(XFA.STIPPLETAG, XFA.RATETAG, new Int(XFA.RATE, 50), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RATE, */ 0);
		putElement(XFA.STIPPLETAG, XFA.COLORTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_COLOR, */ 0);
		putElement(XFA.STIPPLETAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// arc
		putPropAttrs(XFA.ARCTAG);
		putAttribute(XFA.ARCTAG, EnumValue.getEnum(XFA.HANDTAG, EnumAttr.getEnum(EnumAttr.HAND_EVEN)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_HAND, */ 0);
		putAttribute(XFA.ARCTAG, EnumValue.getEnum(XFA.CIRCULARTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_CIRCULAR, */ 0);
		putAttribute(XFA.ARCTAG, XFA.STARTANGLETAG, new Rotate(XFA.STARTANGLE, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_STARTANGLE, */ 0); // CL45166 Feb 20, 2003
		putAttribute(XFA.ARCTAG, XFA.SWEEPANGLETAG, new Rotate(XFA.SWEEPANGLE, "360"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_SWEEPANGLE, */ 0); // CL45166 Feb 20, 2003
		putElement(XFA.ARCTAG, XFA.EDGETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EDGE_ARC, */ 0);
		putElement(XFA.ARCTAG, XFA.FILLTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_FILL_ARC, */ 0);

		// area
		// Removed proto element with CL60776 Jul 15, 2003.
		putChildAttrs(XFA.AREATAG);
		putAttribute(XFA.AREATAG, XFA.RELEVANTTAG, new StringAttr(XFA.RELEVANT, ""), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RELEVANT, */ 0); // Added with CL54894 May 16, 2003
		putAttribute(XFA.AREATAG, XFA.COLSPANTAG, new Int(XFA.COLSPAN, 1), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_COLSPAN, */ 0); // Added with CL59922 July 3, 2003
		putAttribute(XFA.AREATAG, XFA.XTAG, new Measurement(XFA.AREA, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_X, */ 0);
		putAttribute(XFA.AREATAG, XFA.YTAG, new Measurement(XFA.AREA, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_Y, */ 0);
		putElement(XFA.AREATAG, XFA.DESCTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DESC, */ 0);
		putElement(XFA.AREATAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		putElement(XFA.AREATAG, XFA.AREATAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_AREA, */ 0);
		putElement(XFA.AREATAG, XFA.DRAWTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DRAW, */ 0);
		putElement(XFA.AREATAG, XFA.EXCLGROUPTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXCLGROUP, */ 0);
		putElement(XFA.AREATAG, XFA.EXOBJECTTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXOBJECT, */ 0);
		putElement(XFA.AREATAG, XFA.FIELDTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_FIELD, */ 0); // Subset
		putElement(XFA.AREATAG, XFA.SUBFORMTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_SUBFORM, */ 0); // Subset
		putElement(XFA.AREATAG, XFA.SUBFORMSETTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_SUBFORMSET, */ 0);

		// border
		putPropAttrs(XFA.BORDERTAG);
		putAttribute(XFA.BORDERTAG, EnumValue.getEnum(XFA.BREAKTAG, EnumAttr.getEnum(EnumAttr.BORDER_CLOSED)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BREAK, */ 0); // Added with CL63173 Aug 18, 2003
		putAttribute(XFA.BORDERTAG, EnumValue.getEnum(XFA.PRESENCETAG, EnumAttr.getEnum(EnumAttr.PRESENCE_VISIBLE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_PRESENCE, */ 0);
		putAttribute(XFA.BORDERTAG, EnumValue.getEnum(XFA.HANDTAG, EnumAttr.getEnum(EnumAttr.HAND_EVEN)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_HAND, */ 0);
		putAttribute(XFA.BORDERTAG, XFA.RELEVANTTAG, new StringAttr(XFA.RELEVANT, ""), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RELEVANT, */ 0); // Added with CL54894 May 16, 2003
		putElement(XFA.BORDERTAG, XFA.MARGINTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_MARGIN, */ 0);
		putElement(XFA.BORDERTAG, XFA.EDGETAG, moZeroOrMore4, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EDGE, */ 0);
		putElement(XFA.BORDERTAG, XFA.CORNERTAG, moZeroOrMore4, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_CORNER, */ 0);
		putElement(XFA.BORDERTAG, XFA.FILLTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_FILL, */ 0);
		putElement(XFA.BORDERTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// caption
		putPropAttrs(XFA.CAPTIONTAG);
		putAttribute(XFA.CAPTIONTAG, EnumValue.getEnum(XFA.PRESENCETAG, EnumAttr.getEnum(EnumAttr.PRESENCE_VISIBLE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_PRESENCE, */ 0);
		putAttribute(XFA.CAPTIONTAG, EnumValue.getEnum(XFA.PLACEMENTTAG, EnumAttr.getEnum(EnumAttr.PLACEMENT_LEFT)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_PLACEMENT, */ 0);
		putAttribute(XFA.CAPTIONTAG, XFA.RESERVETAG, new Measurement(XFA.RESERVE, "-1"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RESERVE, */ 0);
		putElement(XFA.CAPTIONTAG, XFA.PARATAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_PARA, */ 0);
		putElement(XFA.CAPTIONTAG, XFA.FONTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_FONT, */ 0);
		putElement(XFA.CAPTIONTAG, XFA.VALUETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_VALUE, */ 0);
		putElement(XFA.CAPTIONTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		putElement(XFA.CAPTIONTAG, XFA.MARGINTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_MARGIN, */ 0); // Added with CL78568 Dec 16, 2003

		// checkButton
		putPropAttrs(XFA.CHECKBUTTONTAG);
		putAttribute(XFA.CHECKBUTTONTAG, EnumValue.getEnum(XFA.SHAPETAG, EnumAttr.getEnum(EnumAttr.SHAPE_SQUARE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_SHAPE, */ 0);
		putAttribute(XFA.CHECKBUTTONTAG, XFA.SIZETAG, new Measurement(XFA.SIZE, STRS.TENPT), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_SIZE_CHECKBUTTON, */ 0);
		putAttribute(XFA.CHECKBUTTONTAG, EnumValue.getEnum(XFA.ALLOWNEUTRALTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_ALLOWNEUTRAL, */ 0);
		putAttribute(XFA.CHECKBUTTONTAG, EnumValue.getEnum(XFA.MARKTAG, EnumAttr.getEnum(EnumAttr.MARK_DEFAULT)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_MARK, */ 0); // Added with CL290364 Apr 12, 2006
		putElement(XFA.CHECKBUTTONTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		putElement(XFA.CHECKBUTTONTAG, XFA.BORDERTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BORDER, */ 0);
		putElement(XFA.CHECKBUTTONTAG, XFA.MARGINTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_MARGIN, */ 0); // Added with CL68513 Oct 3, 2003

		// comb
		// Added with CL109301 Mar 3, 2004
		putPropAttrs(XFA.COMBTAG);
		putAttribute(XFA.COMBTAG, XFA.NUMBEROFCELLSTAG, new Int(XFA.NUMBEROFCELLS, 0), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_NUMBEROFCELLS, */ 0); // Added with CL288351 Apr 5, 2006

		// contentArea
		putChildAttrs(XFA.CONTENTAREATAG);
		putAttribute(XFA.CONTENTAREATAG, XFA.RELEVANTTAG, new StringAttr(XFA.RELEVANT, ""), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RELEVANT, */ 0); // Added with CL54894 May 16, 2003
		putAttribute(XFA.CONTENTAREATAG, XFA.HTAG, new Measurement(XFA.H, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_H, */ 0);
		putAttribute(XFA.CONTENTAREATAG, XFA.WTAG, new Measurement(XFA.W, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_W, */ 0);
		putAttribute(XFA.CONTENTAREATAG, XFA.XTAG, new Measurement(XFA.X, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_X, */ 0);
		putAttribute(XFA.CONTENTAREATAG, XFA.YTAG, new Measurement(XFA.Y, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_Y, */ 0);
		putElement(XFA.CONTENTAREATAG, XFA.DESCTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DESC, */ 0);
		putElement(XFA.CONTENTAREATAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// draw
		// Removed layout attribute with CL49434 April 2, 2003
		// Removed proto element with CL60776 Jul 15, 2003.
		// Added language attribute with CL65253 Sep 8, 2003
		// Removed language attribute with CL65294 Sept 8, 2003
		putChildAttrs(XFA.DRAWTAG);
		putAttribute(XFA.DRAWTAG, XFA.LOCALETAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_LOCALE_DRAW, */ 0); // Added with CL178618 Feb 22, 2005
		putAttribute(XFA.DRAWTAG, EnumValue.getEnum(XFA.ANCHORTYPETAG, EnumAttr.getEnum(EnumAttr.TOP_LEFT)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_ANCHORTYPE, */ 0);
		putAttribute(XFA.DRAWTAG, XFA.COLSPANTAG, new Int(XFA.COLSPAN, 1), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_COLSPAN, */ 0); // Added with CL59922 July 3, 2003
		putAttribute(XFA.DRAWTAG, XFA.XTAG, new Measurement(XFA.X, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_X, */ 0);
		putAttribute(XFA.DRAWTAG, XFA.YTAG, new Measurement(XFA.Y, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_Y, */ 0);
		putAttribute(XFA.DRAWTAG, XFA.HTAG, new Measurement(XFA.H, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_H, */ 0);
		putAttribute(XFA.DRAWTAG, XFA.WTAG, new Measurement(XFA.W, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_W, */ 0);
		putAttribute(XFA.DRAWTAG, EnumValue.getEnum(XFA.HALIGNTAG, EnumAttr.getEnum(EnumAttr.HALIGN_LEFT)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_HALIGN, */ 0);
		putAttribute(XFA.DRAWTAG, EnumValue.getEnum(XFA.VALIGNTAG, EnumAttr.getEnum(EnumAttr.VALIGN_TOP)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_VALIGN, */ 0);
		putAttribute(XFA.DRAWTAG, XFA.MAXHTAG, new Measurement(XFA.MAXH, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_MAXH, */ 0);
		putAttribute(XFA.DRAWTAG, XFA.MAXWTAG, new Measurement(XFA.MAXW, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_MAXW, */ 0);
		putAttribute(XFA.DRAWTAG, XFA.MINHTAG, new Measurement(XFA.MINH, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_MINH, */ 0);
		putAttribute(XFA.DRAWTAG, XFA.MINWTAG, new Measurement(XFA.MINW, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_MINW, */ 0); // Added with CL38709 Aug 13, 2002
		putAttribute(XFA.DRAWTAG, EnumValue.getEnum(XFA.PRESENCETAG, EnumAttr.getEnum(EnumAttr.PRESENCE_VISIBLE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_PRESENCE, */ 0);
		putAttribute(XFA.DRAWTAG, XFA.ROTATETAG, new Rotate(XFA.ROTATE, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_ROTATE, */ 0);
		putAttribute(XFA.DRAWTAG, XFA.RELEVANTTAG, new StringAttr(XFA.RELEVANT, ""), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RELEVANT, */ 0); // Added with CL54894 May 16, 2003
		putElement(XFA.DRAWTAG, XFA.ASSISTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_ASSIST, */ 0); // Added with CL38709 Aug 13, 2002
		putElement(XFA.DRAWTAG, XFA.BORDERTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_BORDER, */ 0);
		putElement(XFA.DRAWTAG, XFA.CAPTIONTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_CAPTION, */ 0);
		putElement(XFA.DRAWTAG, XFA.DESCTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DESC, */ 0);
		putElement(XFA.DRAWTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		putElement(XFA.DRAWTAG, XFA.FONTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_FONT, */ 0);
		putElement(XFA.DRAWTAG, XFA.KEEPTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_KEEP, */ 0);
		putElement(XFA.DRAWTAG, XFA.MARGINTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_MARGIN, */ 0);
		putElement(XFA.DRAWTAG, XFA.PARATAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_PARA, */ 0);
		putElement(XFA.DRAWTAG, XFA.RENDERASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_26, Schema.XFAAVAILABILITY_XFADESIGNER, /* XFA_IS_CHILDDESC_RENDERAS, */ 0); // Added with CL328070 Aug 29, 2006 SVG text runs.
		putElement(XFA.DRAWTAG, XFA.SETPROPERTYTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_SETPROPERTY, */ 0); // Added with CL204625 May 31, 2005
		putElement(XFA.DRAWTAG, XFA.TRAVERSALTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TRAVERSAL, */ 0); // Added with CL38709 Aug 13, 2002
		putElement(XFA.DRAWTAG, XFA.UITAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_UI, */ 0);
		putElement(XFA.DRAWTAG, XFA.VALUETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_VALUE, */ 0);

		// event
		// Added exportImport element with CL62301 Aug 6, 2003
		// Added encrypt element with CL279714 Mar 3, 2006
		// Removed encrypt element with CL290595 Apr 12, 2006
		putChildAttrs(XFA.EVENTTAG);
		putAttribute(XFA.EVENTTAG, EnumValue.getEnum(XFA.ACTIVITYTAG, EnumAttr.getEnum(EnumAttr.ACTIVITY_CLICK)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_ACTIVITY, */ 0);
		putAttribute(XFA.EVENTTAG, XFA.REFTAG, new StringAttr(XFA.REF, "$"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_REF_EVENT, */ 0); // Added with CL60417 Jul 10, 2003
		putElement(XFA.EVENTTAG, XFA.SCRIPTTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_SCRIPT, */ 0);
		putElement(XFA.EVENTTAG, XFA.SUBMITTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_SUBMIT, */ 0);
		putElement(XFA.EVENTTAG, XFA.EXECUTETAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXECUTE, */ 0); // Added with CL74309 Nov 13, 2003
		putElement(XFA.EVENTTAG, XFA.SIGNDATATAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_SIGNDATA, */ 0); // Added with CL130260 May 20, 2004
		putElement(XFA.EVENTTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		putAttribute(XFA.EVENTTAG, XFA.LISTENTAG, EnumValue.getEnum(XFA.LISTENTAG, EnumAttr.getEnum(EnumAttr.EVENTLISTEN_REFONLY)), Schema.XFAVERSION_30, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_LISTEN */ 0);

		// exObject
		putChildAttrs(XFA.EXOBJECTTAG);
		putAttribute(XFA.EXOBJECTTAG, XFA.ARCHIVETAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_ARCHIVE, */ 0);
		putAttribute(XFA.EXOBJECTTAG, XFA.CLASSIDTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_CLASSID, */ 0);
		putAttribute(XFA.EXOBJECTTAG, XFA.CODEBASETAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_CODEBASE, */ 0);
		putAttribute(XFA.EXOBJECTTAG, XFA.CODETYPETAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_CODETYPE, */ 0);
		putElement(XFA.EXOBJECTTAG, XFA.BOOLEANTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BOOLEAN, */ 0);
		putElement(XFA.EXOBJECTTAG, XFA.DATETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DATE, */ 0);
		putElement(XFA.EXOBJECTTAG, XFA.DATETIMETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DATETIME, */ 0);
		putElement(XFA.EXOBJECTTAG, XFA.DECIMALTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DECIMAL, */ 0);
		putElement(XFA.EXOBJECTTAG, XFA.EXDATATAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXDATA, */ 0);
		putElement(XFA.EXOBJECTTAG, XFA.EXOBJECTTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXOBJECT, */ 0);
		putElement(XFA.EXOBJECTTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		putElement(XFA.EXOBJECTTAG, XFA.FLOATTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_FLOAT, */ 0);
		putElement(XFA.EXOBJECTTAG, XFA.IMAGETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_IMAGE, */ 0);
		putElement(XFA.EXOBJECTTAG, XFA.INTEGERTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_INTEGER, */ 0);
		putElement(XFA.EXOBJECTTAG, XFA.TEXTTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXT, */ 0);
		putElement(XFA.EXOBJECTTAG, XFA.TIMETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TIME, */ 0);

		// exclGroup
		// Removed area with CL59933 July 3, 2003
		// Removed draw with CL59933 July 3, 2003
		// Removed exclGroup with CL59933 July 3, 2003
		// Removed proto with CL59933 July 3, 2003
		// Removed subform with CL59933 July 3, 2003
		putChildAttrs(XFA.EXCLGROUPTAG);
		putAttribute(XFA.EXCLGROUPTAG, XFA.ACCESSKEYTAG, null, Schema.XFAVERSION_22, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_ACCESSKEY, */ 0); // Added with CL144865 Aug 19, 2004
		putAttribute(XFA.EXCLGROUPTAG, EnumValue.getEnum(XFA.ACCESSTAG, EnumAttr.getEnum(EnumAttr.ACCESS_OPEN)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_ACCESS, */ 0);
		putAttribute(XFA.EXCLGROUPTAG, EnumValue.getEnum(XFA.ANCHORTYPETAG, EnumAttr.getEnum(EnumAttr.TOP_LEFT)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_ANCHORTYPE, */ 0); // Added with CL70786 Oct 21, 2003
		putAttribute(XFA.EXCLGROUPTAG, XFA.COLSPANTAG, new Int(XFA.COLSPAN, 1), Schema.XFAVERSION_22, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_COLSPAN, */ 0); // Added with CL103633 Feb 17, 2004
		putAttribute(XFA.EXCLGROUPTAG, XFA.HTAG, new Measurement(XFA.H, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_H, */ 0); // Added with CL70786 Oct 21, 2003
		putAttribute(XFA.EXCLGROUPTAG, EnumValue.getEnum(XFA.HALIGNTAG, EnumAttr.getEnum(EnumAttr.HALIGN_LEFT)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_HALIGN, */ 0); // Added with CL70786 Oct 21, 2003
		putAttribute(XFA.EXCLGROUPTAG, EnumValue.getEnum(XFA.LAYOUTTAG, EnumAttr.getEnum(EnumAttr.POSITION)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_LAYOUT, */ 0); // Added with CL70786 Oct 21, 2003
		putAttribute(XFA.EXCLGROUPTAG, XFA.MAXHTAG, new Measurement(XFA.MAXH, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_MAXH, */ 0); // Added with CL70786 Oct 21, 2003
		putAttribute(XFA.EXCLGROUPTAG, XFA.MAXWTAG, new Measurement(XFA.MAXW, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_MAXW, */ 0); // Added with CL70786 Oct 21, 2003v
		putAttribute(XFA.EXCLGROUPTAG, XFA.MINHTAG, new Measurement(XFA.MINH, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_MINH, */ 0); // Added with CL70786 Oct 21, 2003
		putAttribute(XFA.EXCLGROUPTAG, XFA.MINWTAG, new Measurement(XFA.MINW, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_MINW, */ 0); // Added with CL70786 Oct 21, 2003vv
		putAttribute(XFA.EXCLGROUPTAG, EnumValue.getEnum(XFA.PRESENCETAG, EnumAttr.getEnum(EnumAttr.PRESENCE_VISIBLE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_PRESENCE, */ 0);
		putAttribute(XFA.EXCLGROUPTAG, XFA.RELEVANTTAG, new StringAttr(XFA.RELEVANT, ""), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RELEVANT, */ 0); // Added with CL54894 May 16, 2003
		putAttribute(XFA.EXCLGROUPTAG, EnumValue.getEnum(XFA.TRANSIENTTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TRANSIENT, */ 0);
		putAttribute(XFA.EXCLGROUPTAG, EnumValue.getEnum(XFA.VALIGNTAG, EnumAttr.getEnum(EnumAttr.VALIGN_TOP)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_VALIGN, */ 0); // Added with CL70786 Oct 21, 2003
		putAttribute(XFA.EXCLGROUPTAG, XFA.WTAG, new Measurement(XFA.W, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_W, */ 0); // Added with CL70786 Oct 21, 2003
		putAttribute(XFA.EXCLGROUPTAG, XFA.XTAG, new Measurement(XFA.X, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_X, */ 0); // Added with CL70786 Oct 21, 2003
		putAttribute(XFA.EXCLGROUPTAG, XFA.YTAG, new Measurement(XFA.Y, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_Y, */ 0); // Added with CL70786 Oct 21, 2003
		putElement(XFA.EXCLGROUPTAG, XFA.ASSISTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_ASSIST, */ 0); // Added with CL70786 Oct 21, 2003
		putElement(XFA.EXCLGROUPTAG, XFA.BINDTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BIND, */ 0); // Added with CL57442 Jun 6, 2003
		putElement(XFA.EXCLGROUPTAG, XFA.BORDERTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BORDER, */ 0); // Added with CL70786 Oct 21, 2003
		putElement(XFA.EXCLGROUPTAG, XFA.CALCULATETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_CALCULATE, */ 0); // Added with CL70786 Oct 21, 2003
		putElement(XFA.EXCLGROUPTAG, XFA.CAPTIONTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_CAPTION, */ 0); // Added with CL70786 Oct 21, 2003
		putElement(XFA.EXCLGROUPTAG, XFA.CONNECTTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_CONNECT, */ 0); // Added with CL74659 Nov 17, 2003
		putElement(XFA.EXCLGROUPTAG, XFA.DESCTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DESC, */ 0);
		putElement(XFA.EXCLGROUPTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		putElement(XFA.EXCLGROUPTAG, XFA.MARGINTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_MARGIN, */ 0); // Added with CL70786 Oct 21, 2003
		putElement(XFA.EXCLGROUPTAG, XFA.PARATAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_PARA, */ 0); // Added with CL70786 Oct 21, 2003
		putElement(XFA.EXCLGROUPTAG, XFA.SETPROPERTYTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_SETPROPERTY, */ 0); // Added with CL181307 Mar 4, 2005
		putElement(XFA.EXCLGROUPTAG, XFA.TRAVERSALTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TRAVERSAL, */ 0);
		putElement(XFA.EXCLGROUPTAG, XFA.VALIDATETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_VALIDATE, */ 0);
		putElement(XFA.EXCLGROUPTAG, XFA.EVENTTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EVENT, */ 0); // Added with CL70786 Oct 21, 2003
		putElement(XFA.EXCLGROUPTAG, XFA.FIELDTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_FIELD, */ 0); // Subset

		// execute
		// Added with CL74309 Nov 13, 2003
		putPropAttrs(XFA.EXECUTETAG);
		putAttribute(XFA.EXECUTETAG, XFA.CONNECTIONTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_CONNECTION, */ 0); // Added with CL74309 Nov 13, 2003
		putAttribute(XFA.EXECUTETAG, EnumValue.getEnum(XFA.RUNATTAG, EnumAttr.getEnum(EnumAttr.RUNAT_CLIENT)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RUNAT, */ 0); // Added with CL74309 Nov 13, 2003
		putAttribute(XFA.EXECUTETAG, EnumValue.getEnum(XFA.EXECUTETYPETAG, EnumAttr.getEnum(EnumAttr.EXECUTETYPE_IMPORT)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_EXECUTETYPE, */ 0); // Added with CL78835 Dec 18, 2003

		// field
		// Removed layout attribute with CL49434 April 2, 2003
		// Removed proto element with CL60776 Jul 15, 2003.
		// Removed signature element with CL62912 Aug 13, 2003
		// Added language attribute with CL65253 Sep 8, 2003
		putChildAttrs(XFA.FIELDTAG);
		putAttribute(XFA.FIELDTAG, XFA.LOCALETAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_LOCALE, */ 0); // Added with CL67841 Sep 30, 2003
		putAttribute(XFA.FIELDTAG, XFA.ACCESSKEYTAG, null, Schema.XFAVERSION_22, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_ACCESSKEY, */ 0); // Added with CL144865 Aug 19, 2004
		putAttribute(XFA.FIELDTAG, EnumValue.getEnum(XFA.ACCESSTAG, EnumAttr.getEnum(EnumAttr.ACCESS_OPEN)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_ACCESS, */ 0); // Subset
		putAttribute(XFA.FIELDTAG, EnumValue.getEnum(XFA.ANCHORTYPETAG, EnumAttr.getEnum(EnumAttr.TOP_LEFT)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_ANCHORTYPE, */ 0);
		putAttribute(XFA.FIELDTAG, XFA.COLSPANTAG, new Int(XFA.COLSPAN, 1), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_COLSPAN, */ 0); // Added with CL59922 July 3, 2003
		putAttribute(XFA.FIELDTAG, XFA.XTAG, new Measurement(XFA.X, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_X, */ 0); // Subset
		putAttribute(XFA.FIELDTAG, XFA.YTAG, new Measurement(XFA.Y, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_Y, */ 0); // Subset
		putAttribute(XFA.FIELDTAG, XFA.HTAG, new Measurement(XFA.H, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_H, */ 0); // Subset
		putAttribute(XFA.FIELDTAG, XFA.WTAG, new Measurement(XFA.W, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_W, */ 0); // Subset
		putAttribute(XFA.FIELDTAG, EnumValue.getEnum(XFA.HALIGNTAG, EnumAttr.getEnum(EnumAttr.HALIGN_LEFT)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_HALIGN, */ 0);
		putAttribute(XFA.FIELDTAG, EnumValue.getEnum(XFA.VALIGNTAG, EnumAttr.getEnum(EnumAttr.VALIGN_TOP)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_VALIGN, */ 0);
		putAttribute(XFA.FIELDTAG, XFA.MAXHTAG, new Measurement(XFA.MAXH, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_MAXH, */ 0);
		putAttribute(XFA.FIELDTAG, XFA.MAXWTAG, new Measurement(XFA.MAXW, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_MAXW, */ 0);
		putAttribute(XFA.FIELDTAG, XFA.MINHTAG, new Measurement(XFA.MINH, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_MINH, */ 0);
		putAttribute(XFA.FIELDTAG, XFA.MINWTAG, new Measurement(XFA.MINW, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_MINW, */ 0);
		putAttribute(XFA.FIELDTAG, EnumValue.getEnum(XFA.PRESENCETAG, EnumAttr.getEnum(EnumAttr.PRESENCE_VISIBLE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_PRESENCE, */ 0); // Subset
		putAttribute(XFA.FIELDTAG, XFA.RELEVANTTAG, new StringAttr(XFA.RELEVANT, ""), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RELEVANT, */ 0); // Added with CL54894 May 16, 2003
		putAttribute(XFA.FIELDTAG, XFA.ROTATETAG, new Rotate(XFA.ROTATE, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_ROTATE, */ 0);
		putElement(XFA.FIELDTAG, XFA.ASSISTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_ASSIST, */ 0); // Added with CL38709 Aug 13, 2002
		putElement(XFA.FIELDTAG, XFA.BINDTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BIND, */ 0); // Added with CL74309 Nov 13, 2003
		putElement(XFA.FIELDTAG, XFA.BINDITEMSTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BINDITEMS, */ 0); // Added with CL181307 Mar 4, 2005
		putElement(XFA.FIELDTAG, XFA.BORDERTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET, /* XFA_IS_CHILDDESC_BORDER, */ 0); // Subset
		putElement(XFA.FIELDTAG, XFA.CALCULATETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_CALCULATE, */ 0); // Subset
		putElement(XFA.FIELDTAG, XFA.CAPTIONTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_CAPTION, */ 0);
		putElement(XFA.FIELDTAG, XFA.CONNECTTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_CONNECT, */ 0); // Added with CL74659 Nov 17, 2003
		putElement(XFA.FIELDTAG, XFA.DESCTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DESC, */ 0);
		putElement(XFA.FIELDTAG, XFA.EVENTTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EVENT, */ 0); // Subset
		putElement(XFA.FIELDTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		putElement(XFA.FIELDTAG, XFA.FONTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_FONT, */ 0); // Subset
		putElement(XFA.FIELDTAG, XFA.FORMATTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_FORMAT, */ 0);
		putElement(XFA.FIELDTAG, XFA.ITEMSTAG, moZeroOrMore2, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_ITEMS, */ 0); // Subset
		putElement(XFA.FIELDTAG, XFA.KEEPTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_KEEP, */ 0);
		putElement(XFA.FIELDTAG, XFA.MARGINTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_MARGIN, */ 0);
		putElement(XFA.FIELDTAG, XFA.PARATAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_PARA, */ 0);
		putElement(XFA.FIELDTAG, XFA.SETPROPERTYTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_SETPROPERTY, */ 0); // Added with CL181307 Mar 4, 2005
		putElement(XFA.FIELDTAG, XFA.TRAVERSALTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TRAVERSAL, */ 0);
		putElement(XFA.FIELDTAG, XFA.UITAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_UI, */ 0);
		putElement(XFA.FIELDTAG, XFA.VALIDATETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_VALIDATE, */ 0); // Subset
		putElement(XFA.FIELDTAG, XFA.VALUETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_VALUE, */ 0); // Subset
		putElement(XFA.FIELDTAG, XFA.RENDERASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_26, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_RENDERAS, */ 0); // Added with CL328070 Aug 29, 2006

		// hyphenation
		putPropAttrs(XFA.HYPHENATIONTAG);
		putAttribute(XFA.HYPHENATIONTAG, EnumValue.getEnum(XFA.HYPHENATETAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_HYPHENATE, */ 0);
		putAttribute(XFA.HYPHENATIONTAG, XFA.WORDCHARACTERCOUNTTAG, new Int(XFA.WORDCHARACTERCOUNT, 7), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_WORDCHARACTERCOUNT, */ 0); 
		putAttribute(XFA.HYPHENATIONTAG, XFA.REMAINCHARACTERCOUNTTAG, new Int(XFA.REMAINCHARACTERCOUNT, 3), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_REMAINCHARACTERCOUNT, */ 0); 
		putAttribute(XFA.HYPHENATIONTAG, XFA.PUSHCHARACTERCOUNTTAG, new Int(XFA.PUSHCHARACTERCOUNT, 3), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_PUSHCHARACTERCOUNT, */ 0); 
		putAttribute(XFA.HYPHENATIONTAG, XFA.LADDERCOUNTTAG, new Int(XFA.LADDERCOUNT, 2), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_LADDERCOUNT, */ 0); 
		putAttribute(XFA.HYPHENATIONTAG, EnumValue.getEnum(XFA.EXCLUDEALLCAPSTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_EXCLUDEALLCAPS, */ 0);
		putAttribute(XFA.HYPHENATIONTAG, EnumValue.getEnum(XFA.EXCLUDEINITIALCAPTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_EXCLUDEINITIALCAP, */ 0);

		// line
		putPropAttrs(XFA.LINETAG);
		putAttribute(XFA.LINETAG, EnumValue.getEnum(XFA.HANDTAG, EnumAttr.getEnum(EnumAttr.HAND_EVEN)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_HAND, */ 0);
		putAttribute(XFA.LINETAG, EnumValue.getEnum(XFA.SLOPETAG, EnumAttr.getEnum(EnumAttr.SLOPE_NEGATIVE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_SLOPE, */ 0);
		putElement(XFA.LINETAG, XFA.EDGETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EDGE, */ 0);

		// manifest
		// Removed link element CL60005 Jul 4, 2003
		// Removed manifest CL62912 Aug 13, 2003
		// Added manifest with CL107961 Feb 27, 2004
		putPropAttrs(XFA.MANIFESTTAG);
		putAttribute(XFA.MANIFESTTAG, XFA.NAMETAG, new StringAttr(XFA.NAME, ""), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_NAME, */ 0); // Added with CL203825 May 27, 2005
		putAttribute(XFA.MANIFESTTAG, EnumValue.getEnum(XFA.ACTIONTAG, EnumAttr.getEnum(EnumAttr.MANIFESTACTION_INCLUDE)), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* 0, */ 0); // Added with CL262678 Dec 20, 2005
		putElement(XFA.MANIFESTTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0); // Added with CL203825 May 27, 2005
		putElement(XFA.MANIFESTTAG, XFA.REFTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* 0, */ 0); // Added with CL107961 Feb 27, 2004

		// medium
		// Also found in XDC schema
		// Added with CL77101 Dec 7, 2003
		putPropAttrs(XFA.MEDIUMTAG);
		putAttribute(XFA.MEDIUMTAG, XFA.IMAGINGBBOXTAG, new ImagingBBoxEnum(XFA.IMAGINGBBOX, STRS.NONE), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_IMAGINGBBOX, */ 0); // Added with CL77101 Dec 7, 2003
		putAttribute(XFA.MEDIUMTAG, XFA.LONGTAG, new Measurement(XFA.LONG, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_LONG, */ 0); // Added with CL77101 Dec 7, 2003
		putAttribute(XFA.MEDIUMTAG, XFA.SHORTTAG, new Measurement(XFA.SHORT, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_SHORT, */ 0); // Added with CL77101 Dec 7, 2003
		putAttribute(XFA.MEDIUMTAG, EnumValue.getEnum(XFA.ORIENTATIONTAG, EnumAttr.getEnum(EnumAttr.PORTRAIT)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_ORIENTATION, */ 0); // Added with CL77101 Dec 7, 2003
		putAttribute(XFA.MEDIUMTAG, XFA.STOCKTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_STOCK, */ 0); // Added with CL77101 Dec 7, 2003
		putAttribute(XFA.MEDIUMTAG, EnumValue.getEnum(XFA.TRAYINTAG, EnumAttr.getEnum(EnumAttr.TRAYIN_AUTO)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_TRAYIN, */ 0); // Added with CL77101 Dec 7, 2003
		putAttribute(XFA.MEDIUMTAG, EnumValue.getEnum(XFA.TRAYOUTTAG, EnumAttr.getEnum(EnumAttr.TRAYOUT_AUTO)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_TRAYOUT, */ 0); // Added with CL77101 Dec 7, 2003

		// oids
		// Added with CL130260 May 20, 2004
		putPropAttrs(XFA.OIDSTAG);
		putAttribute(XFA.OIDSTAG, EnumValue.getEnum(XFA.TYPETAG, EnumAttr.getEnum(EnumAttr.REQUIREMENT_OPTIONAL)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_TYPE, */ 0); // Added with CL130260 May 20, 2004
		putElement(XFA.OIDSTAG, XFA.OIDTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_OID, */ 0); // Added with CL130260 May 20, 2004

		// oid
		// Added with CL130260 May 20, 2004
		putChildAttrs(XFA.OIDTAG);
		putElement(XFA.OIDTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_TEXTNODE_OID, */ 0); // Added with CL130260 May 20, 2004

		// pageArea
		// Removed surface attribute CL60040 Jul 4, 2003
		// Removed proto element with CL60776 Jul 15, 2003.
		putPropAttrs(XFA.PAGEAREATAG);
		putAttribute(XFA.PAGEAREATAG, XFA.NAMETAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_NAME, */ 0);
		putAttribute(XFA.PAGEAREATAG, EnumValue.getEnum(XFA.PAGEPOSITIONTAG, EnumAttr.getEnum(EnumAttr.PAGEPOSITION_ANY)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_PAGEPOSITION, */ 0); // Added with CL271273 Jan 27, 2006
		putAttribute(XFA.PAGEAREATAG, EnumValue.getEnum(XFA.ODDOREVENTAG, EnumAttr.getEnum(EnumAttr.ODDOREVEN_ANY)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_ODDOREVEN, */ 0);  // Added with CL271273 Jan 27, 2006
		putAttribute(XFA.PAGEAREATAG, EnumValue.getEnum(XFA.BLANKORNOTBLANKTAG, EnumAttr.getEnum(EnumAttr.BLANKORNOTBLANK_ANY)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_BLANKORNOTBLANK, */ 0);  // Added with CL271273 Jan 27, 2006
	//	putAttribute(XFA.PAGEAREATAG, XFA.BLANKTAG, moIntZero);  // Commented with CL271273 Jan 27, 2006
		putAttribute(XFA.PAGEAREATAG, XFA.INITIALNUMBERTAG, new Int(XFA.INITIALNUMBER, 1), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_INITIALNUMBER, */ 0); // Added with CL60790 Jul 16, 2003
		putAttribute(XFA.PAGEAREATAG, XFA.NUMBEREDTAG, new Int(XFA.NUMBERED, 1), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_NUMBERED, */ 0);
		putAttribute(XFA.PAGEAREATAG, XFA.RELEVANTTAG, new StringAttr(XFA.RELEVANT, ""), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RELEVANT, */ 0); // Added with CL54894 May 16, 2003
		putElement(XFA.PAGEAREATAG, XFA.CONTENTAREATAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_CONTENTAREA, */ 0);
		putElement(XFA.PAGEAREATAG, XFA.DESCTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DESC, */ 0);
		putElement(XFA.PAGEAREATAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		putElement(XFA.PAGEAREATAG, XFA.MEDIUMTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_MEDIUM, */ 0);
		putElement(XFA.PAGEAREATAG, XFA.OCCURTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_OCCUR, */ 0);
		putElement(XFA.PAGEAREATAG, XFA.AREATAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_AREA, */ 0);
		putElement(XFA.PAGEAREATAG, XFA.DRAWTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_DRAW, */ 0);
		putElement(XFA.PAGEAREATAG, XFA.EXCLGROUPTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_EXCLGROUP, */ 0);
		putElement(XFA.PAGEAREATAG, XFA.FIELDTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET, /* XFA_IS_CHILDDESC_FIELD, */ 0); // Subset
		putElement(XFA.PAGEAREATAG, XFA.SUBFORMTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET, /* XFA_IS_CHILDDESC_SUBFORM, */ 0); // Subset

		// pageSet
		// Removed duplex attribute CL60106 Jul 7, 2003
		// Removed relation element CL60005 Jul 4, 2003
		// Removed initialNumber attribute CL60299 Jul 9, 2003
		putPropAttrs(XFA.PAGESETTAG);
		putAttribute(XFA.PAGESETTAG, XFA.NAMETAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_NAME, */ 0);
		putAttribute(XFA.PAGESETTAG, XFA.RELEVANTTAG, new StringAttr(XFA.RELEVANT, ""), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RELEVANT, */ 0); // Added with CL54894 May 16, 2003
		putAttribute(XFA.PAGESETTAG, EnumValue.getEnum(XFA.RELATIONTAG, EnumAttr.getEnum(EnumAttr.PAGESETRELATION_ORDERED_OCCURRENCE)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_RELATION_PAGESET, */ 0); // Added with CL271273 Jan 27, 2006
		putAttribute(XFA.PAGESETTAG, EnumValue.getEnum(XFA.DUPLEXIMPOSITIONTAG,	EnumAttr.getEnum(EnumAttr.DUPLEXIMPOSITION_LONGEDGE)), Schema.XFAVERSION_31, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_DUPLEXIMPOSITION, */ 0); // Added with 547714 20 April, 2009
		putElement(XFA.PAGESETTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		putElement(XFA.PAGESETTAG, XFA.OCCURTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_OCCUR, */ 0);
		putElement(XFA.PAGESETTAG, XFA.PAGEAREATAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_PAGEAREA, */ 0);
		putElement(XFA.PAGESETTAG, XFA.PAGESETTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_PAGESET, */ 0);

		// para
		// Added spaceAfter and spaceBefore attributes with CL71454 Oct 28, 2003 (renamed with CL76327 Nov 11, 2003)
		putPropAttrs(XFA.PARATAG);
		putAttribute(XFA.PARATAG, EnumValue.getEnum(XFA.HALIGNTAG, EnumAttr.getEnum(EnumAttr.HALIGN_LEFT)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_HALIGN_PARA, */ 0);
		putAttribute(XFA.PARATAG, EnumValue.getEnum(XFA.VALIGNTAG, EnumAttr.getEnum(EnumAttr.VALIGN_TOP)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_VALIGN_PARA, */ 0);
		putAttribute(XFA.PARATAG, XFA.LINEHEIGHTTAG, new Measurement(XFA.LINEHEIGHT, STRS.ZEROPT), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_LINEHEIGHT, */ 0);
		putAttribute(XFA.PARATAG, XFA.MARGINLEFTTAG, new Measurement(XFA.MARGINLEFT, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_MARGINLEFT, */ 0); // Added with CL71454 Oct 28, 2003
		putAttribute(XFA.PARATAG, XFA.MARGINRIGHTTAG, new Measurement(XFA.MARGINRIGHT, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_MARGINRIGHT, */ 0); // Added with CL71454 Oct 28, 2003
		putAttribute(XFA.PARATAG, XFA.ORPHANSTAG, new Int(XFA.ORPHANS, 0), Schema.XFAVERSION_28,  Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_ORPHANS, */ 0);
		putAttribute(XFA.PARATAG, XFA.PRESERVETAG, new StringAttr(XFA.PRESERVE, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_PRESERVE, */ 0);
		putAttribute(XFA.PARATAG, XFA.RADIXOFFSETTAG, new Measurement(XFA.RADIXOFFSET, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RADIXOFFSET, */ 0); // Added with CL66265 Sep 16, 2003
		putAttribute(XFA.PARATAG, XFA.SPACEABOVETAG, new Measurement(XFA.SPACEABOVE, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_SPACEABOVE, */ 0); // Added with CL76327 Nov 11, 2003
		putAttribute(XFA.PARATAG, XFA.SPACEBELOWTAG, new Measurement(XFA.SPACEBELOW, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_SPACEBELOW, */ 0); // Added with CL76327 Nov 11, 2003
		putAttribute(XFA.PARATAG, XFA.TABSDEFAULTTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TABDEFAULT, */ 0); // Added with CL59106 Jun 19, 2003 see also CL66498 Sep 18, 2003
		putAttribute(XFA.PARATAG, XFA.TABSTOPSTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TABSTOPS, */ 0); // Added with CL59106 Jun 19, 2003
		putAttribute(XFA.PARATAG, XFA.TEXTINDENTTAG, new Measurement(XFA.TEXTINDENT, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TEXTINDENT, */ 0); // Added with CL71454 Oct 28, 2003
		putAttribute(XFA.PARATAG, XFA.WIDOWSTAG, new Int(XFA.WIDOWS, 0), Schema.XFAVERSION_28,  Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_WIDOWS, */ 0);
		putAttribute(XFA.PARATAG, XFA.WORDSPACINGOPTIMUMTAG, new StringAttr(XFA.WORDSPACINGOPTIMUM, STRS.HUNDREDPERCENT), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_WORDSPACINGOPTIMUM, */ 0); // added for hyphenation
		putAttribute(XFA.PARATAG, XFA.WORDSPACINGMINIMUMTAG, new StringAttr(XFA.WORDSPACINGMINIMUM, STRS.HUNDREDPERCENT), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_WORDSPACINGMINIMUM, */ 0); 
		putAttribute(XFA.PARATAG, XFA.WORDSPACINGMAXIMUMTAG, new StringAttr(XFA.WORDSPACINGMAXIMUM, STRS.HUNDREDPERCENT), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_WORDSPACINGMAXIMUM, */ 0); 
		putElement(XFA.PARATAG, XFA.HYPHENATIONTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_HYPHENATION, */ 0);

		// reasons
		// Added with CL130260 May 20, 2004
		putPropAttrs(XFA.REASONSTAG);
		putAttribute(XFA.REASONSTAG, EnumValue.getEnum(XFA.TYPETAG, EnumAttr.getEnum(EnumAttr.REQUIREMENT_OPTIONAL)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_TYPE_REASONS, */ 0); // Added with CL130260 May 20, 2004
		putElement(XFA.REASONSTAG, XFA.REASONTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_REASON, */ 0); // Added with CL130260 May 20, 2004

		// reason
		// Added with CL130260 May 20, 2004
		putChildAttrs(XFA.REASONTAG);
		putElement(XFA.REASONTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_TEXTNODE_REASON, */ 0); 

		// ref
		// Added with CL107961 Feb 27, 2004
		// Removed signedState with CL130260 May 20, 2004
		putPropAttrs(XFA.REFTAG);
		putElement(XFA.REFTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTNODE_REF, */ 0); // Added with CL108649 Mar 1, 2004

		// renderCache
		addForeignSchema(SVGSchema.getSVGSchema()); // Added with CL328070 Aug 29, 2006
		// TODO JavaPort: Enable the rest of the SVG schema.
//		putForeignElement(XFA.RENDERASTAG, SVG.SVGTAG, ChildReln.getZeroOrOne(), SVGSchema.getSVGSchema(), 0, Schema.XFAAVAILABILITY_ALL, /* XFA_IS_CHILDDESC_SVG, */ 0);
		putAttribute(XFA.RENDERASTAG, XFA.APIVERSIONTAG, null, 0, Schema.XFAAVAILABILITY_ALL, /* XFA_IS_CHILDDESC_SVG, */ 0); // Added with CL328070 Aug 29, 2006

		// signData
		// Added with CL130260 May 20, 2004
		// Added signatureProperties with CL130260 May 20, 2004
		// Removd signatureProperties with CL262678 Dec 20, 2005
		putPropAttrs(XFA.SIGNDATATAG);
		putAttribute(XFA.SIGNDATATAG, XFA.REFTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_REF_SIGNDATA, */ 0); // Added with CL130260 May 20, 2004
		putAttribute(XFA.SIGNDATATAG, XFA.TARGETTAG, null, Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_TARGET_SIGNDATA, */ 0); // Added with CL130260 May 20, 2004
		putAttribute(XFA.SIGNDATATAG, EnumValue.getEnum(XFA.OPERATIONTAG, EnumAttr.getEnum(EnumAttr.SIGNOPERATION_SIGN)), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_OPERATION_SIGNDATA, */ 0); // Added with CL130260 May 20, 2004
		putElement(XFA.SIGNDATATAG, XFA.MANIFESTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_MANIFEST, */ 0); // Added with CL130260 May 20, 2004
		putElement(XFA.SIGNDATATAG, XFA.FILTERTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_FILTER, */ 0); // Added with CL130260 May 20, 2004

		// Removed unSigner attribute with CL62912 Aug 13, 2003
		// Removed manifest element with CL62912 Aug 13, 2003
		// Added manifest with CL107961 Feb 27, 2004
		// Removed manifest with CL130260 May 20, 2004
		putPropAttrs(XFA.SIGNATURETAG);
		putAttribute(XFA.SIGNATURETAG, EnumValue.getEnum(XFA.TYPETAG, EnumAttr.getEnum(EnumAttr.PDF_13)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_TYPE_SIGNATURE, */ 0); // Added with CL62912 Aug 13, 2003
		putElement(XFA.SIGNATURETAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0); // Added with CL62912 Aug 13, 2003
		putElement(XFA.SIGNATURETAG, XFA.BORDERTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BORDER, */ 0); // Added with CL68896 Oct 6, 2003
		putElement(XFA.SIGNATURETAG, XFA.MARGINTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_MARGIN, */ 0); // Added with CL68896 Oct 6, 2003
		putElement(XFA.SIGNATURETAG, XFA.MANIFESTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_MANIFEST, */ 0); // Added with CL262678 Dec 20, 2005
		putElement(XFA.SIGNATURETAG, XFA.FILTERTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_FILTER, */ 0); // Added with CL262678 Dec 20, 2005

		// signing
		// Added with CL130260 May 20, 2004
		putPropAttrs(XFA.SIGNINGTAG);
		putAttribute(XFA.SIGNINGTAG, EnumValue.getEnum(XFA.TYPETAG, EnumAttr.getEnum(EnumAttr.REQUIREMENT_OPTIONAL)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_ATTRDESC_TYPE, */ 0); // Added with CL130260 May 20, 2004
		putElement(XFA.SIGNINGTAG, XFA.CERTIFICATETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_PLUGIN, /* XFA_IS_CHILDDESC_CERTIFICATE, */ 0); // Added with CL130260 May 20, 2004

		// speak
		// Added with CL38709 Aug 13, 2002
		putPropAttrs(XFA.SPEAKTAG);
		putAttribute(XFA.SPEAKTAG, EnumValue.getEnum(XFA.DISABLETAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_DISABLE, */ 0); // Added with CL38709 Aug 13, 2002
		putAttribute(XFA.SPEAKTAG, EnumValue.getEnum(XFA.PRIORITYTAG, EnumAttr.getEnum(EnumAttr.PRIORITY_CUSTOM)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_PRIORITY, */ 0); // Added with CL70412 Oct 17, 2003
		putAttribute(XFA.SPEAKTAG, XFA.RIDTAG, null, Schema.XFAVERSION_27, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RID, */ 0); // Added June 2006
		putElement(XFA.SPEAKTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTNODE_SPEAK, */ 0); // Added with CL38709 Aug 13, 2002

		// subform
		// Removed rotate attribute with CL52833 Apr 30, 2003
		// Removed value child with CL52911 Apr 30, 2003
		// Removed accessKey atribute with CL59257 June 23, 2003
		// Removed value element CL60110 Jul 7, 2003
		// Removed access attribute CL60307 Jul 9, 2003
		// Removed caption element CL60313 Jul 9, 2003
		// Added language attribute with CL65253 Sep 8, 2003
		putChildAttrs(XFA.SUBFORMTAG);
		putAttribute(XFA.SUBFORMTAG, XFA.LOCALETAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_LOCALE, */ 0); // Added with CL67841 Sep 30, 2003
		putAttribute(XFA.SUBFORMTAG, EnumValue.getEnum(XFA.ANCHORTYPETAG, EnumAttr.getEnum(EnumAttr.TOP_LEFT)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_ANCHORTYPE, */ 0);
		putAttribute(XFA.SUBFORMTAG, EnumValue.getEnum(XFA.ALLOWMACROTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_ALLOWMACRO, */ 0);
		putAttribute(XFA.SUBFORMTAG, XFA.COLSPANTAG, new Int(XFA.COLSPAN, 1), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_COLSPAN, */ 0); // Added with CL59922 July 3, 2003
		putAttribute(XFA.SUBFORMTAG, XFA.COLUMNWIDTHSTAG, new StringAttr(XFA.COLUMNWIDTHS, ""), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_COLUMNWIDTHS, */ 0); // Added table attribute with CL59416 June 24, 2003	
		putAttribute(XFA.SUBFORMTAG, EnumValue.getEnum(XFA.LAYOUTTAG, EnumAttr.getEnum(EnumAttr.POSITION)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_LAYOUT, */ 0);
		putAttribute(XFA.SUBFORMTAG, XFA.XTAG, new Measurement(XFA.X, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_X, */ 0);
		putAttribute(XFA.SUBFORMTAG, XFA.YTAG, new Measurement(XFA.Y, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_Y, */ 0);
		putAttribute(XFA.SUBFORMTAG, XFA.HTAG, new Measurement(XFA.H, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_H, */ 0);
		putAttribute(XFA.SUBFORMTAG, XFA.WTAG, new Measurement(XFA.W, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_W, */ 0);
		putAttribute(XFA.SUBFORMTAG, EnumValue.getEnum(XFA.HALIGNTAG, EnumAttr.getEnum(EnumAttr.HALIGN_LEFT)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_HALIGN, */ 0);
		putAttribute(XFA.SUBFORMTAG, EnumValue.getEnum(XFA.VALIGNTAG, EnumAttr.getEnum(EnumAttr.VALIGN_TOP)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_VALIGN, */ 0);
		putAttribute(XFA.SUBFORMTAG, XFA.MINHTAG, new Measurement(XFA.MINH, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_MINH, */ 0);
		putAttribute(XFA.SUBFORMTAG, XFA.MINWTAG, new Measurement(XFA.MINW, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_MINW, */ 0);
		putAttribute(XFA.SUBFORMTAG, XFA.MAXHTAG, new Measurement(XFA.MAXH, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_MAXH, */ 0);
		putAttribute(XFA.SUBFORMTAG, XFA.MAXWTAG, new Measurement(XFA.MAXW, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_MAXW, */ 0);
		putAttribute(XFA.SUBFORMTAG, EnumValue.getEnum(XFA.PRESENCETAG, EnumAttr.getEnum(EnumAttr.PRESENCE_VISIBLE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_PRESENCE, */ 0);
		putAttribute(XFA.SUBFORMTAG, XFA.RELEVANTTAG, new StringAttr(XFA.RELEVANT, ""), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RELEVANT, */ 0); // Added with CL54894 May 16, 2003
		putAttribute(XFA.SUBFORMTAG, EnumValue.getEnum(XFA.SCOPETAG, EnumAttr.getEnum(EnumAttr.SCOPE_NAME)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_SCOPE, */ 0); // Added with CL65242 Sep 8, 2003
		putAttribute(XFA.SUBFORMTAG, EnumValue.getEnum(XFA.RESTORESTATETAG, EnumAttr.getEnum(EnumAttr.RESTORESTATE_MANUAL)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RESTORESTATE, */ 0); // Added with CL291994 Apr 18, 2006
		putAttribute(XFA.SUBFORMTAG, EnumValue.getEnum(XFA.ACCESSTAG, EnumAttr.getEnum(EnumAttr.ACCESS_OPEN)), Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_ACCESS, */ 0);
		putAttribute(XFA.SUBFORMTAG, EnumValue.getEnum(XFA.MERGEMODETAG, EnumAttr.getEnum(EnumAttr.MERGEMODE_CONSUMEDATA)), Schema.XFAVERSION_31, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_MERGEMODE, */ 0); // Added  May 29, 2009
		putElement(XFA.SUBFORMTAG, XFA.BINDTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BIND, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.BORDERTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_BORDER, */ 0);
		//<break> has been deprecated, see http://xtg.can.adobe.com/twiki/bin/view/XFA/ConditionalBreakXFAV24Proposal
		putElement(XFA.SUBFORMTAG, XFA.BREAKTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_BREAK, Schema.XFAVERSION_24, */ 0);	
		putElement(XFA.SUBFORMTAG, XFA.BREAKBEFORETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_BREAKBEFORE, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.BREAKAFTERTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_BREAKAFTER, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.BOOKENDTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_BOOKEND, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.OVERFLOWTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_OVERFLOW, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.DESCTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DESC, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.EVENTTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EVENT, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.VARIABLESTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_VARIABLES, */ 0); // Added with CL62308 Aug 6, 2003
		putElement(XFA.SUBFORMTAG, XFA.KEEPTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_KEEP, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.MARGINTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_MARGIN, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.OCCURTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_OCCUR, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.PARATAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_PARA, */ XFAVERSION_33); //deprecated
		putElement(XFA.SUBFORMTAG, XFA.TRAVERSALTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TRAVERSAL, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.VALIDATETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_VALIDATE, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.CALCULATETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_CALCULATE, */ 0); // Added with CL69911 Oct 15, 2003
		putElement(XFA.SUBFORMTAG, XFA.AREATAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_AREA, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.DRAWTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DRAW, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.EXCLGROUPTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXCLGROUP, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.EXOBJECTTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXOBJECT, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.FIELDTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_FIELD, */ 0); // Subset
		putElement(XFA.SUBFORMTAG, XFA.PROTOTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_PROTO, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.SETPROPERTYTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_SETPROPERTY, */ 0); // Added with CL181307 Mar 4, 2005
		putElement(XFA.SUBFORMTAG, XFA.SUBFORMTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_SUBFORM, */ 0); // Subset
		putElement(XFA.SUBFORMTAG, XFA.SUBFORMSETTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_SUBFORMSET, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.PAGESETTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_PAGESET, */ 0);
		putElement(XFA.SUBFORMTAG, XFA.CONNECTTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_CONNECT, */ 0); // Added with CL79323 Dec 22, 2003
		putElement(XFA.SUBFORMTAG, XFA.ASSISTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_22, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_ASSIST, */ 0); // Added with CL 139919 July 15, 2004

		// subformSet
		putPropAttrs(XFA.SUBFORMSETTAG);
		putAttribute(XFA.SUBFORMSETTAG, XFA.NAMETAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_NAME, */ 0);
		putAttribute(XFA.SUBFORMSETTAG, EnumValue.getEnum(XFA.RELATIONTAG, EnumAttr.getEnum(EnumAttr.RELATION_ORDERED)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_ATTRDESC_RELATION, */ 0);
		putAttribute(XFA.SUBFORMSETTAG, XFA.RELEVANTTAG, new StringAttr(XFA.RELEVANT, ""), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RELEVANT, */ 0); // Added with CL54894 May 16, 2003
		//<break> has been deprecated, see http://xtg.can.adobe.com/twiki/bin/view/XFA/ConditionalBreakXFAV24Proposal
		putElement(XFA.SUBFORMSETTAG, XFA.BREAKTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_DYNAMIC, /* XFA_IS_CHILDDESC_BREAK, Schema.XFAVERSION_24, */ 0); // Added with CL38709 Aug 13, 2002
		putElement(XFA.SUBFORMSETTAG, XFA.BREAKBEFORETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_DYNAMIC, /* XFA_IS_CHILDDESC_BREAKBEFORE, */ 0);
		putElement(XFA.SUBFORMSETTAG, XFA.BREAKAFTERTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_DYNAMIC, /* XFA_IS_CHILDDESC_BREAKAFTER, */ 0);
		putElement(XFA.SUBFORMSETTAG, XFA.BOOKENDTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BOOKEND, */ 0);
		putElement(XFA.SUBFORMSETTAG, XFA.OVERFLOWTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_OVERFLOW, */ 0);
		putElement(XFA.SUBFORMSETTAG, XFA.OCCURTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_OCCUR, */ 0);
		putElement(XFA.SUBFORMSETTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);
		putElement(XFA.SUBFORMSETTAG, XFA.SUBFORMTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET, /* XFA_IS_CHILDDESC_SUBFORM, */ 0); // Subset
		putElement(XFA.SUBFORMSETTAG, XFA.SUBFORMSETTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE, /* XFA_IS_CHILDDESC_SUBFORMSET, */ 0);
		putElement(XFA.SUBFORMSETTAG, XFA.DESCTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DESC, */ 0); // Added with CL60872 Jul 17, 2003

		// submit
		// Removed method attribute with CL50044 April 9th, 2004
		putPropAttrs(XFA.SUBMITTAG);
		putAttribute(XFA.SUBMITTAG, EnumValue.getEnum(XFA.EMBEDPDFTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_EMBEDPDF, */ 0); // Added CL50044 April 9th, 2004
		putAttribute(XFA.SUBMITTAG, XFA.TARGETTAG, new StringAttr(XFA.TARGET, ""), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TARGET_SUBMIT, */ 0);
		putAttribute(XFA.SUBMITTAG, EnumValue.getEnum(XFA.FORMATTAG, EnumAttr.getEnum(EnumAttr.FORMAT_XDP)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_FORMAT_SUBMIT, */ 0);
		putAttribute(XFA.SUBMITTAG, XFA.XDPCONTENTTAG, new StringAttr(XFA.XDPCONTENT, ""), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_XDPCONTENT, */ 0); // Added CL50044 April 9th, 2004
		putAttribute(XFA.SUBMITTAG, XFA.TEXTENCODINGTAG, new StringAttr(XFA.TEXTENCODING, ""), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TEXTENCODING, */ 0); // Added CL50044 April 9th, 2004
		putElement(XFA.SUBMITTAG, XFA.SIGNDATATAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_SIGNDATA, */ 0); // Added with CL282305 Mar 14, 2006
		putElement(XFA.SUBMITTAG, XFA.ENCRYPTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_ENCRYPT, */ 0); // Added with CL290595 Apr 12, 2006

		// template
		// Removed proto, desc and dSigData elements with CL60776 Jul 15, 2003.
		putAttribute(XFA.TEMPLATETAG, EnumValue.getEnum(XFA.BASEPROFILETAG, EnumAttr.getEnum(EnumAttr.BASEPROFILE_FULL)), Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_BASEPROFILE, */ 0); // Added with CL289148 Apr 7, 2006
		putElement(XFA.TEMPLATETAG, XFA.SUBFORMTAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFASUBSET | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_SUBFORM, */ 0); // Subset
		putElement(XFA.TEMPLATETAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// toolTip
		putPropAttrs(XFA.TOOLTIPTAG);
		putAttribute(XFA.TOOLTIPTAG, XFA.RIDTAG, null, Schema.XFAVERSION_27, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RID, */ 0); // Added June 2006
		putElement(XFA.TOOLTIPTAG, XFA.TEXTNODETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXTNODE_TOOLTIP, */ 0);

		// traversal
		putPropAttrs(XFA.TRAVERSALTAG);
		putAttribute(XFA.TRAVERSALTAG, EnumValue.getEnum(XFA.PASSTHROUGHTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_DEPRECATED, /* XFA_IS_ATTRDESC_PASSTHROUGH, */ Schema.XFAVERSION_26); // Deprecated
		putElement(XFA.TRAVERSALTAG, XFA.TRAVERSETAG, ChildReln.getZeroOrMore(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TRAVERSE, */ 0);
		putElement(XFA.TRAVERSALTAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// traverse
		// Removed link element CL60005 Jul 4, 2003
		// Removed ref element CL60005 Jul 4, 2003
		putPropAttrs(XFA.TRAVERSETAG);
		putAttribute(XFA.TRAVERSETAG, EnumValue.getEnum(XFA.DELEGATETAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_DEPRECATED, /* XFA_IS_ATTRDESC_DELEGATE, */ Schema.XFAVERSION_26); // Deprecated
		putAttribute(XFA.TRAVERSETAG, EnumValue.getEnum(XFA.OPERATIONTAG, EnumAttr.getEnum(EnumAttr.OPERATION_NEXT)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_OPERATION_TRAVERSE, */ 0);
		putAttribute(XFA.TRAVERSETAG, XFA.REFTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_REF_TRAVERSE, */ 0); // Added as an attribute CL60005 Jul 4, 2003
		putElement(XFA.TRAVERSETAG, XFA.SCRIPTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_SCRIPT_TRAVERSE, */ 0);
		putElement(XFA.TRAVERSETAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0);

		// value
		// Removed link element CL60005 Jul 4, 2003
		// Removed ref element CL60005 Jul 4, 2003
		// Removed defaulted attribute CL60113 Jul 7, 2003
		// Removed sigData element CL60326 Jul 9, 2003
		putPropAttrs(XFA.VALUETAG);
		putAttribute(XFA.VALUETAG, EnumValue.getEnum(XFA.OVERRIDETAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_OVERRIDE_VALUE, */ 0);
		putAttribute(XFA.VALUETAG, XFA.RELEVANTTAG, new StringAttr(XFA.RELEVANT, ""), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_RELEVANT, */ 0); // Added with CL185847 Mar 22, 2005
		putElement(XFA.VALUETAG, XFA.ARCTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_ARC, */ 0);
		putElement(XFA.VALUETAG, XFA.BOOLEANTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_BOOLEAN, */ 0);
		putElement(XFA.VALUETAG, XFA.DATETAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DATE, */ 0);
		putElement(XFA.VALUETAG, XFA.DATETIMETAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DATETIME, */ 0);
		putElement(XFA.VALUETAG, XFA.DECIMALTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_DECIMAL, */ 0);
		putElement(XFA.VALUETAG, XFA.EXDATATAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXDATA, */ 0);
		putElement(XFA.VALUETAG, XFA.FLOATTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_FLOAT, */ 0);
		putElement(XFA.VALUETAG, XFA.IMAGETAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_IMAGE, */ 0);
		putElement(XFA.VALUETAG, XFA.INTEGERTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_INTEGER, */ 0);
		putElement(XFA.VALUETAG, XFA.LINETAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_LINE, */ 0);
		putElement(XFA.VALUETAG, XFA.RECTANGLETAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_RECTANGLE, */ 0);
		putElement(XFA.VALUETAG, XFA.TEXTTAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TEXT, */ 0);
		putElement(XFA.VALUETAG, XFA.TIMETAG, ChildReln.getOneOfChild(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_TIME, */ 0);

		// rectangle
		putPropAttrs(XFA.RECTANGLETAG);
		putAttribute(XFA.RECTANGLETAG, EnumValue.getEnum(XFA.HANDTAG, EnumAttr.getEnum(EnumAttr.HAND_EVEN)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_HAND, */ 0);
		putElement(XFA.RECTANGLETAG, XFA.EDGETAG, moZeroOrMore4, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EDGE, */ 0);
		putElement(XFA.RECTANGLETAG, XFA.CORNERTAG, moZeroOrMore4, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_CORNER, */ 0);
		putElement(XFA.RECTANGLETAG, XFA.FILLTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_FILL, */ 0);

		// barcode
		// Added with CL59830 Jul 2, 2003
		// Added type attribute with CL59830 Jul 2, 2003
		// Removed moduleHeightVariable, moduleWidthVariable, padding, parity,
		// quietZone, serialize, type, validDataChar, validEndChar and
		// validStartChar with CL62233 Aug 5, 2003
		// Removed errorCorrectionPercent attribute with CL65355 Sep 8, 2003
		// Removed startingMode attribute with CL65355 Sep 8, 2003
		putPropAttrs(XFA.BARCODETAG);
		putAttribute(XFA.BARCODETAG, XFA.DATACOLUMNCOUNTTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_DATACOLUMNCOUNT, */ 0); // Added with CL59830 Jul 2, 2003
		putAttribute(XFA.BARCODETAG, XFA.DATALENGTHTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_DATALENGTH, */ 0); // Added with CL64498 Aug 28, 2003
		putAttribute(XFA.BARCODETAG, EnumValue.getEnum(XFA.DATAPREPTAG, EnumAttr.getEnum(EnumAttr.DATAPREP_NONE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_DATAPREP, */ 0); // Added with CL125529 Apr 28, 2004
		putAttribute(XFA.BARCODETAG, XFA.DATAROWCOUNTTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_DATAROWCOUNT, */ 0);
		putAttribute(XFA.BARCODETAG, XFA.CHARENCODINGTAG, new StringAttr(XFA.CHARENCODING, STRS.UTF8STR), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_CHARENCODING, */ 0); // Added with CL203825 May 27, 2005
		putAttribute(XFA.BARCODETAG, EnumValue.getEnum(XFA.CHECKSUMTAG, EnumAttr.getEnum(EnumAttr.CHECKSUM_NONE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_CHECKSUM, */ 0); // Added with CL59830 Jul 2, 2003
		putAttribute(XFA.BARCODETAG, XFA.ENDCHARTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_ENDCHAR, */ 0); // Added with CL59830 Jul 2, 2003
		putAttribute(XFA.BARCODETAG, XFA.ERRORCORRECTIONLEVELTAG, new StringAttr(XFA.ERRORCORRECTIONLEVEL, "0"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_ERRORCORRECTIONLEVEL, */ 0); // Added with CL59830 Jul 2, 2003
		putAttribute(XFA.BARCODETAG, XFA.MODULEHEIGHTTAG, new Measurement(XFA.MODULEHEIGHT, "5mm"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_MODULEHEIGHT, */ 0); // Added with CL59830 Jul 2, 2003
		putAttribute(XFA.BARCODETAG, XFA.MODULEWIDTHTAG, new Measurement(XFA.MODULEWIDTH, "0.25mm"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_MODULEWIDTH, */ 0); // Added with CL59830 Jul 2, 2003
		putAttribute(XFA.BARCODETAG, EnumValue.getEnum(XFA.PRINTCHECKDIGITTAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_PRINTCHECKDIGIT, */ 0); // Added wth CL61716 Jul 28, 2003
		putAttribute(XFA.BARCODETAG, XFA.ROWCOLUMNRATIOTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_ROWCOLUMNRATIO, */ 0); // Added with CL59830 Jul 2, 2003
		putAttribute(XFA.BARCODETAG, XFA.STARTCHARTAG, null, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_STARTCHAR, */ 0); // Added with CL59830 Jul 2, 2003
		putAttribute(XFA.BARCODETAG, EnumValue.getEnum(XFA.TEXTLOCATIONTAG, EnumAttr.getEnum(EnumAttr.TEXTLOCATION_BELOW)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TEXTLOCATION, */ 0); // Added with CL59830 Jul 2, 2003
		putAttribute(XFA.BARCODETAG, EnumValue.getEnum(XFA.TRUNCATETAG, EnumAttr.getEnum(EnumAttr.BOOL_FALSE)), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TRUNCATE, */ 0); // Added with CL59830 Jul 2, 2003
		putAttribute(XFA.BARCODETAG, XFA.TYPETAG, new StringAttr(XFA.TYPE, ""), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_TYPE_BARCODE, */ 0); // Added with CL67755 Sep 29, 2003
		putAttribute(XFA.BARCODETAG, EnumValue.getEnum(XFA.UPSMODETAG, EnumAttr.getEnum(EnumAttr.UPSMODE_USCARRIER)), Schema.XFAVERSION_26, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_UPSMODE, */ 0); // Added with CL334068 Sep 21, 2006
		putAttribute(XFA.BARCODETAG, XFA.WIDENARROWRATIOTAG, new StringAttr(XFA.WIDENARROWRATIO, "3:1"), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_ATTRDESC_WIDENARROWRATIO, */ 0); // Added with CL59830 Jul 2, 2003
		putElement(XFA.BARCODETAG, XFA.ENCRYPTTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_ENCRYPT, */ 0); // Added with CL187178 Mar 29, 2005
		putElement(XFA.BARCODETAG, XFA.EXTRASTAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_EXTRAS, */ 0); // Added with CL59830 Jul 2, 2003	

		// encrypt
		// Added with CL187178 Mar 29, 2005
		putPropAttrs(XFA.ENCRYPTTAG);
		putElement(XFA.ENCRYPTTAG, XFA.CERTIFICATETAG, ChildReln.getZeroOrOne(), Schema.XFAVERSION_24, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_XFAF, /* XFA_IS_CHILDDESC_CERTIFICATE, */ 0); // Added with CL187178 Mar 29, 2005
	}
	
	protected Element newElement(int eTag, Element parent, Node prevSibling) {
		switch (eTag) {
		case XFA.PROTOTAG: return new com.adobe.xfa.Proto(parent, prevSibling);
		case XFA.BINDTAG: return new com.adobe.xfa.template.binding.Bind(parent, prevSibling);
		case XFA.BINDITEMSTAG: return new com.adobe.xfa.template.binding.BindItems(parent, prevSibling);
		case XFA.SETPROPERTYTAG: return new com.adobe.xfa.template.binding.SetProperty(parent, prevSibling);
		case XFA.DATETIMEEDITTAG: return new com.adobe.xfa.template.ui.DateTimeEdit(parent, prevSibling);
		case XFA.COLORTAG: return new com.adobe.xfa.template.formatting.Color(parent, prevSibling);
		case XFA.CONNECTTAG: return new com.adobe.xfa.template.binding.Connect(parent, prevSibling);
		case XFA.DATETAG: return new com.adobe.xfa.content.DateValue(parent, prevSibling);
		case XFA.DATETIMETAG: return new com.adobe.xfa.content.DateTimeValue(parent, prevSibling);
		case XFA.DECIMALTAG: return new com.adobe.xfa.content.DecimalValue(parent, prevSibling);
		case XFA.FLOATTAG: return new com.adobe.xfa.content.FloatValue(parent, prevSibling);
		case XFA.INTEGERTAG: return new com.adobe.xfa.content.IntegerValue(parent, prevSibling);
		case XFA.TEXTTAG: return new com.adobe.xfa.content.TextValue(parent, prevSibling);
		case XFA.TIMETAG: return new com.adobe.xfa.content.TimeValue(parent, prevSibling);
		case XFA.EXDATATAG: return new com.adobe.xfa.content.ExDataValue(parent, prevSibling);
		case XFA.FILLTAG: return new com.adobe.xfa.template.formatting.Fill(parent, prevSibling);
		case XFA.ITEMSTAG: return new com.adobe.xfa.template.Items(parent, prevSibling);
		case XFA.KEEPTAG: return new com.adobe.xfa.template.formatting.Keep(parent, prevSibling);
		case XFA.MARGINTAG: return new com.adobe.xfa.template.formatting.Margin(parent, prevSibling);
		case XFA.OCCURTAG: return new com.adobe.xfa.template.formatting.Occur(parent, prevSibling);
		case XFA.TEXTEDITTAG: return new com.adobe.xfa.template.ui.TextEdit(parent, prevSibling);
		case XFA.UITAG: return new com.adobe.xfa.template.ui.UI(parent, prevSibling);
		case XFA.IMAGETAG: return new com.adobe.xfa.content.ImageValue(parent, prevSibling);
		case XFA.PICTURETAG: return new com.adobe.xfa.template.formatting.Picture(parent, prevSibling);
		case XFA.SCRIPTTAG: return new com.adobe.xfa.template.automation.Script(parent, prevSibling);
		case XFA.LINEARTAG: return new com.adobe.xfa.template.formatting.Linear(parent, prevSibling);
		case XFA.BOOLEANTAG: return new com.adobe.xfa.content.BooleanValue(parent, prevSibling);
		case XFA.VARIABLESTAG: return new com.adobe.xfa.template.containers.Variables(parent, prevSibling);
		case XFA.AREATAG: return new com.adobe.xfa.template.containers.AreaContainer(parent, prevSibling);
		case XFA.BORDERTAG: return new com.adobe.xfa.template.formatting.Border(parent, prevSibling);
		case XFA.CAPTIONTAG: return new com.adobe.xfa.template.formatting.Caption(parent, prevSibling);
		case XFA.CONTENTAREATAG: return new com.adobe.xfa.template.containers.ContentArea(parent, prevSibling);
		case XFA.DRAWTAG: return new com.adobe.xfa.template.containers.Draw(parent, prevSibling);
		case XFA.EVENTTAG: return new com.adobe.xfa.template.automation.EventTag(parent, prevSibling);
		case XFA.EXCLGROUPTAG: return new com.adobe.xfa.template.containers.ExclGroup(parent, prevSibling);
		case XFA.FIELDTAG: return new com.adobe.xfa.template.containers.Field(parent, prevSibling);
		case XFA.MANIFESTTAG: return new com.adobe.xfa.Manifest(parent, prevSibling);
		case XFA.PAGEAREATAG: return new com.adobe.xfa.template.containers.PageArea(parent, prevSibling);
		case XFA.PAGESETTAG: return new com.adobe.xfa.template.containers.PageSet(parent, prevSibling);
		case XFA.SUBFORMTAG: return new com.adobe.xfa.template.containers.Subform(parent, prevSibling);
		case XFA.SUBFORMSETTAG: return new com.adobe.xfa.template.containers.SubformSet(parent, prevSibling);
		case XFA.TEMPLATETAG: return new com.adobe.xfa.template.TemplateModel(parent, prevSibling);
		case XFA.TRAVERSETAG: return new com.adobe.xfa.template.sequencing.Traverse(parent, prevSibling);
		case XFA.VALUETAG: return new com.adobe.xfa.template.Value(parent, prevSibling);
		case XFA.RECTANGLETAG: return new com.adobe.xfa.content.RectangleValue(parent, prevSibling);
		case XFA.CALCULATETAG: return new com.adobe.xfa.template.automation.Calculate(parent, prevSibling);
		case XFA.BUTTONTAG: return new com.adobe.xfa.template.formatting.Button(parent, prevSibling);
		
		case XFA.ASSISTTAG:
		case XFA.CERTIFICATESTAG:
		case XFA.SUBJECTDNSTAG:
		case XFA.SUBJECTDNTAG:
		case XFA.KEYUSAGETAG:
		case XFA.DEFAULTUITAG:
		case XFA.SOLIDTAG:
		case XFA.BREAKTAG:
		case XFA.CHOICELISTTAG:
		case XFA.BREAKBEFORETAG:
		case XFA.BREAKAFTERTAG:
		case XFA.OVERFLOWTAG:
		case XFA.BOOKENDTAG:
		case XFA.FILTERTAG:
		case XFA.MDPTAG:
		case XFA.TIMESTAMPTAG:
		case XFA.ENCODINGSTAG:
		case XFA.ENCODINGTAG:
		case XFA.DIGESTMETHODSTAG:
		case XFA.DIGESTMETHODTAG:
		case XFA.DESCTAG:
		case XFA.FONTTAG:
		case XFA.FORMATTAG:
		case XFA.ISSUERSTAG:
		case XFA.MESSAGETAG:
		case XFA.IMAGEEDITTAG:
		case XFA.NUMERICEDITTAG:
		case XFA.PASSWORDEDITTAG:
		case XFA.VALIDATETAG:
		case XFA.PATTERNTAG:
		case XFA.RADIALTAG:
		case XFA.CORNERTAG:
		case XFA.EDGETAG:
		case XFA.EXTRASTAG:
		case XFA.STIPPLETAG:
		case XFA.ARCTAG:
		case XFA.CHECKBUTTONTAG:
		case XFA.COMBTAG:
		case XFA.EXOBJECTTAG:
		case XFA.EXECUTETAG:
		case XFA.LINETAG:
		case XFA.MEDIUMTAG:
		case XFA.OIDSTAG:
		case XFA.PARATAG:
		case XFA.REASONSTAG:
		case XFA.RENDERASTAG:
		case XFA.SIGNDATATAG:
		case XFA.SIGNATURETAG:
		case XFA.SIGNINGTAG:
		case XFA.SUBMITTAG:
		case XFA.TRAVERSALTAG:
		case XFA.BARCODETAG:
		case XFA.ENCRYPTTAG:
		case XFA.HYPHENATIONTAG:
			return new com.adobe.xfa.GenericNode(parent, prevSibling);
			
		case XFA.CERTIFICATETAG:
		case XFA.HANDLERTAG:
		case XFA.OIDTAG:
		case XFA.REASONTAG:
		case XFA.REFTAG:
		case XFA.SPEAKTAG:
		case XFA.TOOLTIPTAG:
		case XFA.APPEARANCEFILTERTAG:
		case XFA.LOCKDOCUMENTTAG:
			return new com.adobe.xfa.GenericTextContainer(parent, prevSibling);
			
		default:
			return null;
		}
	}
}
