/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template.formatting;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.XFA;

/**
 * This class implements the functionality represented by the XFA <border>
 * element.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */

public final class Border extends ProtoableNode {
	public Border(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.BORDER, XFA.BORDER, null,
				XFA.BORDERTAG, XFA.BORDER);
	}

	/**
	 * @see Element#defaultAttribute(int)
	 * @exclude
	 */
	public Attribute defaultAttribute(int eTag) {
		// If we're an unspecified property, the default value of presence is
		// hidden.
		if (eTag == XFA.PRESENCETAG && isDefault(true))
			return EnumValue.getEnum(XFA.PRESENCETAG, EnumAttr.getEnum(EnumAttr.PRESENCE_HIDDEN));

		// Not special case, so let the base class handle it
		return super.defaultAttribute(eTag);
	}

	/**
	 * @see Element#defaultElementImpl(int, int, boolean)
	 * @exclude from published api.
	 */	
	protected Node defaultElementImpl(int eTag, int nOccurrence, boolean bAppend /* = true */) {
		if (eTag == XFA.SCHEMA_DEFAULTTAG)
			eTag = defaultElement();

		if (eTag == XFA.SCHEMA_DEFAULTTAG)
			return null;
		
		Element e = null;

		if (nOccurrence == 0) {
			String className = XFA.getString(eTag);
			Element parent = bAppend ? this : null;
			e = getModel().createElement(parent, getLastXMLChild(), null,
					className, className, null, 0, null);
		}
		else if (nOccurrence == 1) { // Default to 1st element
			if (bAppend) {
				e = getElement(eTag, false, 0, false, false).clone(this, true);
			}
			else {
				Element source = getElement(eTag, true, 0, false, false);
				if (source != null)
					e = source.clone(null, true);
				else
					e = getModel().createElement(eTag, null);
			}
		}
		else if (nOccurrence == 2) // 3rd occurrence defaults to same as 1st
		{
			// Make sure the 2nd node exists so when the 3rd node gets appended
			// it's in the 3rd spot
			if (bAppend) {
				getElement(eTag, false, 1, false, false);
				e = getElement(eTag, false, 0, false, false).clone(this, true);
			}
			else {
				Element source = getElement(eTag, true, 0, false, false);
				if (source != null)
					e = source.clone(null, true);
				else
					e = getModel().createElement(eTag, null);
			}
		}
		else if ((nOccurrence == 3) || getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V27_SCRIPTING)) {
			// 4th property should be the same as the 2nd.
			// First make sure the 3rd node exists so when the 4th gets appended
			// it's in the correct position
			if (bAppend) {
				getElement(eTag, false, 2, false, false);
				e = getElement(eTag, false, 1, false, false).clone(this, true);
			}
			else {
				// now try the first
				Element source = getElement(eTag, true, 0, false, false);
				if (source != null) {
					e = source.clone(null, true);
				}
				else {				
					getElement(eTag, false, 1, false, false);
					e = getElement(eTag, false, 1, false, false).clone(null, true);
				}
			}
		}
		
		if (e != null)
			e.isTransient(true, false);
		
		return e;
	}
	
	/**
	 * @see ProtoableNode#isContextSensitiveAttribute(int)
	 * @exclude from published api.
	 */
	public boolean isContextSensitiveAttribute(int eTag) {
		return eTag == XFA.PRESENCETAG || 
			super.isContextSensitiveAttribute(eTag);
	}

}
