/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.sitecatalyst;

import com.day.cq.wcm.webservicesupport.Configuration;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * Context for Analytics pageName resolution. Provides access to key context
 * objects like {@link Framework} and {@link Resource}.
 */
public final class AnalyticsPageNameContext {
    
    public static final String S_PAGE_NAME = "pageName";
    
    private final Configuration configuration;
    private final Framework framework;
    private final ResourceResolver resourceResolver;
    private final Resource resource;
    private final String basePath;
    private String pageName;

    public AnalyticsPageNameContext(Configuration configuration,
            Framework framework, ResourceResolver resourceResolver,
            Resource resource, String pageName,String basePath) {
        this.configuration = configuration;
        this.framework = framework;
        this.resourceResolver = resourceResolver;
        this.resource = resource;
        this.pageName = pageName;
        this.basePath = basePath;
    }

    /**
     * Getter for {@link Configuration}
     * 
     * @return the {@link Configuration} that defines the respective mapping
     */
    public Configuration getConfiguration() {
        return configuration;
    }

    /**
     * Getter for {@link Framework}
     * 
     * @return the {@link Framework} that defines the respective mapping
     */
    public Framework getFramework() {
        return framework;
    }

    /**
     * Getter for {@link ResourceResolver}
     * 
     * @return the {@link ResourceResolver}
     */
    public ResourceResolver getResourceResolver() {
        return resourceResolver;
    }

    /**
     * Getter for {@link Resource}
     * 
     * @return the {@link Resource} that should be mapped
     */
    public Resource getResource() {
        return resource;
    }

    /**
     * Getter for pageName
     * 
     * @return the pageName that should be mapped to a {@link Resource} in case
     *         {@link AnalyticsPageNameResolver#getResource(AnalyticsPageNameContext)}
     *         is called. Otherwise this can be {@code null}.
     */
    public String getPageName() {
        return pageName;
    }

    /**
     * Setter for pageName
     *
     * @param pageName
     *            the pageName that should be mapped to a {@link Resource} in
     *            case
     *            {@link AnalyticsPageNameResolver#getResource(AnalyticsPageNameContext)}
     *            is called. Otherwise this can be {@code null}.
     */
    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    /**
     * Getter for basePath
     * 
     * @return the basePath of the mapping. this is typically the path of the
     *         resource where the {@link Configuration} is set (parent of
     *         {@link Resource} or pageName). This can be {@code null}.
     */
    public String getBasePath() {
        return basePath;
    }
}
