/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.sitecatalyst;

import org.apache.sling.commons.json.JSONObject;

/**
 * Represents a variable filter for filtering out variables from the final
 * result set.
 */
public interface Filter {

    /**
     * Returns true if variable is of the correct type, false otherwise.
     * 
     * @param obj
     *            Variable object
     * @return true if variable has needed properties, false otherwise
     */
    public Boolean filter(JSONObject obj);
    
    /**
     * Returns <code>true</code> if one of its properties does contain the query
     * string, <code>false</code> otherwise.
     * 
     * @param obj
     *            Variable object
     * @param query
     *            Query string
     * @return true if variable contains query string, false otherwise
     */
    public Boolean indexOf(JSONObject obj, String query); 

    /**
     * Returns a String representation of a JS array for this JSONObject.
     * 
     * @param obj
     *            Variable object
     * @return String representaiton of a JS array (i.e ['evar1','My evar
     *         (eVar)'])
     */
    public String getJSArray(JSONObject obj);

}