/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/
package com.day.cq.analytics.sitecatalyst.util;

import org.apache.commons.lang.StringUtils;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class AnalyticsVariableUtil {
    private AnalyticsVariableUtil(){}

    public static int extractNumberFromID(JSONObject jsonObj) throws JSONException {
        if (jsonObj != null) {
            String id = jsonObj.getString("id");
            if (id != null) {
                id = id.replaceAll("\\D+","");
                if (!StringUtils.isBlank(id)) {
                    return Integer.parseInt(id);
                }
            }
        }
        return -1;
    }
}
