/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons.feed;

import org.apache.sling.api.resource.Resource;
import java.io.IOException;
import java.util.Iterator;

/**
 * The <code>Feed</code> interface is used to print a resource as a feed.
 */
public interface Feed {

    /** The default content type */
    public static final String DEFAULT_CONTENT_TYPE = "text/xml";

    /** The default character encoding */
    public static final String DEFAULT_CHARACTER_ENCODING = "utf-8";

    /** The request selector for feeds */
    public static final String SELECTOR_FEED = "feed";

    /** The request selector for feed entries */
    public static final String SELECTOR_FEEDENTRY = "feedentry";

    /** The request selector for Atom-formatted feeds (default) */
    public static final String SELECTOR_ATOM = "atom";

    /** The request selector for RSS-formatted feeds */
    public static final String SELECTOR_RSS = "rss";

    /** The suffix for HTML links */
    public static final String SUFFIX_HTML = ".html";

    /** The suffix for XML links */
    public static final String SUFFIX_XML = ".xml";

    /** The suffix for feed links */
    public static final String SUFFIX_FEED = "." + SELECTOR_FEED + SUFFIX_XML;

    /** The suffix for feed entry links */
    public static final String SUFFIX_FEEDENTRY = "." + SELECTOR_FEEDENTRY + SUFFIX_XML;

    /** The suffix for comment links */
    public static final String SUFFIX_COMMENTS = SUFFIX_HTML + "#comments";

    /**
     * Returns the content type of the feed.
     * @return The type
     */
    public String getContentType();

    /**
     * Returns the character encoding of the feed.
     * @return The encoding
     */
    public String getCharacterEncoding();

    /**
     * Writes the feed header.
     * @throws IOException If output fails
     */
    public void printHeader() throws IOException;

    /**
     * Prints the current resource as a feed entry.
     * @throws IOException If output fails
     */
    public void printEntry() throws IOException;

    /**
     * Prints the specified resource as a feed entry
     * @param res the resource
     * @throws IOException If output fails
     */
    public void printEntry(Resource res) throws IOException;

    /**
     * Prints the children of the current resource as feed entries
     * @throws IOException If output fails
     */
    public void printChildEntries() throws IOException;

    /**
     * Prints the children of the current resource as feed entries
     * @param max The maximum number of entries
     * @throws IOException If output fails
     */
    public void printChildEntries(int max) throws IOException;

    /**
     * Prints the specified resources as feed entries
     * @param iter The resources
     * @throws IOException If output fails
     */
    public void printEntries(Iterator<Resource> iter) throws IOException;

    /**
     * Prints the specified resources as feed entries
     * @param iter The resources
     * @param max The maximum number of entries
     * @throws IOException If output fails
     */
    public void printEntries(Iterator<Resource> iter, int max) throws IOException;

    /**
     * Writes the feed footer.
     * @throws IOException If output fails
     */
    public void printFooter() throws IOException;

}
