/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.video;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.handler.ffmpeg.FFMpegWrapper;
import com.day.image.Layer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

import static com.day.cq.dam.api.DamConstants.THUMBNAIL_MIMETYPE;

/**
 * <code>StoryBoard</code>...
 */
public class StoryBoard {

    private static final Logger log = LoggerFactory.getLogger(StoryBoard.class);

    private final List<String> framesList = new LinkedList<String>();

    private final FFMpegWrapper wrapper;
    private final Asset asset;

    private int frames = 10;
    private int start = 0;
    private int maxWidth = 320;
    private int maxHeight = 240;
    private boolean upscale = true;

    public StoryBoard(final FFMpegWrapper wrapper, final Asset asset) {
        this.wrapper = wrapper;
        this.asset = asset;

        if (null == wrapper) {
            throw new IllegalArgumentException("wrapper may not be null");
        }

        if (null == asset) {
            throw new IllegalArgumentException("asset may not be null");
        }
    }

    public void setFrames(final int frames) {
        this.frames = frames;
    }

    public void setStart(final int start) {
        this.start = start;
    }

    public void setMaxWidth(final int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setMaxHeight(final int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setUpscale(final boolean upscale) {
        this.upscale = upscale;
    }

    public synchronized void addFrame(final String config) {
        framesList.add(config);
    }

    public void create() throws IOException {

        //todo: support individual frames config
        //todo: support maxWidth / maxHeight / upscale config

        final BufferedImage[] frames = wrapper.getThumbnails(this.frames, start);
        log.debug("got [{}] thumbs to be processed as key frames for [{}]...", frames.length, asset.getPath());
        int i = 0;
        File tmpFile = null;

        try {
            tmpFile = File.createTempFile("keyframe." + System.currentTimeMillis(), ".tmp");

            for (final BufferedImage frame : frames) {

                if (null == frame) {
                    log.warn("encountered null frame at index [{}] for asset [{}]", i, asset.getPath());
                } else {

                    log.debug("processing frame [{}] for [{}]...", i, asset.getPath());

                    final Layer l = new Layer(frame);
                    FileOutputStream out = null;
                    InputStream in = null;

                    try {
                        out = new FileOutputStream(tmpFile);
                        l.write(THUMBNAIL_MIMETYPE, 0.8, out);
                        in = new FileInputStream(tmpFile);

                        final Asset sub = asset.addSubAsset(
                                asset.getName() + ".keyframe." + (i + 1) + ".png",
                                THUMBNAIL_MIMETYPE,
                                in);

                        log.info("created key frame sub-asset [{}] for [{}],", sub.getPath(), asset.getPath());
                    } finally {
                        IOUtils.closeQuietly(in);
                        IOUtils.closeQuietly(out);
                    }
                }
                i++;
            }
        } catch (Exception e) {
            log.error("failed creating storyboard for [{}]: ", asset.getPath(), e);
        } finally {
            if (null != tmpFile) {
                tmpFile.delete();
            }
        }
    }
}
