/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.mailer;

import aQute.bnd.annotation.ProviderType;
import org.apache.sling.api.resource.ResourceResolver;

import javax.jcr.RepositoryException;
import javax.jcr.Session;

/**
 * Service Interface to send a <i>Mailing</i><br>
 * A Mailing is a {@link com.day.cq.mailer.MessageTemplate MessageTemplate} that
 * is intended to be send to a List of recipients.
 * <p>
 * @since 5.4
 */
@ProviderType
public interface MailingService {

    /**
     * @param mailingId to access the MailingStatus
     * @return or <code>null</code> if the mailing has not be sent does not exist
     * @throws javax.jcr.RepositoryException in case of an exception accessing
     * the Repository
     * @see com.day.cq.mailer.MailingStatus#getMailingID() ;
     * @deprecated It's recommended to use {@link #getStatus(String, javax.jcr.Session)} instead.
     */
    @Deprecated
    MailingStatus getStatus(String mailingId) throws RepositoryException;

    /**
     * @param mailingId to access the MailingStatus
     * @param session to read the Node having MailingStatus
     * @return or <code>null</code> if the mailing has not be sent does not exist
     * @throws javax.jcr.RepositoryException in case of an exception accessing
     * the Repository
     * @see com.day.cq.mailer.MailingStatus#getMailingID() ;
     */
    MailingStatus getStatus(String mailingId, Session session) throws RepositoryException;

    /**
     * Send a {@link com.day.cq.mailer.impl.Mailing Mailing} to.<br>
     *
     * @param message to be send
     * @param recipients of the message
     * @param resourceResolver Resource resolver
     * @return the mailing created for send
     * @throws MailingException in case the sending could not be started
     * @throws javax.jcr.AccessDeniedException in case the session lacks privileges to send the Mailing
     * @throws RepositoryException in case of error accessing the Repository
     * @throws MailingException If an error occurs
     */
    MailingStatus send(MessageTemplate message, AuthorizableMailingList recipients, ResourceResolver resourceResolver )
            throws MailingException, RepositoryException;
}