/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.replication;

import java.util.Map;

/**
 * <code>ConfigManager</code>...
 */
public interface ConfigManager {

    /**
     * Returns a map of all agent configuration groups.
     * @return a map where the key is the configuration group path
     */
    Map<String, AgentConfigGroup> getConfigGroups();

    /**
     * Returns a map of all agent configurations of all run modes.
     * @return a map where the key is the configuration id
     */
    Map<String, AgentConfig> getConfigurations();


    /**
     * Registers a listener to receive configuration event changes
     * @param listener the listener
     */
    void registerListener(ConfigEventListener listener);

    /**
     * Unregisters a previously registered listener.
     * @param listener the listener
     */
    void unregisterListener(ConfigEventListener listener);

    /**
     * Interface for configuration event listeners.
     */
    interface ConfigEventListener {

        /**
         * Invoked when a configuration event happened.
         * @param evt the event
         */
        void onConfigEvent(ConfigEvent evt);

    }

    /**
     * Interface for configuration event
     */
    interface ConfigEvent {

        /**
         * The event type
         */
        enum Type {

            /**
             * A new configuration was added
             */
            ADDED,

            /**
             * A configuration was updated
             */
            UPDATED,

            /**
             * A configuration was removed
             */
            REMOVED
        }

        /**
         * Returns the event type
         * @return the type
         */
        Type getType();

        /**
         * Returns the id of the configuration that changed
         * @return the id.
         */
        String getId();
    }

}