/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2022 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.replication;

/**
 * The <code>Location</code> can be used to convey information about a repository path.
 */
public class Location {

    /**
     * Path of the location to replicate.
     */
    private final String path;

    /**
     * Revision version of the location to replicate.
     */
    private final String revision;

    /**
     * Creates an instance of the Location class.
     * @param path See {@link #getPath()}
     * @param revision See {@link #getRevision()}
     */
    public Location(String path, String revision) {
        this.path = path;
        this.revision = revision;
    }

    /**
     * Returns the file system path of the location to replicate.
     * @return the path of the location.
     */
    public String getPath() {
        return path;
    }

    /**
     * Returns the revision to replicate.
     * @return location replication revision.
     */
    public String getRevision() {
        return revision;
    }
}