/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.replication;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Session;

/**
 * Represents an outbox manager.
 */
public interface OutboxManager {

    /**
     * Returns the outbox with the given name. If no such outbox exists <code>null</code> is returned, unless
     * <code>autoCreate</code> is set to <code>true</code>.
     *
     * Note that the given session needs to be able to read and write nodes on an existing outbox, or needs to be
     * able to create nodes below the default outboxes path "/var/replication/outboxes".
     *
     * @param session the session to access the outbox
     * @param name name of the outbox.
     * @param autoCreate if <code>true</code> the outbox will be created if it does not exist
     *
     * @return the outbox or <code>null</code>
     * @throws ReplicationException if an error occurs.
     * @throws AccessDeniedException if the given session is not allowed to get or create the outbox.
     */
    @Nullable
    Outbox getOutbox(Session session, String name, boolean autoCreate) throws ReplicationException, AccessDeniedException;

    /**
     * Returns the default, anonymous outbox.
     * @param session the session to access the default outbox
     * @return the default outbox.
     * @throws ReplicationException if an error occurs.
     */
    @Nonnull
    Outbox getDefaultOutbox(Session session) throws ReplicationException;

    /**
     * Put item in the outbox.
     *
     * @param action replication action, must not be {@link ReplicationActionType#ACTIVATE}
     * @param in item data
     * @throws ReplicationException if an error occurs
     *
     * @deprecated since 5.12.4; use {@link #getDefaultOutbox(javax.jcr.Session)}.{@link Outbox#put(ReplicationAction, java.io.InputStream)} instead.
     */
    @Deprecated
    void put(ReplicationAction action, InputStream in) throws ReplicationException;

    /**
     * Put an empty item in the outbox with a replication action other than
     * {@link ReplicationActionType#ACTIVATE}.
     *
     * @param action replication action, must not be {@link ReplicationActionType#ACTIVATE}
     * @throws ReplicationException if an error occurs
     *
     * @deprecated since 5.12.4; use {@link #getDefaultOutbox(javax.jcr.Session)}.{@link Outbox#put(ReplicationAction)} instead.
     */
    @Deprecated
    void put(ReplicationAction action) throws ReplicationException;

    /**
     * Put item in the outbox. The implicit replication action of this item
     * is {@link ReplicationActionType#ACTIVATE}
     *
     * @param in item data
     * @throws ReplicationException if an error occurs
     *
     * @deprecated since 5.5 use {@link #put(ReplicationAction, java.io.InputStream)} instead.
     */
    @Deprecated
    void put(InputStream in) throws ReplicationException;

    /**
     * Fetch items from the outbox, having a last modified time greater than
     * the given optional time, automatically removing items that are older.
     *
     * @param session session to use
     * @param time if not <code>null</code>, all items older than this date
     *             are automatically purged from the outbox before returning the
     *             outbox's content
     * @param out output stream where to store a virtual durbo package named
     *            <code>outbox</code> with the items in the outbox as children
     * @throws ReplicationException if an error occurs
     *
     * @deprecated since 5.12.4; use {@link #getDefaultOutbox(javax.jcr.Session)}.{@link Outbox#fetch(java.util.Calendar, java.io.OutputStream)} instead.
     */
    @Deprecated
    void fetch(Session session, Calendar time, OutputStream out) throws ReplicationException;

    /**
     * To check that session's user has permissions to fetch items from outbox.
     * Returns true if session's user has permissions to fetch items from outbox
     * else returns false.
     * @param session session to use
     * @return true if session's user has permissions to fetch items from outbox else false.
     *
     * @deprecated since 5.12.4; use {@link #getDefaultOutbox(javax.jcr.Session)}} instead.
     */
    @Deprecated
    boolean checkPermission(Session session);
}
