/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.replication;

import java.io.Serializable;

/**
 * <code>ReplicationContentFacade</code>...
 */
public class ReplicationContentFacade implements Serializable {

    private static final long serialVersionUID = 7508545788476718741L;

    private final String path;

    private final String contentType;

    private final long contentLength;

    public ReplicationContentFacade(String path, String mimeType, long contentLength) {
        this.path = path;
        this.contentType = mimeType;
        this.contentLength = contentLength;
    }

    public String getPath() {
        return path;
    }

    public String getContentType() {
        return contentType;
    }

    public long getContentLength() {
        return contentLength;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder();
        sb.append("ReplicationContentFacade");
        sb.append("{path='").append(path).append('\'');
        sb.append(", contentType='").append(contentType).append('\'');
        sb.append(", contentLength=").append(contentLength);
        sb.append('}');
        return sb.toString();
    }
}