/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

/**
 * This interface defines a configuration service for the reporting framework.
 */
public interface ConfigService {

    /**
     * Get the timezone to be used for any timebased calculation
     *
     * @return The timezone
     */
    TimeZone getTimeZone();

    /**
     * Get the locale to be used for reporting
     *
     * @return The locale
     */
    Locale getLocale();

    /**
     * Get the first day of a week (using the constants provided by {@link Calendar}).
     *
     * @return The first day of a week
     */
    int getFirstDayOfWeek();

    /**
     * Get the base path for snapshot data.
     *
     * @return The base path for snapshot data
     */
    String getSnapshots();

    /**
     * Get the base path for reports.
     *
     * @return The base path for reports
     */
    String getReportPath();

    /**
     * Get the maximum number of rows persisted per snapshot.
     *
     * @return The maximum number of rows
     */
    Integer getMaxRows();

    /**
     * Get the hour of day daily snapshots are taken.
     *
     * @return The hour of day daily snapshots are taken
     */
    Integer getHourOfDay();

    /**
     * Get the minute of hour hourly snapshots are taken
     *
     * @return The minute of hour hourly snapshots are taken
     */
    Integer getMinuteOfHour();

    /**
     * Determines if creating fake data (using <code>FakeDataCreationServlet</code>) is
     * allowed. Fake data can only be created with <code>admin</code> session.
     *
     * @return <code>true</code> if creating fake data is allowed
     */
    boolean isFakeCreateAllowed();

    /**
     * Get the ID of the user historic snapshots are taken for.
     *
     * @return The user ID to create report snapshots for
     */
    String getSnapshotUserId();

    /**
     * Determines if snapshots are always taken for the user specified by
     * {@link #getSnapshotUserId()}, or if this user only works as a fallback if the
     * user that finished the report is not available anymore.
     *
     * @return <code>true</code> if the user specified by {@link #getSnapshotUserId()} is
     *         enforced for taking snapshots
     */
    boolean enforceSnapshotUser();

}
